/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Util3D;

public class TriSurface {
    public List<Tri> tris = new ArrayList<Tri>();
    public double totalWeight = 0.0;

    public boolean addTri(Point3d p1, Point3d p2, Point3d p3) {
        return this.addTri(new Tri(p1, p2, p3));
    }

    public boolean addTri(Tri tri) {
        if (tri.weight == 0.0) {
            return false;
        }
        this.tris.add(tri);
        this.totalWeight += tri.weight;
        return true;
    }

    public boolean addTris(Collection<Tri> tris) {
        boolean added = false;
        for (Tri tri : tris) {
            added |= this.addTri(tri);
        }
        return added;
    }

    public boolean addTris(Point3d[] points, int[] tris) {
        boolean added = false;
        int m = 0;
        while (m < tris.length) {
            Point3d p1 = points[tris[m++]];
            Point3d p2 = points[tris[m++]];
            Point3d p3 = points[tris[m++]];
            added |= this.addTri(p1, p2, p3);
        }
        return added;
    }

    public void addTris(TriSurface tris) {
        this.tris.addAll(tris.tris);
        this.totalWeight += tris.totalWeight;
    }

    public boolean isEmpty() {
        return this.tris.isEmpty();
    }

    public Supplier<Point3d> getPointGenerator(Random rgen) {
        if (this.tris.isEmpty()) {
            return () -> null;
        }
        if (this.tris.size() == 1) {
            Tri tri = this.tris.get(0);
            return () -> Util3D.getRandomPointInTri(tri.p1, tri.p2, tri.p3, rgen);
        }
        double[] triChoices = new double[this.tris.size()];
        double nextPos = 0.0;
        for (int m = 0; m < this.tris.size(); ++m) {
            Tri tri = this.tris.get(m);
            triChoices[m] = nextPos;
            nextPos += tri.weight / this.totalWeight;
        }
        return () -> {
            double listPos = rgen.nextDouble();
            int ix = Arrays.binarySearch(triChoices, listPos);
            if (ix < 0) {
                ix = -2 - ix;
            }
            Tri tri = this.tris.get(ix);
            return Util3D.getRandomPointInTri(tri.p1, tri.p2, tri.p3, rgen);
        };
    }

    public static class Tri {
        private final Point3d p1;
        private final Point3d p2;
        private final Point3d p3;
        private final double weight;

        public Tri(Point3d p1, Point3d p2, Point3d p3) {
            this(p1, p2, p3, Util3D.simplePolygonArea(Arrays.asList(p1, p2, p3)));
        }

        public Tri(Point3d p1, Point3d p2, Point3d p3, double weight) {
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.weight = weight;
        }

        public boolean isEmpty() {
            return this.weight != 0.0;
        }
    }
}

