/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Plane3d;

public class Solid3D {
    private final Vertex[] d_verts;
    private final Edge[] d_edges;
    private final Face[] d_faces;

    public Solid3D(Point3d[] ... facePoints) {
        this(Arrays.asList(facePoints));
    }

    /*
     * WARNING - void declaration
     */
    public Solid3D(Collection<Point3d[]> facePoints) {
        void var6_14;
        LinkedHashSet<Object> uniquePoints = new LinkedHashSet<Object>();
        for (Point3d[] points : facePoints) {
            for (Point3d point : points) {
                uniquePoints.add(point);
            }
        }
        this.d_verts = new Vertex[uniquePoints.size()];
        HashMap<Point3d, Integer> pointIxMap = new HashMap<Point3d, Integer>();
        int index = 0;
        for (Point3d point3d : uniquePoints) {
            pointIxMap.put(point3d, index);
            this.d_verts[index++] = new Vertex(point3d);
        }
        this.d_faces = new Face[facePoints.size()];
        index = 0;
        for (Point3d[] point3dArray : facePoints) {
            int[] faceIxes = new int[point3dArray.length];
            for (int m = 0; m < point3dArray.length; ++m) {
                faceIxes[m] = (Integer)pointIxMap.get(point3dArray[m]);
            }
            this.d_faces[index++] = new Face(faceIxes);
        }
        for (int vertix = 0; vertix < this.d_verts.length; ++vertix) {
            Vertex vertex = this.d_verts[vertix];
            block6: for (int faceix = 0; faceix < this.d_faces.length; ++faceix) {
                Face face = this.d_faces[faceix];
                for (int faceVertIx = 0; faceVertIx < face.d_ixes.length; ++faceVertIx) {
                    if (face.d_ixes[faceVertIx] != vertix) continue;
                    vertex.d_faces.add(face);
                    continue block6;
                }
            }
        }
        HashMap<EdgeKey, Edge> edges = new HashMap<EdgeKey, Edge>(this.d_verts.length);
        boolean bl = false;
        while (var6_14 < this.d_faces.length) {
            Face face = this.d_faces[var6_14];
            for (int edgeix1 = 0; edgeix1 < face.d_ixes.length; ++edgeix1) {
                int edgeVertIx2;
                int edgeix2 = (edgeix1 + 1) % face.d_ixes.length;
                int edgeVertIx1 = face.d_ixes[edgeix1];
                EdgeKey key = new EdgeKey(edgeVertIx1, edgeVertIx2 = face.d_ixes[edgeix2]);
                Edge edge = (Edge)edges.get(key);
                if (edge == null) {
                    edge = new Edge(edgeVertIx1, edgeVertIx2);
                    edge.d_face1 = face;
                    edges.put(key, edge);
                    continue;
                }
                edge.d_face2 = face;
            }
            ++var6_14;
        }
        this.d_edges = edges.values().toArray(new Edge[edges.size()]);
    }

    public Face[] getFaces() {
        return this.d_faces;
    }

    public Vertex[] getVerts() {
        return this.d_verts;
    }

    public Edge[] getEdges() {
        return this.d_edges;
    }

    private static class EdgeKey {
        private final int d_i1;
        private final int d_i2;

        private EdgeKey(int i1, int i2) {
            if (i1 <= i2) {
                this.d_i1 = i1;
                this.d_i2 = i2;
            } else {
                this.d_i1 = i2;
                this.d_i2 = i1;
            }
        }

        public int hashCode() {
            return this.d_i1 + this.d_i2;
        }

        public boolean equals(Object obj) {
            assert (obj instanceof EdgeKey);
            EdgeKey key2 = (EdgeKey)obj;
            return this.d_i1 == key2.d_i1 && this.d_i2 == key2.d_i2;
        }
    }

    public class Edge {
        private final int d_v1;
        private final int d_v2;
        private final Vector3d d_dir;
        private Face d_face1;
        private Face d_face2;

        private Edge(int v1, int v2) {
            this.d_v1 = v1;
            this.d_v2 = v2;
            this.d_dir = new Vector3d();
            this.d_dir.sub((Tuple3d)this.getP2().getLocation(), (Tuple3d)this.getP1().getLocation());
            this.d_dir.normalize();
        }

        public final Vertex getP1() {
            return Solid3D.this.d_verts[this.d_v1];
        }

        public final Vertex getP2() {
            return Solid3D.this.d_verts[this.d_v2];
        }

        public final Vector3d getDirection() {
            return this.d_dir;
        }

        public final Face getFace1() {
            return this.d_face1;
        }

        public final Face getFace2() {
            return this.d_face2;
        }
    }

    public class Vertex {
        private final Point3d d_loc;
        private final List<Face> d_faces;

        private Vertex(Point3d loc) {
            this.d_loc = loc;
            this.d_faces = new ArrayList<Face>(3);
        }

        public Point3d getLocation() {
            return this.d_loc;
        }

        public List<Face> getFaces() {
            return this.d_faces;
        }
    }

    public class Face {
        private final int[] d_ixes;
        private final Plane3d d_planeEq;

        private Face(int ... ixes) {
            assert (ixes.length >= 3);
            this.d_ixes = ixes;
            Point3d[] points = new Point3d[ixes.length];
            for (int m = 0; m < ixes.length; ++m) {
                points[m] = this.getVert(m).getLocation();
            }
            this.d_planeEq = new Plane3d(true, points);
        }

        public final Vertex getVert(int ix) {
            return Solid3D.this.d_verts[this.d_ixes[ix]];
        }

        public final Vertex[] getVerts() {
            Vertex[] verts = new Vertex[this.d_ixes.length];
            for (int m = 0; m < this.d_ixes.length; ++m) {
                verts[m] = Solid3D.this.d_verts[this.d_ixes[m]];
            }
            return verts;
        }

        public final Point3d[] getPoints() {
            Point3d[] points = new Point3d[this.d_ixes.length];
            for (int m = 0; m < this.d_ixes.length; ++m) {
                points[m] = Solid3D.this.d_verts[this.d_ixes[m]].getLocation();
            }
            return points;
        }

        public final double planeDot(Tuple3d p) {
            return this.d_planeEq.x * p.x + this.d_planeEq.y * p.y + this.d_planeEq.z * p.z + this.d_planeEq.w;
        }

        public final Plane3d getPlaneEquation() {
            return this.d_planeEq;
        }

        public final Vector3d getNormal() {
            return new Vector3d(this.d_planeEq.x, this.d_planeEq.y, this.d_planeEq.z);
        }
    }
}

