/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg2D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;

public class LineSeg3D
implements IParametric3D,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;

    public LineSeg3D(Point3d p1, Point3d p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    public Object clone() {
        return new LineSeg3D(new Point3d(this.p1), new Point3d(this.p2));
    }

    public Vector3d getDir() {
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)this.p2, (Tuple3d)this.p1);
        return dir;
    }

    public Vector3d getDirN() {
        Vector3d dir = this.getDir();
        dir.normalize();
        return dir;
    }

    @Override
    public Vector3d getTangent(double t) {
        return Util3D.vector(this.p1, this.p2);
    }

    public int hashCode() {
        return 153629939 + this.p1.hashCode() + this.p2.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LineSeg3D)) {
            return false;
        }
        LineSeg3D seg = (LineSeg3D)obj;
        return this.p1.equals((Tuple3d)seg.p1) && this.p2.equals((Tuple3d)seg.p2) || this.p1.equals((Tuple3d)seg.p2) && this.p2.equals((Tuple3d)seg.p1);
    }

    public Point3d getMidpoint() {
        return Util3D.getMidPoint(this.p1, this.p2);
    }

    @Override
    public Point3d get(double t) {
        return Util3D.linesegPoint(this.p1, this.p2, t);
    }

    public double getT(Point3d p) {
        return Util3D.tOnLineSeg(this.p1, this.p2, p);
    }

    public Point3d getP1() {
        return this.p1;
    }

    public Point3d getP2() {
        return this.p2;
    }

    public String toString() {
        return "LineSeg: " + this.p1 + " -> " + this.p2;
    }

    @Override
    public double length() {
        return this.p1.distance(this.p2);
    }

    public double lengthSq() {
        return this.p1.distanceSquared(this.p2);
    }

    public boolean lengthZero() {
        return this.p1.equals((Tuple3d)this.p2);
    }

    public AABox getBoundingBox() {
        double maxz;
        double minz;
        double maxy;
        double miny;
        double maxx;
        double minx;
        if (this.p1.x <= this.p2.x) {
            minx = this.p1.x;
            maxx = this.p2.x;
        } else {
            minx = this.p2.x;
            maxx = this.p1.x;
        }
        if (this.p1.y <= this.p2.y) {
            miny = this.p1.y;
            maxy = this.p2.y;
        } else {
            miny = this.p2.y;
            maxy = this.p1.y;
        }
        if (this.p1.z <= this.p2.z) {
            minz = this.p1.z;
            maxz = this.p2.z;
        } else {
            minz = this.p2.z;
            maxz = this.p1.z;
        }
        return new AABox(new Point3d(minx, miny, minz), new Point3d(maxx, maxy, maxz));
    }

    @Override
    public LineSeg3D transform(Matrix4d xform) {
        return new LineSeg3D(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.p2));
    }

    @Override
    public double getClosestT(Point3d point) {
        return Inter3D.nearestTOnLineSeg(this.p1, this.p2, point);
    }

    @Override
    public double[] getIsects(Plane3d plane, double tol) {
        double isectt = Inter3D.linePlaneIntersectionT(this.p1, this.getDir(), plane, tol);
        if (Double.isNaN(isectt = Util.clampTIfValid(isectt, 0.0, 1.0, tol))) {
            return new double[0];
        }
        return new double[]{isectt};
    }

    @Override
    public IParametric2D projectToPlane(Plane3d plane, Matrix4d wlXform) {
        Point3d p1p = plane.projectOntoPlane(this.p1);
        Point3d p2p = plane.projectOntoPlane(this.p2);
        wlXform.transform(p1p);
        wlXform.transform(p2p);
        return new LineSeg2D(new Point2d(p1p.x, p1p.y), new Point2d(p2p.x, p2p.y));
    }

    @Override
    public IParametric2D transform2D(Matrix4d xform) {
        Point3d p1t = Util3D.xform(xform, this.p1);
        Point3d p2t = Util3D.xform(xform, this.p2);
        return new LineSeg2D(new Point2d(p1t.x, p1t.y), new Point2d(p2t.x, p2t.y));
    }

    @Override
    public IParametric3D reverse() {
        return new LineSeg3D(this.p2, this.p1);
    }

    @Override
    public IParametric3D trim(double t1, double t2) {
        if (t1 == 0.0 && t2 == 1.0) {
            return this;
        }
        if (t2 == 0.0 && t1 == 1.0) {
            return this.reverse();
        }
        return new LineSeg3D(this.get(t1), this.get(t2));
    }
}

