/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import thunderheadeng.geometry.AParametric2D;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;

public class LineSeg2D
extends AParametric2D
implements IParametric2D {
    public final Point2d p1;
    public final Point2d p2;

    public LineSeg2D(Point2d p1, Point2d p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public double length() {
        return this.p1.distance(this.p2);
    }

    @Override
    public boolean isValid(double tol) {
        return !this.p1.epsilonEquals((Tuple2d)this.p2, tol);
    }

    @Override
    public void setBegin(Point2d p) {
        this.p1.set((Tuple2d)p);
    }

    @Override
    public void setEnd(Point2d p) {
        this.p2.set((Tuple2d)p);
    }

    @Override
    public boolean epsilonEquals(IParametric2D parm2, double tolerance) {
        if (this == parm2) {
            return true;
        }
        if (!(parm2 instanceof LineSeg2D)) {
            return false;
        }
        LineSeg2D seg = (LineSeg2D)parm2;
        return this.p1.epsilonEquals((Tuple2d)seg.p1, tolerance) && this.p2.epsilonEquals((Tuple2d)seg.p2, tolerance);
    }

    @Override
    public Point2d get(double t) {
        return Util2D.linePoint(this.p1, this.p2, t);
    }

    @Override
    public Vector2d getTangent(double t) {
        return Util2D.vector(this.p1, this.p2);
    }

    @Override
    public double getClosestT(Point2d point) {
        return Inter2D.nearestTOnLineSeg(point, this.p1, this.p2);
    }

    @Override
    public List<double[]> getLineIsects(Point2d l1, Vector2d dir, double tol) {
        double[] isect = Inter2D.isectLineLine(this.p1, Util2D.vector(this.p1, this.p2), l1, dir, tol);
        if (isect == null) {
            return Collections.EMPTY_LIST;
        }
        isect[0] = Util.clampTIfValid(isect[0], 0.0, 1.0, tol);
        if (Double.isNaN(isect[0])) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(new double[][]{isect});
    }

    @Override
    public List<double[]> getIsects(IParametric2D parm2, double tol) {
        List<double[]> isects = parm2.getLinesegIsects(this.p1, this.p2, tol);
        for (double[] isect : isects) {
            double temp = isect[0];
            isect[0] = isect[1];
            isect[1] = temp;
        }
        return isects;
    }

    @Override
    public List<double[][]> getAlignedSegs(IParametric2D parm2, double tol) {
        if (!(parm2 instanceof LineSeg2D)) {
            return Collections.EMPTY_LIST;
        }
        LineSeg2D ls = (LineSeg2D)parm2;
        double[][] aligned = Inter2D.lineSeglineSegOverlap(this.p1, this.p2, ls.p1, ls.p2, tol);
        if (aligned == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<double[][]> align = new ArrayList<double[][]>(1);
        align.add(aligned);
        return align;
    }

    @Override
    public IParametric2D subsegment(double t1, double t2) {
        t1 = Util.clampT(t1, 0.0, 1.0);
        t2 = Util.clampT(t2, 0.0, 1.0);
        return new LineSeg2D(this.get(t1), this.get(t2));
    }

    @Override
    public void append(Path2D.Double path) {
        path.lineTo(this.p2.x, this.p2.y);
    }

    @Override
    public IParametric2D reverse() {
        return new LineSeg2D(this.p2, this.p1);
    }

    public String toString() {
        return super.toString() + ": " + this.p1 + " -> " + this.p2;
    }
}

