/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RayAABoxTest;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IContainer;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class Inter3D {
    public static final double DBL_EPSILON = 1.0E-9;

    public static boolean linePlaneIntersection(Point3d intersection, Point3d l1, Point3d l2, Plane3d plane, double epsilon) {
        Vector3d lineDir = new Vector3d();
        lineDir.sub((Tuple3d)l2, (Tuple3d)l1);
        lineDir.normalize();
        return Inter3D.linePlaneIntersection(intersection, l1, lineDir, plane, epsilon);
    }

    public static double linePlaneIntersectionT(Point3d pointOnLine, Vector3d lineDir, Plane3d planeN, double epsilon) {
        double dot = lineDir.x * planeN.x + lineDir.y * planeN.y + lineDir.z * planeN.z;
        if (theUtil.eq0(dot, epsilon)) {
            return Double.NaN;
        }
        return -(planeN.w + planeN.x * pointOnLine.x + planeN.y * pointOnLine.y + planeN.z * pointOnLine.z) / dot;
    }

    public static boolean linePlaneIntersection(Point3d intersection, Point3d pointOnLine, Vector3d lineDir, Plane3d planeN, double epsilon) {
        double t = Inter3D.linePlaneIntersectionT(pointOnLine, lineDir, planeN, epsilon);
        if (Double.isNaN(t)) {
            return false;
        }
        intersection.x = pointOnLine.x + lineDir.x * t;
        intersection.y = pointOnLine.y + lineDir.y * t;
        intersection.z = pointOnLine.z + lineDir.z * t;
        return true;
    }

    public static Point3d linePlaneIntersection(Point3d pointOnLine, Vector3d lineDir, Plane3d planeN, double epsilon) {
        Point3d p = new Point3d();
        return Inter3D.linePlaneIntersection(p, pointOnLine, lineDir, planeN, epsilon) ? p : null;
    }

    public static Point3d lineSegPlaneIntersection(Point3d l1, Point3d l2, Plane3d plane, double epsilon) {
        double isectT = Inter3D.linePlaneIntersectionT(l1, Util3D.vector(l1, l2), plane, epsilon);
        if (Double.isNaN(isectT)) {
            return null;
        }
        if (Double.isNaN(isectT = Util.clampTIfValid(isectT, 0.0, 1.0, epsilon))) {
            return null;
        }
        return Util3D.linesegPoint(l1, l2, isectT);
    }

    public static Point3d rayPlaneIntersection(Point3d l1, Vector3d dir, Plane3d plane, double epsilon) {
        double isectT = Inter3D.linePlaneIntersectionT(l1, dir, plane, epsilon);
        if (Double.isNaN(isectT)) {
            return null;
        }
        if (Double.isNaN(isectT = Util.clampTIfValid(isectT, 0.0, Double.MAX_VALUE, epsilon))) {
            return null;
        }
        return Util3D.linePoint(l1, dir, isectT);
    }

    public static boolean lineXPlaneIntersection(Point3d intersection, Point3d pointOnLine, Vector3d lineDirN, double xVal, double epsilon) {
        if (theUtil.eq0(lineDirN.x, epsilon)) {
            return false;
        }
        double t = (xVal - pointOnLine.x) / lineDirN.x;
        intersection.x = xVal;
        intersection.y = pointOnLine.y + lineDirN.y * t;
        intersection.z = pointOnLine.z + lineDirN.z * t;
        return true;
    }

    public static boolean lineYPlaneIntersection(Point3d intersection, Point3d pointOnLine, Vector3d lineDirN, double yVal, double epsilon) {
        if (theUtil.eq0(lineDirN.y, epsilon)) {
            return false;
        }
        double t = (yVal - pointOnLine.y) / lineDirN.y;
        intersection.x = pointOnLine.x + lineDirN.x * t;
        intersection.y = yVal;
        intersection.z = pointOnLine.z + lineDirN.z * t;
        return true;
    }

    public static boolean lineZPlaneIntersection(Point3d intersection, Point3d pointOnLine, Vector3d lineDirN, double zVal, double epsilon) {
        if (theUtil.eq0(lineDirN.z, epsilon)) {
            return false;
        }
        double t = (zVal - pointOnLine.z) / lineDirN.z;
        intersection.x = pointOnLine.x + lineDirN.x * t;
        intersection.y = pointOnLine.y + lineDirN.y * t;
        intersection.z = zVal;
        return true;
    }

    public static Point3d lineZPlaneIntersection(Point3d pointOnLine, Vector3d lineDirN, double zVal, double epsilon) {
        Point3d p = new Point3d();
        return Inter3D.lineZPlaneIntersection(p, pointOnLine, lineDirN, zVal, epsilon) ? p : null;
    }

    public static boolean lineSegPolyIntersection(Point3d intersection, Point3d l1, Point3d l2, Vector3d lineDir, Plane3d polyPlane, double tol, Point3d ... polyPoints) {
        Point3d isect = Inter3D.lineSegPolyIntersection(l1, l2, polyPlane, tol, polyPoints);
        if (isect != null) {
            intersection.set((Tuple3d)isect);
            return true;
        }
        return false;
    }

    public static Point3d lineSegPolyIntersection(Point3d p1, Point3d p2, Plane3d polyPlane, double tol, Point3d ... polyPoints) {
        Point3d p;
        Vector3d lineDir = Util3D.vector(p1, p2);
        double t = Inter3D.linePlaneIntersectionT(p1, lineDir, polyPlane, tol);
        if (!Double.isNaN(t) && theUtil.ge0(t, tol) && theUtil.le(t, 1.0, tol) && Inter3D.pointInPoly(tol, p = Util3D.linePoint(p1, lineDir, t), polyPoints)) {
            return p;
        }
        return null;
    }

    public static Point3d linePolyIntersection(Point3d l1, Vector3d lineDir, Plane3d polyPlane, double tol, Point3d ... polyPoints) {
        Point3d isect = new Point3d();
        return Inter3D.linePolyIntersection(isect, l1, lineDir, polyPlane, tol, polyPoints) ? isect : null;
    }

    public static boolean linePolyIntersection(Point3d intersection, Point3d l1, Vector3d lineDir, Plane3d polyPlane, double tol, Point3d ... polyPoints) {
        assert (polyPoints.length >= 3);
        if (!Inter3D.linePlaneIntersection(intersection, l1, lineDir, polyPlane, 1.0E-9)) {
            return false;
        }
        return Inter3D.pointInPoly(tol, intersection, polyPoints);
    }

    public static boolean linePointIntersect(Point3d l1, Vector3d lineDirN, Point3d p, double tolSq) {
        Point3d pOnLine = Inter3D.linePointProximity(l1, lineDirN, p);
        Vector3d vec = new Vector3d();
        vec.sub((Tuple3d)p, (Tuple3d)pOnLine);
        double lengthSq = vec.lengthSquared();
        return lengthSq <= tolSq;
    }

    public static double nearestTOnLine(Point3d l1, Vector3d vec, Point3d p) {
        double lensq = vec.x * vec.x + vec.y * vec.y + vec.z * vec.z;
        double dx = p.x - l1.x;
        double dy = p.y - l1.y;
        double dz = p.z - l1.z;
        return (vec.x * dx + vec.y * dy + vec.z * dz) / lensq;
    }

    public static double nearestTOnLineSeg(Point3d l1, Point3d l2, Point3d p) {
        double v1x = l2.x - l1.x;
        double v1y = l2.y - l1.y;
        double v1z = l2.z - l1.z;
        double lensq = v1x * v1x + v1y * v1y + v1z * v1z;
        if (lensq == 0.0) {
            return 0.0;
        }
        double dx = p.x - l1.x;
        double dy = p.y - l1.y;
        double dz = p.z - l1.z;
        double dot = v1x * dx + v1y * dy + v1z * dz;
        if (dot <= 0.0) {
            return 0.0;
        }
        if (dot >= lensq) {
            return 1.0;
        }
        return dot / lensq;
    }

    public static double distSqToNearestPtOnLine(Point3d l1, Vector3d vec, Point3d p) {
        double lensq = vec.x * vec.x + vec.y * vec.y + vec.z * vec.z;
        double dx = p.x - l1.x;
        double dy = p.y - l1.y;
        double dz = p.z - l1.z;
        double dot = vec.x * dx + vec.y * dy + vec.z * dz;
        return dx * dx + dy * dy + dz * dz - dot * dot / lensq;
    }

    public static double distSqToNearestPtOnLineSeg(Point3d l1, Point3d l2, Point3d p) {
        double v1x = l2.x - l1.x;
        double v1y = l2.y - l1.y;
        double v1z = l2.z - l1.z;
        double lensq = v1x * v1x + v1y * v1y + v1z * v1z;
        if (lensq == 0.0) {
            return p.distanceSquared(l1);
        }
        double v2x = p.x - l1.x;
        double v2y = p.y - l1.y;
        double v2z = p.z - l1.z;
        double dot = v1x * v2x + v1y * v2y + v1z * v2z;
        if (dot <= 0.0) {
            return p.distanceSquared(l1);
        }
        if (dot >= lensq) {
            return p.distanceSquared(l2);
        }
        return Math.max(0.0, v2x * v2x + v2y * v2y + v2z * v2z - dot * dot / lensq);
    }

    public static Point3d nearestPointOnLine(Point3d l1, Vector3d vec, Point3d p) {
        double t = Inter3D.nearestTOnLine(l1, vec, p);
        return Util3D.linePoint(l1, vec, t);
    }

    public static Point3d nearestPointOnLineSeg(Point3d l1, Point3d l2, Point3d p) {
        double t = Inter3D.nearestTOnLineSeg(l1, l2, p);
        return Util3D.linesegPoint(l1, l2, t);
    }

    public static Point3d copLineSegLineSeg(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double tolerance) {
        double[] st = Inter3D.copLineSegLineSegT(l1a, l1b, l2a, l2b, tolerance);
        if (st == null) {
            return null;
        }
        return Util3D.linesegPoint(l1a, l1b, st[0]);
    }

    public static double[] copLineSegLineSegT(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double tolerance) {
        double[] st;
        Vector3d b;
        Vector3d a = Util3D.vector(l1a, l1b);
        if (!Inter3D.copLineLine(l1a, a, l2a, b = Util3D.vector(l2a, l2b), st = new double[2], tolerance)) {
            return null;
        }
        if (!Util.clampTIfValid(st, 0.0, 1.0, tolerance)) {
            return null;
        }
        return st;
    }

    public static boolean areCoplanar(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double tol) {
        Plane3d plane = new Plane3d(true, l1a, l1b, l2a);
        double dot = plane.dot(l2b);
        return Math.abs(dot) <= tol;
    }

    public static boolean copLineLine(Point3d l1a, Vector3d a, Point3d l2a, Vector3d b, double[] st, double valTol) {
        assert (st.length >= 2);
        Vector3d acb = Util3D.cross(a, b);
        double acbLenSq = acb.lengthSquared();
        if (theUtil.eq0(Math.sqrt(acbLenSq), valTol)) {
            return false;
        }
        double invACBLenSq = 1.0 / acbLenSq;
        Vector3d c = Util3D.vector(l1a, l2a);
        Vector3d temp = new Vector3d();
        temp.cross(c, b);
        st[0] = Util3D.dot((Tuple3d)temp, (Tuple3d)acb) * invACBLenSq;
        acb.negate();
        c.negate();
        temp.cross(c, a);
        st[1] = Util3D.dot((Tuple3d)temp, (Tuple3d)acb) * invACBLenSq;
        return true;
    }

    public static boolean copLineLineSeg(Point3d l1a, Vector3d l1Dir, Point3d l2a, Point3d l2b, double[] st, double valTol, double epsTol) {
        Vector3d l2Dir = Util3D.vector(l2a, l2b);
        if (!Inter3D.copLineLine(l1a, l1Dir, l2a, l2Dir, st, valTol)) {
            return false;
        }
        st[1] = Util.clampTIfValid(st[1], 0.0, 1.0, epsTol);
        return !Double.isNaN(st[1]);
    }

    public static Point3d linePointProximity(Point3d l1, Vector3d lineDirN, Point3d p) {
        Vector3d dir = new Vector3d(lineDirN);
        Vector3d pvec = new Vector3d();
        pvec.sub((Tuple3d)p, (Tuple3d)l1);
        double dot = dir.dot(pvec);
        dir.scale(dot);
        Point3d pOnLine = new Point3d();
        pOnLine.add((Tuple3d)l1, (Tuple3d)dir);
        return pOnLine;
    }

    public static Point3d lineLineSegIntersection(Point3d l1a, Vector3d line1Dir, Point3d l2a, Point3d l2b, double tolSq) {
        Vector3d line2Dir = new Vector3d();
        line2Dir.sub((Tuple3d)l2b, (Tuple3d)l2a);
        return Inter3D.lineLineSegIntersection(l1a, line1Dir, l2a, l2b, line2Dir, tolSq);
    }

    public static Point3d lineLineSegIntersection(Point3d l1a, Vector3d line1Dir, Point3d l2a, Point3d l2b, Vector3d line2Dir, double tolSq) {
        Point3d p1 = new Point3d();
        Point3d p2 = new Point3d();
        boolean prox = Inter3D.lineLineSegProximity(p1, p2, l1a, line1Dir, l2a, l2b, line2Dir);
        if (!prox) {
            return null;
        }
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)p2, (Tuple3d)p1);
        double lengthSq = diff.lengthSquared();
        if (lengthSq <= tolSq) {
            return p1;
        }
        return null;
    }

    public static double[] lineSegLineSegIntersection(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double tol) {
        Point3d pl2;
        double[] proxt = Inter3D.lineSegLineSegProximityT(l1a, l1b, l2a, l2b, tol);
        if (proxt == null) {
            return null;
        }
        Point3d pl1 = Util3D.linesegPoint(l1a, l1b, proxt[0]);
        return (double[])(pl1.distance(pl2 = Util3D.linesegPoint(l2a, l2b, proxt[1])) <= tol ? proxt : null);
    }

    public static double[] getLineSegLineSegIntersection(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double nearestTTol, double distSqTol) {
        Point3d pl2;
        double[] proxt = Inter3D.getNearestTLinesegLineSeg(l1a, l1b, l2a, l2b, nearestTTol);
        if (proxt == null) {
            return null;
        }
        Point3d pl1 = Util3D.linesegPoint(l1a, l1b, proxt[0]);
        return (double[])(pl1.distanceSquared(pl2 = Util3D.linesegPoint(l2a, l2b, proxt[1])) <= distSqTol ? proxt : null);
    }

    public static double[] lineSeglineSegOverlap(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double parallelTol, double distSqTol) {
        double t2;
        Vector3d seg2Dir;
        Vector3d seg1Dir = Util3D.vector(l1a, l1b);
        if (!Util3D.testAligned(l1a, seg1Dir, l2a, seg2Dir = Util3D.vector(l2a, l2b), parallelTol, distSqTol)) {
            return null;
        }
        double t1 = Inter3D.nearestTOnLine(l1a, seg1Dir, l2a);
        double[] ts = Util.clampTRange(t1, t2 = Inter3D.nearestTOnLine(l1a, seg1Dir, l2b));
        if (ts[0] < 1.0 && ts[1] > 0.0 && ts[0] != ts[1]) {
            return ts;
        }
        return null;
    }

    public static double[] lineLineProximityT(Point3d l1a, Vector3d line1Dir, Point3d l2a, Vector3d line2Dir, double tol) {
        Vector3d cross = new Vector3d();
        cross.cross(line1Dir, line2Dir);
        if (theUtil.eq0(cross.length(), tol)) {
            return null;
        }
        double[] t = new double[2];
        Vector3d normal2 = new Vector3d();
        normal2.cross(cross, line2Dir);
        normal2.normalize();
        Plane3d p2 = Util3D.getPlane(normal2, l2a);
        t[0] = Inter3D.linePlaneIntersectionT(l1a, line1Dir, p2, tol);
        Vector3d normal1 = new Vector3d();
        normal1.cross(cross, line1Dir);
        normal1.normalize();
        Plane3d p1 = Util3D.getPlane(normal1, l1a);
        t[1] = Inter3D.linePlaneIntersectionT(l2a, line2Dir, p1, tol);
        return t;
    }

    public static double[] lineSegLineSegProximityT(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double tol) {
        Vector3d l2Dir;
        Vector3d l1Dir = Util3D.vector(l1a, l1b);
        double[] t = Inter3D.lineLineProximityT(l1a, l1Dir, l2a, l2Dir = Util3D.vector(l2a, l2b), tol);
        if (t == null) {
            return null;
        }
        Util.clampTs(t, 0.0, 1.0);
        return t;
    }

    public static final LinesegClassify getNearestTLinesegLineSeg(Point3d s1p0, Point3d s1p1, Point3d s2p0, Point3d s2p1, double tol, double[] st) {
        return Inter3D.getNearestTLinesegLineSeg(s1p0.x, s1p0.y, s1p0.z, s1p1.x, s1p1.y, s1p1.z, s2p0.x, s2p0.y, s2p0.z, s2p1.x, s2p1.y, s2p1.z, tol, st);
    }

    public static final double[] getNearestTLinesegLineSeg(Point3d s1p0, Point3d s1p1, Point3d s2p0, Point3d s2p1, double tol) {
        double[] isect = new double[2];
        LinesegClassify result = Inter3D.getNearestTLinesegLineSeg(s1p0, s1p1, s2p0, s2p1, tol, isect);
        if (result != LinesegClassify.PARALLEL) {
            return isect;
        }
        return null;
    }

    public static final LinesegClassify getNearestTLinesegLineSeg(double s1p0x, double s1p0y, double s1p0z, double s1p1x, double s1p1y, double s1p1z, double s2p0x, double s2p0y, double s2p0z, double s2p1x, double s2p1y, double s2p1z, double tol, double[] st) {
        double tD;
        double tN;
        double sD;
        double sN;
        double ux = s1p1x - s1p0x;
        double uy = s1p1y - s1p0y;
        double uz = s1p1z - s1p0z;
        double vx = s2p1x - s2p0x;
        double vy = s2p1y - s2p0y;
        double vz = s2p1z - s2p0z;
        double wx = s1p0x - s2p0x;
        double wy = s1p0y - s2p0y;
        double wz = s1p0z - s2p0z;
        double a = Inter3D.dot(ux, uy, uz, ux, uy, uz);
        double b = Inter3D.dot(ux, uy, uz, vx, vy, vz);
        double c = Inter3D.dot(vx, vy, vz, vx, vy, vz);
        double d = Inter3D.dot(ux, uy, uz, wx, wy, wz);
        double e = Inter3D.dot(vx, vy, vz, wx, wy, wz);
        double ac = a * c;
        double bb = b * b;
        boolean parallel = false;
        boolean intersect = true;
        double tol2 = tol * tol;
        if (theUtil.releq(ac, bb, tol2)) {
            sN = 0.0;
            sD = 1.0;
            tN = e;
            tD = c;
            parallel = true;
            intersect = false;
        } else {
            sD = tD = ac - bb;
            sN = b * e - c * d;
            tN = a * e - b * d;
            if (sN < 0.0) {
                sN = 0.0;
                tN = e;
                tD = c;
                intersect = false;
            } else if (sN > sD) {
                sN = sD;
                tN = e + b;
                tD = c;
                intersect = false;
            }
        }
        if (tN < 0.0) {
            intersect = false;
            tN = 0.0;
            if (-d < 0.0) {
                sN = 0.0;
            } else if (-d > a) {
                sN = sD;
            } else {
                sN = -d;
                sD = a;
            }
        } else if (tN > tD) {
            intersect = false;
            tN = tD;
            if (-d + b < 0.0) {
                sN = 0.0;
            } else if (-d + b > a) {
                sN = sD;
            } else {
                sN = -d + b;
                sD = a;
            }
        }
        st[0] = Util.clampT(sN / sD, 0.0, 1.0);
        st[1] = Util.clampT(tN / tD, 0.0, 1.0);
        if (intersect) {
            return LinesegClassify.INTERSECT;
        }
        if (parallel) {
            return LinesegClassify.PARALLEL;
        }
        return LinesegClassify.NO_INTERSECT;
    }

    private static final double dot(double p1x, double p1y, double p1z, double p2x, double p2y, double p2z) {
        return p1x * p2x + p1y * p2y + p1z * p2z;
    }

    public static double[] lineLineSegProximityT(Point3d l1a, Vector3d l1Dir, Point3d l2a, Point3d l2b, double tol) {
        Vector3d l2Dir = Util3D.vector(l2a, l2b);
        double[] t = Inter3D.lineLineProximityT(l1a, l1Dir, l2a, l2Dir, tol);
        if (t == null) {
            return null;
        }
        t[1] = Util.clampT(t[1], 0.0, 1.0);
        return t;
    }

    @Deprecated
    public static boolean lineSegLineSegProximity(Point3d p1a, Point3d p2a, Vector3d dira, Point3d p1b, Point3d p2b, Vector3d dirb, Point3d closestOnLine1, Point3d closestOnLine2) {
        return Inter3D.lineSegLineSegProximity(p1a, p2a, dira, p1b, p2b, dirb, closestOnLine1, closestOnLine2, 1.0E-9);
    }

    public static boolean getNearestPointsLinesegLineseg(Point3d p1a, Point3d p2a, Vector3d dira, Point3d p1b, Point3d p2b, Vector3d dirb, Point3d closestOnLine1, Point3d closestOnLine2) {
        return Inter3D.getNearestPointsLinesegLineseg(p1a, p2a, dira, p1b, p2b, dirb, closestOnLine1, closestOnLine2, 1.0E-9);
    }

    @Deprecated
    public static boolean lineSegLineSegProximity(Point3d p1a, Point3d p2a, Vector3d dirNa, Point3d p1b, Point3d p2b, Vector3d dirNb, Point3d closestOnLine1, Point3d closestOnLine2, double tol) {
        double[] t = Inter3D.lineSegLineSegProximityT(p1a, p2a, p1b, p2b, tol);
        if (t == null) {
            return false;
        }
        if (closestOnLine1 != null) {
            closestOnLine1.set((Tuple3d)Util3D.linesegPoint(p1a, p2a, t[0]));
        }
        if (closestOnLine2 != null) {
            closestOnLine2.set((Tuple3d)Util3D.linesegPoint(p1b, p2b, t[1]));
        }
        return true;
    }

    public static boolean getNearestPointsLinesegLineseg(Point3d p1a, Point3d p2a, Vector3d dirNa, Point3d p1b, Point3d p2b, Vector3d dirNb, Point3d closestOnLine1, Point3d closestOnLine2, double tol) {
        double[] t = Inter3D.getNearestTLinesegLineSeg(p1a, p2a, p1b, p2b, tol);
        if (t == null) {
            return false;
        }
        if (closestOnLine1 != null) {
            closestOnLine1.set((Tuple3d)Util3D.linesegPoint(p1a, p2a, t[0]));
        }
        if (closestOnLine2 != null) {
            closestOnLine2.set((Tuple3d)Util3D.linesegPoint(p1b, p2b, t[1]));
        }
        return true;
    }

    public static boolean lineLineProximity(Point3d closestOnLine1, Point3d closestOnLine2, Point3d l1a, Vector3d line1Dir, Point3d l2a, Vector3d line2Dir) {
        return Inter3D.lineLineProximity(closestOnLine1, closestOnLine2, l1a, line1Dir, l2a, line2Dir, 1.0E-9);
    }

    public static boolean lineLineProximity(Point3d closestOnLine1, Point3d closestOnLine2, Point3d l1a, Vector3d line1Dir, Point3d l2a, Vector3d line2Dir, double tol) {
        double[] proxt = Inter3D.lineLineProximityT(l1a, line1Dir, l2a, line2Dir, tol);
        if (proxt == null) {
            return false;
        }
        if (closestOnLine1 != null) {
            closestOnLine1.set((Tuple3d)Util3D.linePoint(l1a, line1Dir, proxt[0]));
        }
        if (closestOnLine2 != null) {
            closestOnLine2.set((Tuple3d)Util3D.linePoint(l2a, line2Dir, proxt[1]));
        }
        return true;
    }

    public static boolean lineLineSegProximity(Point3d closestOnLine1, Point3d closestOnLine2, Point3d l1a, Vector3d line1Dir, Point3d l2a, Point3d l2b) {
        Vector3d line2Dir = new Vector3d();
        line2Dir.sub((Tuple3d)l2b, (Tuple3d)l2a);
        return Inter3D.lineLineSegProximity(closestOnLine1, closestOnLine2, l1a, line1Dir, l2a, l2b, line2Dir);
    }

    public static boolean lineLineSegProximity(Point3d closestOnLine1, Point3d closestOnLine2, Point3d l1a, Vector3d line1Dir, Point3d l2a, Point3d l2b, Vector3d line2Dir) {
        double[] t = Inter3D.lineLineSegProximityT(l1a, line1Dir, l2a, l2b, 1.0E-9);
        if (t == null) {
            return false;
        }
        if (closestOnLine1 != null) {
            closestOnLine1.set((Tuple3d)Util3D.linePoint(l1a, line1Dir, t[0]));
        }
        if (closestOnLine2 != null) {
            closestOnLine2.set((Tuple3d)Util3D.linesegPoint(l2a, l2b, t[1]));
        }
        return true;
    }

    public static boolean pointWithinSeg(Point3d point, Point3d la, Point3d lb, Vector3d lineDir) {
        double testDot = Util3D.dot((Tuple3d)lineDir, (Tuple3d)point);
        double p1Dot = Util3D.dot((Tuple3d)lineDir, (Tuple3d)la);
        double p2Dot = Util3D.dot((Tuple3d)lineDir, (Tuple3d)lb);
        return !(testDot < p1Dot && testDot < p2Dot) && (!(testDot > p1Dot) || !(testDot > p2Dot));
    }

    public static boolean constrainPoint(Point3d point, Point3d rayBegin, Vector3d dirN) {
        if (Util3D.isPointBehindPlane(point, rayBegin, dirN)) {
            point.set((Tuple3d)rayBegin);
            return true;
        }
        return false;
    }

    public static double lineXPlaneIsect(Point3d pOnLine, Vector3d lineDir, double planex, double tol) {
        if (theUtil.eq0(lineDir.x, tol)) {
            return Double.NaN;
        }
        return (planex - pOnLine.x) / lineDir.x;
    }

    public static double lineYPlaneIsect(Point3d pOnLine, Vector3d lineDir, double planey, double tol) {
        if (theUtil.eq0(lineDir.y, tol)) {
            return Double.NaN;
        }
        return (planey - pOnLine.y) / lineDir.y;
    }

    public static double lineZPlaneIsect(Point3d pOnLine, Vector3d lineDir, double planez, double tol) {
        if (theUtil.eq0(lineDir.z, tol)) {
            return Double.NaN;
        }
        return (planez - pOnLine.z) / lineDir.z;
    }

    public static double lineXFaceIsect(Point3d pOnLine, Vector3d lineDir, double ymin, double ymax, double zmin, double zmax, double x, double tol) {
        double t = Inter3D.lineXPlaneIsect(pOnLine, lineDir, x, tol);
        if (Double.isNaN(t)) {
            return t;
        }
        double iy = pOnLine.y + lineDir.y * t;
        double iz = pOnLine.z + lineDir.z * t;
        if (theUtil.le(ymin, iy, tol) && theUtil.le(iy, ymax, tol) && theUtil.le(zmin, iz, tol) && theUtil.le(iz, zmax, tol)) {
            return t;
        }
        return Double.NaN;
    }

    public static double lineYFaceIsect(Point3d pOnLine, Vector3d lineDir, double xmin, double xmax, double zmin, double zmax, double y, double tol) {
        double t = Inter3D.lineYPlaneIsect(pOnLine, lineDir, y, tol);
        if (Double.isNaN(t)) {
            return t;
        }
        double ix = pOnLine.x + lineDir.x * t;
        double iz = pOnLine.z + lineDir.z * t;
        if (theUtil.le(xmin, ix, tol) && theUtil.le(ix, xmax, tol) && theUtil.le(zmin, iz, tol) && theUtil.le(iz, zmax, tol)) {
            return t;
        }
        return Double.NaN;
    }

    public static double lineZFaceIsect(Point3d pOnLine, Vector3d lineDir, double xmin, double xmax, double ymin, double ymax, double z, double tol) {
        double t = Inter3D.lineZPlaneIsect(pOnLine, lineDir, z, tol);
        if (Double.isNaN(t)) {
            return t;
        }
        double ix = pOnLine.x + lineDir.x * t;
        double iy = pOnLine.y + lineDir.y * t;
        if (theUtil.le(xmin, ix, tol) && theUtil.le(ix, xmax, tol) && theUtil.le(ymin, iy, tol) && theUtil.le(iy, ymax, tol)) {
            return t;
        }
        return Double.NaN;
    }

    public static double rayXFaceIsect(Point3d p1, Vector3d lineDir, double ymin, double ymax, double zmin, double zmax, double x, double vtol, double ttol) {
        double result = Inter3D.lineXFaceIsect(p1, lineDir, ymin, ymax, zmin, zmax, x, vtol);
        if (Double.isNaN(result)) {
            return result;
        }
        if (theUtil.lt0(result, ttol)) {
            return Double.NaN;
        }
        return result < 0.0 ? 0.0 : result;
    }

    public static double rayYFaceIsect(Point3d p1, Vector3d lineDir, double xmin, double xmax, double zmin, double zmax, double y, double vtol, double ttol) {
        double result = Inter3D.lineYFaceIsect(p1, lineDir, xmin, xmax, zmin, zmax, y, vtol);
        if (Double.isNaN(result)) {
            return result;
        }
        if (theUtil.lt0(result, ttol)) {
            return Double.NaN;
        }
        return result < 0.0 ? 0.0 : result;
    }

    public static double rayZFaceIsect(Point3d p1, Vector3d lineDir, double xmin, double xmax, double ymin, double ymax, double z, double vtol, double ttol) {
        double result = Inter3D.lineZFaceIsect(p1, lineDir, xmin, xmax, ymin, ymax, z, vtol);
        if (Double.isNaN(result)) {
            return result;
        }
        if (theUtil.lt0(result, ttol)) {
            return Double.NaN;
        }
        return result < 0.0 ? 0.0 : result;
    }

    public static double linesegXFaceIsect(Point3d p1, Point3d p2, Vector3d lineDir, double ymin, double ymax, double zmin, double zmax, double x, double vtol, double ttol) {
        double result = Inter3D.lineXFaceIsect(p1, lineDir, ymin, ymax, zmin, zmax, x, vtol);
        if (Double.isNaN(result)) {
            return result;
        }
        return Util.clampTIfValid(result, 0.0, 1.0, ttol);
    }

    public static double linesegYFaceIsect(Point3d p1, Point3d p2, Vector3d lineDir, double xmin, double xmax, double zmin, double zmax, double y, double vtol, double ttol) {
        double result = Inter3D.lineYFaceIsect(p1, lineDir, xmin, xmax, zmin, zmax, y, vtol);
        if (Double.isNaN(result)) {
            return result;
        }
        return Util.clampTIfValid(result, 0.0, 1.0, ttol);
    }

    public static double linesegZFaceIsect(Point3d p1, Point3d p2, Vector3d lineDir, double xmin, double xmax, double ymin, double ymax, double z, double vtol, double ttol) {
        double result = Inter3D.lineZFaceIsect(p1, lineDir, xmin, xmax, ymin, ymax, z, vtol);
        if (Double.isNaN(result)) {
            return result;
        }
        return Util.clampTIfValid(result, 0.0, 1.0, ttol);
    }

    public static double[] rayAABoxIsect(Point3d l1, Vector3d lineDir, Point3d boxmin, Point3d boxmax, double tol) {
        double[] isect = Inter3D.lineAABoxIsect(l1, lineDir, boxmin, boxmax, tol);
        if (isect == null) {
            return null;
        }
        double ttol = tol / lineDir.length();
        if (theUtil.lt0(isect[1], ttol)) {
            return null;
        }
        if (isect[0] < 0.0) {
            isect[0] = 0.0;
        }
        if (isect[1] < 0.0) {
            isect[1] = 0.0;
        }
        return isect;
    }

    public static double[] linesegAABoxIsect(Point3d l1, Point3d l2, Vector3d lineDir, Point3d boxmin, Point3d boxmax, double tol) {
        double[] isect = Inter3D.lineAABoxIsect(l1, lineDir, boxmin, boxmax, tol);
        if (isect == null) {
            return null;
        }
        double ttol = tol / lineDir.length();
        if (theUtil.lt0(isect[1], ttol) || theUtil.gt(isect[0], 1.0, ttol)) {
            return null;
        }
        Util.clampTs(isect, 0.0, 1.0);
        return isect;
    }

    public static double[] lineAABoxIsect(Point3d l1, Vector3d lineDir, Point3d boxmin, Point3d boxmax, double tol) {
        double mint = Double.MAX_VALUE;
        double maxt = -1.7976931348623157E308;
        double t = Inter3D.lineXFaceIsect(l1, lineDir, boxmin.y, boxmax.y, boxmin.z, boxmax.z, boxmin.x, tol);
        if (!Double.isNaN(t)) {
            if (t < mint) {
                mint = t;
            }
            if (t > maxt) {
                maxt = t;
            }
        }
        if (!Double.isNaN(t = Inter3D.lineXFaceIsect(l1, lineDir, boxmin.y, boxmax.y, boxmin.z, boxmax.z, boxmax.x, tol))) {
            if (t < mint) {
                mint = t;
            }
            if (t > maxt) {
                maxt = t;
            }
        }
        if (!Double.isNaN(t = Inter3D.lineYFaceIsect(l1, lineDir, boxmin.x, boxmax.x, boxmin.z, boxmax.z, boxmin.y, tol))) {
            if (t < mint) {
                mint = t;
            }
            if (t > maxt) {
                maxt = t;
            }
        }
        if (!Double.isNaN(t = Inter3D.lineYFaceIsect(l1, lineDir, boxmin.x, boxmax.x, boxmin.z, boxmax.z, boxmax.y, tol))) {
            if (t < mint) {
                mint = t;
            }
            if (t > maxt) {
                maxt = t;
            }
        }
        if (!Double.isNaN(t = Inter3D.lineZFaceIsect(l1, lineDir, boxmin.x, boxmax.x, boxmin.y, boxmax.y, boxmin.z, tol))) {
            if (t < mint) {
                mint = t;
            }
            if (t > maxt) {
                maxt = t;
            }
        }
        if (!Double.isNaN(t = Inter3D.lineZFaceIsect(l1, lineDir, boxmin.x, boxmax.x, boxmin.y, boxmax.y, boxmax.z, tol))) {
            if (t < mint) {
                mint = t;
            }
            if (t > maxt) {
                maxt = t;
            }
        }
        if (mint == Double.MAX_VALUE || maxt == -1.7976931348623157E308) {
            return null;
        }
        return new double[]{mint, maxt};
    }

    private static boolean pointInsideAABB(Point3d p, Point3d min, Point3d max) {
        return min.x <= p.x && p.x <= max.x && min.y <= p.y && p.y <= max.y && min.z <= p.z && p.z <= max.z;
    }

    public static boolean sphereSphereIsect(Point3d p1, double r1, Point3d p2, double r2, double epsilon) {
        return p1.distance(p2) - r1 - r2 < -epsilon;
    }

    public static int sphereContainsAABB(Point3d sphereCenter, double sphereRadiusSq, Point3d aabbMin, Point3d aabbMax) {
        return thunderheadeng.geometry.Containment.convert(Inter3D.testSphereAABB(sphereCenter, sphereRadiusSq, aabbMin, aabbMax));
    }

    public static Containment testSphereAABB(Point3d sphereCenter, double sphereRadiusSq, Point3d aabbMin, Point3d aabbMax) {
        boolean maxInside;
        double dxm = sphereCenter.x - aabbMin.x;
        double dym = sphereCenter.y - aabbMin.y;
        double dzm = sphereCenter.z - aabbMin.z;
        double dxM = sphereCenter.x - aabbMax.x;
        double dyM = sphereCenter.y - aabbMax.y;
        double dzM = sphereCenter.z - aabbMax.z;
        double dxmSq = dxm * dxm;
        double dymSq = dym * dym;
        double dzmSq = dzm * dzm;
        double dxMSq = dxM * dxM;
        double dyMSq = dyM * dyM;
        double dzMSq = dzM * dzM;
        boolean minInside = dxmSq + dymSq + dzmSq <= sphereRadiusSq;
        boolean bl = maxInside = dxMSq + dyMSq + dzMSq <= sphereRadiusSq;
        if (minInside && maxInside) {
            return Containment.INSIDE;
        }
        if (minInside || maxInside) {
            return Containment.INTERSECTS;
        }
        double d = 0.0;
        if (sphereCenter.x < aabbMin.x) {
            d += dxmSq;
        } else if (sphereCenter.x > aabbMax.x) {
            d += dxMSq;
        }
        if (sphereCenter.y < aabbMin.y) {
            d += dymSq;
        } else if (sphereCenter.y > aabbMax.y) {
            d += dyMSq;
        }
        if (sphereCenter.z < aabbMin.z) {
            d += dzmSq;
        } else if (sphereCenter.z > aabbMax.z) {
            d += dzMSq;
        }
        return d <= sphereRadiusSq ? Containment.INTERSECTS : Containment.OUTSIDE;
    }

    public static boolean pointInPoly(double tol, Point3d pt, Point3d ... polyPoints) {
        return Inter3D.classifyConvexPolyPoint((double)tol, (Point3d)pt, (Point3d[])polyPoints).positive;
    }

    public static PointClassify classifyConvexPolyPoint(double tol, Point3d pt, Point3d ... polyPoints) {
        assert (polyPoints.length >= 3);
        double tolSq = tol * tol;
        Vector3d vp = new Vector3d();
        Vector3d vt = new Vector3d();
        Vector3d currentCross = new Vector3d();
        Vector3d lastCross = null;
        int inCount = 0;
        for (int m = 0; m < polyPoints.length; ++m) {
            Point3d p1 = polyPoints[m];
            Point3d p2 = polyPoints[(m + 1) % polyPoints.length];
            vt.sub((Tuple3d)p2, (Tuple3d)p1);
            if (theUtil.eq0(vt.lengthSquared(), tolSq)) continue;
            vp.sub((Tuple3d)pt, (Tuple3d)p1);
            currentCross.cross(vt, vp);
            double lenSq = currentCross.lengthSquared();
            if (theUtil.eq0(lenSq, tolSq)) {
                double dot = vp.dot(vt);
                return Util.checkRange(0.0, vt.dot(vt), dot, tol) ? PointClassify.ON_BOUNDARY : PointClassify.OUTSIDE;
            }
            currentCross.scale(1.0 / Math.sqrt(lenSq));
            if (lastCross == null) {
                lastCross = new Vector3d(currentCross);
                continue;
            }
            if (lastCross.dot(currentCross) < 0.0) {
                return PointClassify.OUTSIDE;
            }
            ++inCount;
        }
        return inCount > 0 ? PointClassify.INSIDE : PointClassify.OUTSIDE;
    }

    public static boolean pointInSimplePoly(double tol, Point3d tp, Point3d[][] loops) {
        return Inter3D.classifySimplePolyPoint((double)tol, (Point3d)tp, (Point3d[][])loops).positive;
    }

    public static PointClassify classifySimplePolyPoint(double tol, Point3d tp, Point3d[][] loops) {
        if (loops.length == 0) {
            return PointClassify.OUTSIDE;
        }
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(loops[0]), true);
        if (plane == null) {
            return PointClassify.OUTSIDE;
        }
        return Inter3D.classifySimplePolyPoint(tol, tp, plane, loops);
    }

    public static boolean pointInSimplePoly(double tol, Point3d tp, Plane3d polyPlane, Point3d[][] loops) {
        return Inter3D.classifySimplePolyPoint((double)tol, (Point3d)tp, (Plane3d)polyPlane, (Point3d[][])loops).positive;
    }

    public static PointClassify classifySimplePolyPoint(double tol, Point3d tp, Plane3d polyPlane, Point3d[][] loops) {
        Random rand = new Random(0L);
        Vector3d normal = polyPlane.getNormal();
        Vector3d testVec = new Vector3d();
        for (int m = 0; m < 15; ++m) {
            Vector3d v = Util3D.newRandomVector(rand);
            testVec.cross(normal, v);
            PointClassify classify = Inter3D.testPointInSimplePoly(loops, tp, testVec, tol);
            if (classify == null) continue;
            return classify;
        }
        System.err.println("Could not complete Inter3D.pointInSimplePoly using test point = " + tp.toString());
        return PointClassify.OUTSIDE;
    }

    private static PointClassify testPointInSimplePoly(Point3d[][] loops, Point3d tp, Vector3d dir, double tol) {
        int numIsects = 0;
        for (int n = 0; n < loops.length; ++n) {
            Point3d[] loopVerts = loops[n];
            for (int m = 0; m < loopVerts.length; ++m) {
                Point3d e1 = loopVerts[m];
                Point3d e2 = loopVerts[(m + 1) % loopVerts.length];
                Vector3d edir = Util3D.vector(e1, e2);
                double[] isect = Inter3D.lineLineProximityT(tp, dir, e1, edir, tol);
                if (isect == null || !Util.checkRange(0.0, 1.0, isect[1], tol)) continue;
                double tr = isect[0];
                double tcurve = isect[1];
                if (theUtil.eq0(tr, tol)) {
                    return PointClassify.ON_BOUNDARY;
                }
                if (tr < 0.0) continue;
                if (theUtil.eq0(tcurve, tol) || theUtil.eq(tcurve, 1.0, tol)) {
                    return null;
                }
                ++numIsects;
            }
        }
        return numIsects % 2 != 0 ? PointClassify.INSIDE : PointClassify.OUTSIDE;
    }

    public static void projectOntoAxis(Point3d[] face, Vector3d axis, double[] minMax) {
        double min;
        assert (face.length > 2);
        double max = min = Util3D.dot((Tuple3d)axis, (Tuple3d)face[0]);
        for (int m = 1; m < face.length; ++m) {
            Point3d p = face[m];
            double dot = Util3D.dot((Tuple3d)axis, (Tuple3d)p);
            if (dot < min) {
                min = dot;
                continue;
            }
            if (!(dot > max)) continue;
            max = dot;
        }
        minMax[0] = min;
        minMax[1] = max;
    }

    public static Vector3d[] getEdges(Point3d ... face) {
        int numEdges = face.length;
        Vector3d[] edges = new Vector3d[numEdges];
        for (int m = 0; m < numEdges; ++m) {
            Point3d p1 = face[m];
            Point3d p2 = face[(m + 1) % numEdges];
            edges[m] = new Vector3d(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        }
        return edges;
    }

    public static boolean faceFaceIsect(Point3d[] face0, Point3d[] face1, double tol) {
        assert (face0.length > 2 && face1.length > 2);
        Plane3d f0Plane = new Plane3d(true, face0);
        Plane3d f1Plane = new Plane3d(true, face1);
        Vector3d f0Norm = f0Plane.getNormal();
        double[] proj1 = new double[2];
        double pOnFaceDot = Util3D.dot((Tuple3d)f0Norm, (Tuple3d)face0[0]);
        Inter3D.projectOntoAxis(face1, f0Norm, proj1);
        if (pOnFaceDot < proj1[0] || pOnFaceDot > proj1[1]) {
            return false;
        }
        Vector3d f1Norm = f1Plane.getNormal();
        Vector3d[] f0Edges = Inter3D.getEdges(face0);
        Vector3d[] f1Edges = Inter3D.getEdges(face1);
        double[] proj0 = new double[2];
        Vector3d normCross = Util3D.cross(f0Norm, f1Norm);
        if (Util3D.safeNormalize(normCross, tol) != 0.0) {
            pOnFaceDot = Util3D.dot((Tuple3d)f1Norm, (Tuple3d)face1[0]);
            Inter3D.projectOntoAxis(face0, f1Norm, proj0);
            if (pOnFaceDot < proj0[0] || pOnFaceDot > proj0[1]) {
                return false;
            }
            for (int i1 = 0; i1 < f1Edges.length; ++i1) {
                for (int i0 = 0; i0 < f0Edges.length; ++i0) {
                    Vector3d vec = Util3D.cross(f0Edges[i0], f1Edges[i1]);
                    vec.normalize();
                    Inter3D.projectOntoAxis(face0, vec, proj0);
                    Inter3D.projectOntoAxis(face1, vec, proj1);
                    if (!(proj0[1] < proj1[0]) && !(proj1[1] < proj0[0])) continue;
                    return false;
                }
            }
        } else {
            Vector3d vec;
            for (int i0 = 0; i0 < f0Edges.length; ++i0) {
                vec = Util3D.cross(f0Norm, f0Edges[i0]);
                vec.normalize();
                Inter3D.projectOntoAxis(face0, vec, proj0);
                Inter3D.projectOntoAxis(face1, vec, proj1);
                if (!(proj0[1] < proj1[0]) && !(proj1[1] < proj0[0])) continue;
                return false;
            }
            for (int i1 = 0; i1 < f1Edges.length; ++i1) {
                vec = Util3D.cross(f1Norm, f1Edges[i1]);
                vec.normalize();
                Inter3D.projectOntoAxis(face0, vec, proj0);
                Inter3D.projectOntoAxis(face1, vec, proj1);
                if (!(proj0[1] < proj1[0]) && !(proj1[1] < proj0[0])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean testConvexPolyConvexPoly(Point3d[] face0, Point3d[] face1, double tol) {
        Plane3d f0Plane = new Plane3d(true, face0);
        Plane3d f1Plane = new Plane3d(true, face1);
        return Inter3D.testConvexPolyConvexPoly(face0, f0Plane, face1, f1Plane, tol);
    }

    public static boolean testConvexPolyConvexPoly(Point3d[] face0, Plane3d f0Plane, Point3d[] face1, Plane3d f1Plane, double tol) {
        assert (face0.length > 2 && face1.length > 2);
        Vector3d f0Norm = f0Plane.getNormal();
        double[] proj1 = new double[2];
        double pOnFaceDot = Util3D.dot((Tuple3d)f0Norm, (Tuple3d)face0[0]);
        Inter3D.projectOntoAxis(face1, f0Norm, proj1);
        if (theUtil.lt(pOnFaceDot, proj1[0], tol) || theUtil.gt(pOnFaceDot, proj1[1], tol)) {
            return false;
        }
        Vector3d f1Norm = f1Plane.getNormal();
        Vector3d[] f0Edges = Inter3D.getEdges(face0);
        Vector3d[] f1Edges = Inter3D.getEdges(face1);
        double[] proj0 = new double[2];
        BiPredicate<Vector3d, Vector3d> noCrossOverlap = (v1, v2) -> {
            Vector3d vec = Util3D.cross(v1, v2);
            vec.normalize();
            Inter3D.projectOntoAxis(face0, vec, proj0);
            Inter3D.projectOntoAxis(face1, vec, proj1);
            return theUtil.lt(proj0[1], proj1[0], tol) || theUtil.lt(proj1[1], proj0[0], tol);
        };
        Vector3d normCross = Util3D.cross(f0Norm, f1Norm);
        if (Util3D.safeNormalize(normCross, tol) != 0.0) {
            pOnFaceDot = Util3D.dot((Tuple3d)f1Norm, (Tuple3d)face1[0]);
            Inter3D.projectOntoAxis(face0, f1Norm, proj0);
            if (theUtil.lt(pOnFaceDot, proj0[0], tol) || theUtil.gt(pOnFaceDot, proj0[1], tol)) {
                return false;
            }
            for (int i1 = 0; i1 < f1Edges.length; ++i1) {
                for (int i0 = 0; i0 < f0Edges.length; ++i0) {
                    if (!noCrossOverlap.test(f0Edges[i0], f1Edges[i1])) continue;
                    return false;
                }
            }
        } else {
            for (int i0 = 0; i0 < f0Edges.length; ++i0) {
                if (!noCrossOverlap.test(f0Norm, f0Edges[i0])) continue;
                return false;
            }
            for (int i1 = 0; i1 < f1Edges.length; ++i1) {
                if (!noCrossOverlap.test(f1Norm, f1Edges[i1])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean faceAABoxIsect(double tol, AABox box, Point3d ... face) {
        for (Point3d point3d : face) {
            if (!box.contains(point3d, tol)) continue;
            return true;
        }
        for (Point3d point3d : box.getFaces()) {
            if (!Inter3D.faceFaceIsect(face, (Point3d[])point3d, tol)) continue;
            return true;
        }
        return false;
    }

    public static int convexHullContainsAABB(Point3d min, Point3d max, Plane3d ... planes) {
        return thunderheadeng.geometry.Containment.convert(Inter3D.testConvexHullAABB(min, max, planes));
    }

    public static Containment testConvexHullAABB(Point3d min, Point3d max, Plane3d ... planes) {
        int totalIn = 0;
        for (Plane3d plane : planes) {
            int inCount = 8;
            int ptIn = 1;
            if (plane.dot(min.x, min.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(min.x, min.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(min.x, max.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(min.x, max.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, min.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, min.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, max.y, min.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (plane.dot(max.x, max.y, max.z) >= 0.0) {
                ptIn = 0;
                --inCount;
            }
            if (inCount == 0) {
                return Containment.OUTSIDE;
            }
            totalIn += ptIn;
        }
        return totalIn == planes.length ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public static double[] movingSphereMovingSphereIsect(Point3d sp1, double sr1, Vector3d vel1, Point3d sp2, double sr2, Vector3d vel2, double tol) {
        Vector3d newVel1 = Util3D.sub(vel1, (Tuple3d)vel2);
        return Inter3D.movingSphereSphereIsect(sp1, sr1, newVel1, sp2, sr2, tol);
    }

    public static double[] movingSphereSphereIsect(Point3d sp1, double sr1, Vector3d vel1, Point3d sp2, double sr2, double tol) {
        double newRadius = sr1 + sr2;
        double[] t = Inter3D.raySphereIsectT(sp1, vel1, sp2, newRadius * newRadius, tol);
        return t;
    }

    public static double[] raySphereIsectT(Point3d l1, Vector3d lineDir, Point3d center, double radiusSq, double tol) {
        double c;
        double a = lineDir.lengthSquared();
        if (theUtil.eq0(a, tol)) {
            return null;
        }
        Vector3d scl1 = Util3D.vector(center, l1);
        double b = 2.0 * lineDir.dot(scl1);
        double sq = b * b - 4.0 * a * (c = Util3D.dot((Tuple3d)center, (Tuple3d)center) + Util3D.dot((Tuple3d)l1, (Tuple3d)l1) - 2.0 * Util3D.dot((Tuple3d)center, (Tuple3d)l1) - radiusSq);
        if (theUtil.gt0(sq, tol)) {
            double sqrtsq = Math.sqrt(sq);
            double inv2a = 0.5 / a;
            return new double[]{(-b - sqrtsq) * inv2a, (-b + sqrtsq) * inv2a};
        }
        if (theUtil.lt0(sq, tol)) {
            return null;
        }
        double result = -b / (2.0 * a);
        return new double[]{result, result};
    }

    public static Point3d[] raySphereIsect(Point3d l1, Vector3d lineDir, Point3d center, double radiusSq, double tol) {
        double[] t = Inter3D.raySphereIsectT(l1, lineDir, center, radiusSq, tol);
        if (t != null) {
            Point3d[] result = new Point3d[]{Util3D.linePoint(l1, lineDir, t[0]), Util3D.linePoint(l1, lineDir, t[1])};
            return result;
        }
        return null;
    }

    public static boolean pointInSphere(Point3d p, Point3d center, double radiusSq) {
        return p.distanceSquared(center) <= radiusSq;
    }

    public static boolean movingSphereLineSegIsect(Point3d sphereCenter, double sphereRadius, Vector3d sphereVel, Point3d l1, Point3d l2, double[] t, double epsilon) {
        if (sphereRadius == 0.0) {
            Point3d isect = Inter3D.copRayLineSeg(sphereCenter, sphereVel, l1, l2, t, epsilon);
            if (isect != null) {
                t[1] = t[0];
            }
            return isect != null;
        }
        if (Inter3D.rayCapsuleIsect(sphereCenter, sphereVel, l1, l2, sphereRadius, t, epsilon)) {
            return !theUtil.eq(t[0], t[1], epsilon);
        }
        return false;
    }

    public static Point3d copRayLineSeg(Point3d rbegin, Vector3d rvec, Point3d l2a, Point3d l2b, double[] st, double tol) {
        Point3d p2;
        Vector3d l2Vec = Util3D.vector(l2a, l2b);
        if (!Inter3D.copLineLine(rbegin, rvec, l2a, l2Vec, st, tol)) {
            if (Inter3D.isOnLine(l2a, rbegin, rvec, tol)) {
                double t1 = Util3D.tOnLine(rbegin, rvec, l2a);
                double t2 = Util3D.tOnLine(rbegin, rvec, l2b);
                if (t1 < 0.0 && t2 > 0.0 || t1 > 0.0 && t2 < 0.0) {
                    st[0] = 0.0;
                    st[1] = Util3D.tOnLineSeg(l2a, l2b, rbegin);
                    return new Point3d(rbegin);
                }
                if (t1 >= 0.0 && t2 >= 0.0) {
                    if (t1 <= t2) {
                        st[0] = t1;
                        st[1] = 0.0;
                        return new Point3d(l2a);
                    }
                    st[0] = t2;
                    st[1] = 1.0;
                    return new Point3d(l2b);
                }
            }
            return null;
        }
        Point3d p1 = Util3D.linePoint(rbegin, rvec, st[0]);
        return p1.distance(p2 = Util3D.linesegPoint(l2a, l2b, st[1])) <= tol ? p2 : null;
    }

    public static boolean isOnLine(Point3d p, Point3d l1, Vector3d ld, double distTol) {
        Point3d nearp = Inter3D.nearestPointOnLine(l1, ld, p);
        return nearp.distance(p) <= distTol;
    }

    public static Point3d edgeCenter(Point3d e1, Point3d e2) {
        return new Point3d((e1.x + e2.x) * 0.5, (e1.y + e2.y) * 0.5, (e1.z + e2.z) * 0.5);
    }

    public static double[] lineSegCapsuleIsect(Point3d l1, Point3d l2, Point3d c1, Point3d c2, double r, double epsilon) {
        double[] t;
        Vector3d ldir = Util3D.vector(l1, l2);
        boolean result = Inter3D.rayCapsuleIsect(l1, ldir, c1, c2, r, t = new double[2], epsilon);
        if (!result) {
            return null;
        }
        Util.clampTs(t, 0.0, 1.0);
        if (theUtil.eq(t[0], t[1], epsilon)) {
            return null;
        }
        assert (t[0] < t[1]);
        return t;
    }

    public static boolean rayCapsuleIsect(Point3d O, Vector3d D, Point3d c1, Point3d c2, double r, double[] t, double epsilon) {
        Point3d edgeCenter = Inter3D.edgeCenter(c1, c2);
        Vector3d edgeAxis = Util3D.vector(c1, c2);
        double edgeLen = edgeAxis.length();
        edgeAxis.scale(1.0 / edgeLen);
        return Inter3D.rayCapsuleIsect(O, D, edgeCenter, edgeAxis, edgeLen, r, t, epsilon);
    }

    public static boolean rayCapsuleIsect(Point3d O, Vector3d D, Point3d C, Vector3d A, double l, double r, double[] t, double epsilon) {
        return Inter3D.rayCapsuleIsect(O.x, O.y, O.z, D.x, D.y, D.z, C.x, C.y, C.z, A.x, A.y, A.z, l, r, t, epsilon);
    }

    public static boolean rayCapsuleIsect(double ox, double oy, double oz, double dx, double dy, double dz, double cx, double cy, double cz, double ax, double ay, double az, double l, double r, double[] t, double epsilon) {
        double dxp = ox - cx;
        double dyp = oy - cy;
        double dzp = oz - cz;
        double DD = dx * dx + dy * dy + dz * dz;
        double DA = dx * ax + dy * ay + dz * az;
        double dD = dxp * dx + dyp * dy + dzp * dz;
        double dA = dxp * ax + dyp * ay + dzp * az;
        double dd = dxp * dxp + dyp * dyp + dzp * dzp;
        double a = DD - DA * DA;
        double hl = l * 0.5;
        double rr = r * r;
        if (Math.abs(a) <= epsilon * epsilon) {
            double hls2dA;
            double k;
            double hls = DA > 0.0 ? hl : -hl;
            double hlsDA = hls * DA;
            double b0 = dD + hlsDA;
            double disc0 = b0 * b0 - DD * ((k = dd + hl * hl - rr) + (hls2dA = (hls + hls) * dA));
            if (disc0 <= 0.0) {
                return false;
            }
            double b1 = dD - hlsDA;
            double disc1 = b1 * b1 - DD * (k - hls2dA);
            if (disc1 <= 0.0) {
                return false;
            }
            double invA = 1.0 / DD;
            t[0] = (-b0 - Math.sqrt(disc0)) * invA;
            t[1] = (-b1 + Math.sqrt(disc1)) * invA;
        } else {
            double b = dD - dA * DA;
            double disc = b * b - a * (dd - dA * dA - rr);
            if (disc < 0.0) {
                return false;
            }
            double invA = 1.0 / a;
            disc = Math.sqrt(disc);
            t[0] = (-b - disc) * invA;
            t[1] = (-b + disc) * invA;
            double dot0 = dA + t[0] * DA;
            double dot1 = dA + t[1] * DA;
            if (Math.abs(dot0) > hl) {
                double hls2dA;
                double k;
                double hls = dot0 < 0.0 ? hl : -hl;
                double hlsDA = hls * DA;
                b = dD + hlsDA;
                disc = b * b - DD * ((k = dd + hl * hl - rr) + (hls2dA = (hls + hls) * dA));
                if (disc < 0.0) {
                    return false;
                }
                invA = 1.0 / DD;
                disc = Math.sqrt(disc);
                t[0] = (-b - disc) * invA;
                if (Math.abs(dot1) > hl) {
                    t[1] = dot0 * dot1 > 0.0 ? (-b + disc) * invA : ((disc = (b = dD - hlsDA) * b - DD * (k - hls2dA)) <= 0.0 ? -b * invA : (-b + Math.sqrt(disc)) * invA);
                }
            } else if (Math.abs(dot1) > hl) {
                double hls = dot1 < 0.0 ? hl : -hl;
                b = dD + hls * DA;
                disc = b * b - DD * (dd + (hls + hls) * dA + hl * hl - rr);
                t[1] = disc <= 0.0 ? -b / DD : (-b + Math.sqrt(disc)) / DD;
            }
        }
        return true;
    }

    public static Tuple3d[] planePlaneIsect(Plane3d plane1, Plane3d plane2, double tol) {
        if (Util3D.areParallel(plane1, plane2, tol)) {
            return null;
        }
        Vector3d dir = Util3D.cross(plane1.getNormal(), plane2.getNormal());
        double xdiff = dir.x;
        double ydiff = -dir.y;
        double zdiff = dir.z;
        double bestDiff = xdiff;
        int bestDir = 0;
        if (Math.abs(ydiff) > Math.abs(bestDiff)) {
            bestDiff = ydiff;
            bestDir = 1;
        }
        if (Math.abs(zdiff) > Math.abs(bestDiff)) {
            bestDiff = zdiff;
            bestDir = 2;
        }
        if (theUtil.eq0(bestDiff, tol)) {
            return null;
        }
        switch (bestDir) {
            case 0: {
                double py = (plane1.z * plane2.w - plane2.z * plane1.w) / xdiff;
                double pz = (plane1.y * plane2.w - plane2.y * plane1.w) / -xdiff;
                return new Tuple3d[]{new Point3d(0.0, py, pz), dir};
            }
            case 1: {
                double px = (plane1.z * plane2.w - plane2.z * plane1.w) / ydiff;
                double pz = (plane1.x * plane2.w - plane2.x * plane1.w) / -ydiff;
                return new Tuple3d[]{new Point3d(px, 0.0, pz), dir};
            }
        }
        double px = (plane1.y * plane2.w - plane2.y * plane1.w) / zdiff;
        double py = (plane1.x * plane2.w - plane2.x * plane1.w) / -zdiff;
        return new Tuple3d[]{new Point3d(px, py, 0.0), dir};
    }

    public static boolean testLineSegSphere(Point3d l1, Point3d l2, Point3d sphereCenter, double sphereRadius, double tol) {
        Point3d nearp = Inter3D.nearestPointOnLineSeg(l1, l2, sphereCenter);
        double distSq = nearp.distanceSquared(nearp);
        double tolSq = sphereRadius + tol;
        return distSq <= (tolSq *= tolSq);
    }

    public static boolean testTriSphere(Point3d A, Point3d B, Point3d C, Point3d P, double r) {
        return Inter3D.testTriSphere(A, B, C, P, r, 1.0E-9);
    }

    public static boolean testTriSphere(Point3d A, Point3d B, Point3d C, Point3d P, double r, double tol) {
        double e;
        Vector3d AC;
        A = Util3D.sub(A, (Tuple3d)P);
        B = Util3D.sub(B, (Tuple3d)P);
        C = Util3D.sub(C, (Tuple3d)P);
        double rr = r * r;
        Vector3d AB = Util3D.vector(A, B);
        Vector3d V = Util3D.cross(AB, AC = Util3D.vector(A, C));
        double d = Inter3D.dot((Tuple3d)A, (Tuple3d)V);
        if (theUtil.gt(d * d, rr * (e = Inter3D.dot((Tuple3d)V, (Tuple3d)V)), tol)) {
            return false;
        }
        double aa = Inter3D.dot((Tuple3d)A, (Tuple3d)A);
        double ab = Inter3D.dot((Tuple3d)A, (Tuple3d)B);
        double ac = Inter3D.dot((Tuple3d)A, (Tuple3d)C);
        if (theUtil.gt(aa, rr, tol) && theUtil.gt(ab, aa, tol) && theUtil.gt(ac, aa, tol)) {
            return false;
        }
        double bb = Inter3D.dot((Tuple3d)B, (Tuple3d)B);
        double bc = Inter3D.dot((Tuple3d)B, (Tuple3d)C);
        if (theUtil.gt(bb, rr, tol) && theUtil.gt(ab, bb, tol) && theUtil.gt(bc, bb, tol)) {
            return false;
        }
        double cc = Inter3D.dot((Tuple3d)C, (Tuple3d)C);
        if (theUtil.gt(cc, rr, tol) && theUtil.gt(ac, cc, tol) && theUtil.gt(bc, cc, tol)) {
            return false;
        }
        double d1 = ab - aa;
        double e1 = Inter3D.dot((Tuple3d)AB, (Tuple3d)AB);
        Vector3d Q1 = Inter3D.doubleScaleDiff((Tuple3d)A, e1, d1, (Tuple3d)AB);
        Vector3d QC = Inter3D.singleScaleDiff((Tuple3d)C, e1, (Tuple3d)Q1);
        if (theUtil.gt(Inter3D.dot((Tuple3d)Q1, (Tuple3d)Q1), rr * e1 * e1, tol) && theUtil.gt0(Inter3D.dot((Tuple3d)Q1, (Tuple3d)QC), tol)) {
            return false;
        }
        Vector3d BC = Util3D.vector(B, C);
        double d2 = bc - bb;
        double e2 = Inter3D.dot((Tuple3d)BC, (Tuple3d)BC);
        Vector3d Q2 = Inter3D.doubleScaleDiff((Tuple3d)B, e2, d2, (Tuple3d)BC);
        Vector3d QA = Inter3D.singleScaleDiff((Tuple3d)A, e2, (Tuple3d)Q2);
        if (theUtil.gt(Inter3D.dot((Tuple3d)Q2, (Tuple3d)Q2), rr * e2 * e2, tol) && theUtil.gt0(Inter3D.dot((Tuple3d)Q2, (Tuple3d)QA), tol)) {
            return false;
        }
        Vector3d CA = AC;
        CA.negate();
        double d3 = ac - cc;
        double e3 = Inter3D.dot((Tuple3d)CA, (Tuple3d)CA);
        Vector3d Q3 = Inter3D.doubleScaleDiff((Tuple3d)C, e3, d3, (Tuple3d)CA);
        Vector3d QB = Inter3D.singleScaleDiff((Tuple3d)B, e3, (Tuple3d)Q3);
        return !theUtil.gt(Inter3D.dot((Tuple3d)Q3, (Tuple3d)Q3), rr * e3 * e3, tol) || !theUtil.gt0(Inter3D.dot((Tuple3d)Q3, (Tuple3d)QB), tol);
    }

    private static Vector3d doubleScaleDiff(Tuple3d t1, double s1, double s2, Tuple3d t2) {
        return new Vector3d(t1.x * s1 - t2.x * s2, t1.y * s1 - t2.y * s2, t1.z * s1 - t2.z * s2);
    }

    private static Vector3d singleScaleDiff(Tuple3d t1, double s1, Tuple3d t2) {
        return new Vector3d(t1.x * s1 - t2.x, t1.y * s1 - t2.y, t1.z * s1 - t2.z);
    }

    private static double dot(Tuple3d t1, Tuple3d t2) {
        return t1.x * t2.x + t1.y * t2.y + t1.z * t2.z;
    }

    public static double testPlaneAABox(Plane3d plane, AABox box, double tol) {
        int pcount = 0;
        int ncount = 0;
        Point3d tp = new Point3d();
        for (int m = 0; m < 8; ++m) {
            box.getCorner(m, tp);
            double t = plane.dot(tp);
            if (theUtil.eq0(t, tol)) continue;
            if (t > 0.0) {
                ++pcount;
                continue;
            }
            ++ncount;
        }
        if (pcount == 8) {
            return 1.0;
        }
        if (ncount == 8) {
            return -1.0;
        }
        return 0.0;
    }

    public static boolean testCoplanarCPolyCPoly(Point3d[] pol1, Point3d[] pol2, double tol) {
        int i;
        if (pol1 == null || pol2 == null || pol1.length == 0 || pol2.length == 0) {
            return false;
        }
        for (i = 0; i < pol1.length; ++i) {
            if (!Inter3D.pointInPoly(tol, pol1[i], pol2)) continue;
            return true;
        }
        for (i = 0; i < pol2.length; ++i) {
            if (!Inter3D.pointInPoly(tol, pol2[i], pol1)) continue;
            return true;
        }
        for (i = 0; i < pol1.length; ++i) {
            Point3d p11 = pol1[i];
            Point3d p12 = pol1[(i + 1) % pol1.length];
            for (int j = 0; j < pol2.length; ++j) {
                Point3d p21 = pol2[j];
                Point3d p22 = pol2[(j + 1) % pol2.length];
                if (Inter3D.getLineSegLineSegIntersection(p11, p12, p21, p22, 1.0E-6, tol) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static PointClassify testPointInSolid(IContainer<IPolygon, AABox> faces, Point3d p, double tol) {
        Random random = new Random(1L);
        int nattempts = 10;
        for (int m = 0; m < 10; ++m) {
            Vector3d testVec = Util3D.newRandomVector(random);
            ArrayList<IPolygon> potFaces = new ArrayList<IPolygon>();
            IResult<IPolygon> searchResult = (poly, ctmt) -> potFaces.add((IPolygon)poly);
            faces.find(new RayAABoxTest(p, testVec, tol), searchResult);
            PointClassify result = Inter3D.testPointInSolid(potFaces, false, p, testVec, tol);
            if (result == null) continue;
            return result;
        }
        System.err.printf("Inter3D.testPointInSolid failed after %d attempts%n", 10);
        return PointClassify.OUTSIDE;
    }

    public static PointClassify testPointInSolid(IContainer<IPolygon, AABox> faces, boolean halfSolid, Point3d p, Vector3d testVec, double tol) {
        ArrayList<IPolygon> potFaces = new ArrayList<IPolygon>();
        IResult<IPolygon> searchResult = (poly, ctmt) -> potFaces.add((IPolygon)poly);
        faces.find(new RayAABoxTest(p, testVec, tol), searchResult);
        return Inter3D.testPointInSolid(potFaces, halfSolid, p, testVec, tol);
    }

    public static PointClassify testPointInSolid(Collection<IPolygon> faces, boolean half, Point3d rayBegin, Vector3d rayDirN, double tol) {
        int numIsects = 0;
        boolean onBoundary = false;
        double tolsq = tol * tol;
        for (IPolygon face : faces) {
            Point3d isect = Inter3D.rayPlaneIntersection(rayBegin, rayDirN, face.getPlane(true), tol);
            if (isect == null) continue;
            IFace.PointClassify pc = face.classify(isect, tol);
            if (!pc.positive) continue;
            if (pc == IFace.PointClassify.ON_BOUNDARY) {
                return null;
            }
            if (rayBegin.distanceSquared(isect) <= tolsq) {
                if (!half) {
                    return PointClassify.ON_BOUNDARY;
                }
                onBoundary = true;
                continue;
            }
            ++numIsects;
        }
        return numIsects % 2 != 0 ? (onBoundary ? PointClassify.ON_BOUNDARY : PointClassify.INSIDE) : PointClassify.OUTSIDE;
    }

    public static Pair<Double, PointClassify>[] curveSimplePoly(IParametric3D curve, IPolygon face, Predicate<PointClassify> classifyFilter, double isectTol) {
        Plane3d plane = face.getPlane(true);
        double[] isects = curve.getIsects(plane, isectTol);
        if (isects != null && isects.length > 0) {
            ArrayList<Pair<Double, PointClassify>> isectsList = new ArrayList<Pair<Double, PointClassify>>(isects.length);
            Point3d[][] loops = PolyUtil.getLoops(face, false);
            for (double isect : isects) {
                Point3d isectLoc = curve.get(isect);
                PointClassify fc = Inter3D.classifySimplePolyPoint(isectTol, isectLoc, plane, loops);
                if (!fc.positive || !classifyFilter.test(fc)) continue;
                isectsList.add(new Pair<Double, PointClassify>(isect, fc));
            }
            return theUtil.toArray(isectsList, Pair.class);
        }
        return new Pair[0];
    }

    private static Vector3d newRandomVec2D(Random rand) {
        return new Vector3d(Inter3D.randomVecComp(rand), Inter3D.randomVecComp(rand), 0.0);
    }

    private static double randomVecComp(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    public static enum PointClassify {
        INSIDE(true),
        ON_BOUNDARY(true),
        OUTSIDE(false);

        public final boolean positive;

        private PointClassify(boolean positive) {
            this.positive = positive;
        }
    }

    public static enum LinesegClassify {
        PARALLEL,
        INTERSECT,
        NO_INTERSECT;

    }
}

