/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;

public abstract class AParametric2D
implements IParametric2D {
    @Override
    public Vector2d getNormal(double t) {
        Vector2d tan = this.getTangent(t);
        double temp = tan.y;
        tan.y = tan.x;
        tan.x = -temp;
        return tan;
    }

    @Override
    public List<double[]> getLinesegIsects(Point2d l1, Point2d l2, double tol) {
        List<double[]> lineIsects = this.getLineIsects(l1, Util2D.vector(l1, l2), tol);
        ArrayList<double[]> linesegIsects = new ArrayList<double[]>(lineIsects.size());
        for (double[] lineIsect : lineIsects) {
            lineIsect[1] = Util.clampTIfValid(lineIsect[1], 0.0, 1.0, tol);
            if (Double.isNaN(lineIsect[1])) continue;
            linesegIsects.add(lineIsect);
        }
        return linesegIsects;
    }
}

