/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.delaunay;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.vecmath.Point2d;

public class GeomTests {
    public static double epsilon;
    public static double splitter;
    public static double ccwerrboundA;
    public static double iccerrboundA;

    public static void main(String[] args) {
        System.out.println("GeomTests...");
        GeomTests.init();
        System.out.println(Math.ulp(1.0));
        System.out.println(epsilon);
        System.out.println(ccwerrboundA);
        Point2d a = new Point2d(0.0, 0.0);
        Point2d b = new Point2d(3.0, 2.0);
        Point2d c1 = new Point2d(2.0, 4.0);
        Point2d c2 = new Point2d(5.0, 1.0);
        Point2d c3 = new Point2d(6.0, 4.0);
        Point2d c4 = new Point2d(0.3333333333333333, 0.2222222222222222);
        Point2d c5 = new Point2d(0.333333, 0.222222);
        Point2d c6 = new Point2d(0.333333, 0.222222);
        Point2d a2 = new Point2d(1.0, 2.0);
        Point2d c7 = new Point2d(5.0, 2.0);
        System.out.println(GeomTests.orient2d(a, b, c1));
        System.out.println(GeomTests.orient2d(a, b, c2));
        System.out.println(GeomTests.orient2d(a, b, c3));
        System.out.println(GeomTests.orient2d(a, b, c4));
        System.out.println(GeomTests.orient2d(a, b, c5));
        System.out.println(GeomTests.orient2d(a, b, c6));
        System.out.println(GeomTests.orient2d(a2, b, c7));
        System.out.println(GeomTests.orient2dbig(a, b, c1));
        System.out.println(GeomTests.orient2dbig(a, b, c2));
        System.out.println(GeomTests.orient2dbig(a, b, c3));
        System.out.println(GeomTests.orient2dbig(a, b, c4));
        System.out.println(GeomTests.orient2dbig(a, b, c5));
        System.out.println(GeomTests.orient2dbig(a, b, c6));
    }

    public static void init() {
        double lastcheck;
        boolean every_other = true;
        double half = 0.5;
        epsilon = 1.0;
        splitter = 1.0;
        double check = 1.0;
        do {
            lastcheck = check;
            epsilon *= half;
            if (every_other) {
                splitter *= 2.0;
            }
            every_other = !every_other;
        } while ((check = 1.0 + epsilon) != 1.0 && check != lastcheck);
        splitter += 1.0;
        ccwerrboundA = 1.0E-8;
        iccerrboundA = 1.0E-8;
    }

    public static double orient2d(Point2d a, Point2d b, Point2d c) {
        return GeomTests.orient2d(a.x, a.y, b.x, b.y, c.x, c.y);
    }

    public static final boolean testDiff(double a, double b) {
        return GeomTests.testDiff(a, b, a - b, ccwerrboundA);
    }

    public static final boolean testDiff(double a, double b, double eps) {
        return GeomTests.testDiff(a, b, a - b, eps);
    }

    public static final boolean testDiff(double a, double b, double diff, double eps) {
        if (a == b) {
            return true;
        }
        double sum = a > 0.0 ? (b > 0.0 ? a + b : a - b) : (b > 0.0 ? b - a : -a - b);
        double tol = sum * eps;
        return diff >= tol || -diff >= tol;
    }

    public static double orient2d(double ax, double ay, double bx, double by, double cx, double cy) {
        double detsum;
        double acx = ax - cx;
        double acy = ay - cy;
        double bcx = bx - cx;
        double bcy = by - cy;
        double detleft = acx * bcy;
        double detright = acy * bcx;
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return det;
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return det;
            }
            detsum = -detleft - detright;
        } else {
            return det;
        }
        double deterrbounds = ccwerrboundA * detsum;
        if ((det >= deterrbounds || -det >= deterrbounds) && GeomTests.testDiff(ax, cx, acx, ccwerrboundA) && GeomTests.testDiff(ay, cy, acy, ccwerrboundA) && GeomTests.testDiff(bx, cx, bcx, ccwerrboundA) && GeomTests.testDiff(by, cy, bcy, ccwerrboundA)) {
            return det;
        }
        return GeomTests.orient2dbig(ax, ay, bx, by, cx, cy);
    }

    public static double orient2dbig(Point2d a, Point2d b, Point2d c) {
        return GeomTests.orient2dbig(a.x, a.y, b.x, b.y, c.x, c.y);
    }

    public static double orient2dbig(double axd, double ayd, double bxd, double byd, double cxd, double cyd) {
        MathContext mc = MathContext.UNLIMITED;
        BigDecimal ax = BigDecimal.valueOf(axd);
        BigDecimal ay = BigDecimal.valueOf(ayd);
        BigDecimal bx = BigDecimal.valueOf(bxd);
        BigDecimal by = BigDecimal.valueOf(byd);
        BigDecimal cx = BigDecimal.valueOf(cxd);
        BigDecimal cy = BigDecimal.valueOf(cyd);
        BigDecimal acx = ax.subtract(cx, mc);
        BigDecimal acy = ay.subtract(cy, mc);
        BigDecimal bcx = bx.subtract(cx, mc);
        BigDecimal bcy = by.subtract(cy, mc);
        BigDecimal detleft = acx.multiply(bcy, mc);
        BigDecimal detright = acy.multiply(bcx, mc);
        BigDecimal det = detleft.subtract(detright, mc);
        return det.doubleValue();
    }

    public static double orient2dbigDiag(double axd, double ayd, double bxd, double byd, double cxd, double cyd) {
        MathContext mc = MathContext.UNLIMITED;
        BigDecimal ax = BigDecimal.valueOf(axd);
        BigDecimal ay = BigDecimal.valueOf(ayd);
        BigDecimal bx = BigDecimal.valueOf(bxd);
        BigDecimal by = BigDecimal.valueOf(byd);
        BigDecimal cx = BigDecimal.valueOf(cxd);
        BigDecimal cy = BigDecimal.valueOf(cyd);
        BigDecimal acx = ax.subtract(cx, mc);
        BigDecimal acy = ay.subtract(cy, mc);
        BigDecimal bcx = bx.subtract(cx, mc);
        BigDecimal bcy = by.subtract(cy, mc);
        BigDecimal detleft = acx.multiply(bcy, mc);
        BigDecimal detright = acy.multiply(bcx, mc);
        double acxd = axd - cxd;
        double acyd = ayd - cyd;
        double bcxd = bxd - cxd;
        double bcyd = byd - cyd;
        System.out.println(" acx: " + acxd);
        System.out.println("    : " + acx);
        System.out.println(" bcy: " + bcyd);
        System.out.println("    : " + bcy);
        System.out.println(" acy: " + acyd);
        System.out.println("    : " + acy);
        System.out.println(" bcx: " + bcxd);
        System.out.println("    : " + bcx);
        System.out.println("  exact left: " + detleft);
        System.out.println("  exact right: " + detright);
        BigDecimal det = detleft.subtract(detright, mc);
        return det.doubleValue();
    }

    public static double inCircle(Point2d a, Point2d b, Point2d c, Point2d d) {
        double a11 = a.x - d.x;
        double a12 = a.y - d.y;
        double a13 = a11 * a11 + a12 * a12;
        double a21 = b.x - d.x;
        double a32 = c.y - d.y;
        double a21a32 = a21 * a32;
        double a31 = c.x - d.x;
        double a22 = b.y - d.y;
        double a31a22 = a31 * a22;
        double C13 = a21a32 - a31a22;
        double a23 = a21 * a21 + a22 * a22;
        double a11a32 = a11 * a32;
        double a31a12 = a31 * a12;
        double C23 = a11a32 - a31a12;
        double a33 = a31 * a31 + a32 * a32;
        double a11a22 = a11 * a22;
        double a21a12 = a21 * a12;
        double C33 = a11a22 - a21a12;
        double det = a13 * C13 - a23 * C23 + a33 * C33;
        double permanent = (Math.abs(a21a32) + Math.abs(a31a22)) * a13 + (Math.abs(a11a32) + Math.abs(a31a12)) * a23 + (Math.abs(a11a22) + Math.abs(a21a12)) * a33;
        double errbound = Math.max(iccerrboundA * permanent, iccerrboundA);
        if (det > errbound || -det > errbound) {
            return det;
        }
        return GeomTests.inCircleExact(a, b, c, d);
    }

    public static double inCircleExact(Point2d a, Point2d b, Point2d c, Point2d d) {
        BigDecimal ax = BigDecimal.valueOf(a.x);
        BigDecimal ay = BigDecimal.valueOf(a.y);
        BigDecimal bx = BigDecimal.valueOf(b.x);
        BigDecimal by = BigDecimal.valueOf(b.y);
        BigDecimal cx = BigDecimal.valueOf(c.x);
        BigDecimal cy = BigDecimal.valueOf(c.y);
        BigDecimal dx = BigDecimal.valueOf(d.x);
        BigDecimal dy = BigDecimal.valueOf(d.y);
        BigDecimal a11 = ax.subtract(dx);
        BigDecimal a21 = bx.subtract(dx);
        BigDecimal a31 = cx.subtract(dx);
        BigDecimal a12 = ay.subtract(dy);
        BigDecimal a22 = by.subtract(dy);
        BigDecimal a32 = cy.subtract(dy);
        BigDecimal a13 = a11.multiply(a11).add(a12.multiply(a12));
        BigDecimal a23 = a21.multiply(a21).add(a22.multiply(a22));
        BigDecimal a33 = a31.multiply(a31).add(a32.multiply(a32));
        BigDecimal C13 = a21.multiply(a32).subtract(a31.multiply(a22));
        BigDecimal C23 = a11.multiply(a32).subtract(a31.multiply(a12));
        BigDecimal C33 = a11.multiply(a22).subtract(a21.multiply(a12));
        BigDecimal det = a13.multiply(C13);
        det = det.subtract(a23.multiply(C23));
        det = det.add(a33.multiply(C33));
        return det.doubleValue();
    }

    static {
        GeomTests.init();
    }
}

