/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in.teigha;

import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.NonSI;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;

public class TeighaTriangulationPnl
extends guiPanel
implements IEditor<IPropertySet> {
    public static final IPropertySet.Prop<UnitDouble> NORMAL_TOLERANCE = new IPropertySet.Prop<UnitDouble>("TeighaTriangulationPnl.NORMAL_TOLERANCE", new UnitDouble(15.0, NonSI.DEGREE_ANGLE));
    public static final IPropertySet.Prop<Integer> BETWEEN_KNOTS = new IPropertySet.Prop<Integer>("TeighaTriangulationPnl.BETWEEN_KNOTS", 5);
    public static final List<? extends IPropertySet.Prop<?>> PROPS = Arrays.asList(NORMAL_TOLERANCE, BETWEEN_KNOTS);
    private ValueField<UnitDouble> d_normTol;
    private ValueField<Integer> d_betweenKnots;

    public TeighaTriangulationPnl() {
        this.d_normTol = ValueFields.udFld((UnitDouble)TeighaTriangulationPnl.NORMAL_TOLERANCE.defVal, UnitDoubleVR.between(0.0, 90.0, NonSI.DEGREE_ANGLE, false, true), (IUnitSrc)new ConstantUnitSrc(NonSI.DEGREE_ANGLE));
        this.d_betweenKnots = ValueFields.intFld((Integer)TeighaTriangulationPnl.BETWEEN_KNOTS.defVal, IntVR.between(0, 100, true, true));
        this.setLayout(new GridBagLayout());
        GridBagHelper gbh = new GridBagHelper(this);
        this.add(gbh);
        gbh.finalizeRows();
    }

    public void add(GridBagHelper gbh) {
        guiLabel normTolLab = new guiLabel(Intl.intl("Normal Tolerance:"));
        normTolLab.setToolTipText(Intl.intl("Controls sphere, cone, torus, and cylinder detail. Decreasing tolerance increases quality."));
        guiLabel betweenKnotsLab = new guiLabel(Intl.intl("NURB Gridlines:"));
        betweenKnotsLab.setToolTipText(Intl.intl("Improve NURB tesselation quality by adding additional breaks between knots."));
        gbh.addRow(normTolLab, this.d_normTol);
        gbh.addRow(betweenKnotsLab, this.d_betweenKnots);
    }

    @Override
    public void init(IPropertySet props) {
        this.d_normTol.setValue(props.get(NORMAL_TOLERANCE));
        this.d_betweenKnots.setValue(props.get(BETWEEN_KNOTS));
    }

    @Override
    public IPropertySet preview(IPropertySet previewObj) {
        this.commit(previewObj);
        return previewObj;
    }

    @Override
    public IPropertySet commit(IPropertySet props) {
        props.setIfNotDefault(NORMAL_TOLERANCE, this.d_normTol.getValue());
        props.setIfNotDefault(BETWEEN_KNOTS, this.d_betweenKnots.getValue());
        return props;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

