/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in.teigha;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import thunderheadeng.cad.in.GeomImportSession;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.IImportSession;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;

public class TeighaGeomImportSession
extends GeomImportSession {
    private final boolean d_matchColorsExactly;

    public TeighaGeomImportSession(GeomImportSession.ICallback callback, IPropertySet props) {
        super(callback, TeighaGeomImportSession.modProps(props));
        this.d_matchColorsExactly = false;
    }

    private static IPropertySet modProps(IPropertySet props) {
        PropertySet modProps = new PropertySet();
        modProps.merge(props, IGeomImportSession.PROPS);
        modProps.setIfNotDefault(GeomImportSession.COMBINE_NODES, true);
        return modProps;
    }

    private Pair<ITransform, Collection<IGeomImportSession.Node>> collapseNodes(ITransform xform, Collection<IGeomImportSession.Node> nodes) {
        if (nodes.size() != 1 || nodes.iterator().next().dg != DisplayGeom.EMPTY) {
            return new Pair<ITransform, Collection<IGeomImportSession.Node>>(xform, nodes);
        }
        IGeomImportSession.Node root = nodes.iterator().next();
        return new Pair<ITransform, Collection<IGeomImportSession.Node>>(xform.concatenate(root.transform), root.children);
    }

    @Override
    public Collection<IGeomImportSession.Node> finalizeGeom() {
        Collection nodes = super.finalizeGeom();
        if (nodes.isEmpty()) {
            return nodes;
        }
        Pair<ITransform, Collection<IGeomImportSession.Node>> collapsed = this.collapseNodes(TransformUtil.IDENTITY, nodes);
        collapsed = this.collapseNodes((ITransform)collapsed.v1, (Collection)collapsed.v2);
        ITransform rootXform = (ITransform)collapsed.v1;
        nodes = (Collection)collapsed.v2;
        LinkedHashMap<String, List> layerMap = new LinkedHashMap<String, List>();
        Function<String, List> newListFunc = key -> new ArrayList();
        for (IGeomImportSession.Node node : nodes) {
            LayerGeomBuilder layerBuilder = new LayerGeomBuilder();
            TeighaGeomImportSession.addNode(layerBuilder, rootXform, node);
            LinkedHashMap<String, DisplayGeom> subLayers = new LinkedHashMap<String, DisplayGeom>();
            layerBuilder.finalizeGeom(subLayers);
            for (Map.Entry entry : subLayers.entrySet()) {
                List layerNodes = layerMap.computeIfAbsent((String)entry.getKey(), newListFunc);
                IGeomImportSession.Node splitNode = new IGeomImportSession.Node(node.id, node.name, TransformUtil.IDENTITY, node.props, (DisplayGeom)entry.getValue(), Collections.emptyList());
                layerNodes.add(splitNode);
            }
        }
        ArrayList<IGeomImportSession.Node> result = new ArrayList<IGeomImportSession.Node>();
        IImportSession.NodeProps emptyProps = new IImportSession.NodeProps();
        for (Map.Entry entry : layerMap.entrySet()) {
            IGeomImportSession.Node node = new IGeomImportSession.Node(-1L, (String)entry.getKey(), TransformUtil.IDENTITY, emptyProps, DisplayGeom.EMPTY, (Collection)entry.getValue());
            result.add(node);
        }
        return result;
    }

    private static void addNode(LayerGeomBuilder builder, ITransform parentXform, IGeomImportSession.Node node) {
        ITransform lwXform = parentXform.concatenate(node.transform);
        if (node.dg != DisplayGeom.EMPTY) {
            builder.add(node.props.layer, lwXform, node.dg);
        }
        for (IGeomImportSession.Node child : node.children) {
            TeighaGeomImportSession.addNode(builder, lwXform, child);
        }
    }

    private static class LayerGeomBuilder {
        private final Map<String, Info> d_layerGeoms = new LinkedHashMap<String, Info>();

        public void add(String layer, ITransform xform, DisplayGeom dg) {
            Info dgBuilder = this.d_layerGeoms.get(layer);
            if (dgBuilder == null) {
                dgBuilder = new Info();
                this.d_layerGeoms.put(layer, dgBuilder);
            }
            dgBuilder.add(xform, dg);
        }

        public void finalizeGeom(Map<String, DisplayGeom> finalLayerGeom) {
            for (Map.Entry<String, Info> entry : this.d_layerGeoms.entrySet()) {
                DisplayGeom finalDG = entry.getValue().finish();
                if (finalDG == DisplayGeom.EMPTY) continue;
                String layer = entry.getKey();
                finalLayerGeom.put(layer, finalDG);
            }
        }

        private static class Info {
            final DisplayGeomBuilder builder = new DisplayGeomBuilder();
            final Map<ITransform, DisplayGeomBuilder> children = new LinkedHashMap<ITransform, DisplayGeomBuilder>();

            public void add(ITransform xform, DisplayGeom dg) {
                dg = dg.quickTransform(xform.getInfo());
                if (dg.node.getLocalTransform().isIdentity()) {
                    this.builder.add(dg.node.getLocalGeom(), dg.props, dg.node.getLocalElements());
                } else {
                    DisplayGeomBuilder c = this.children.computeIfAbsent(dg.node.getLocalTransform(), t -> new DisplayGeomBuilder());
                    c.add(dg.node.getLocalGeom(), dg.props, dg.node.getLocalElements());
                }
            }

            public DisplayGeom finish() {
                PropsBuilder propsBuilder = new PropsBuilder();
                DisplayGeom ngeom = this.builder.finish().toDisplay();
                IGeomNode rootNode = ngeom.node;
                propsBuilder.add(ngeom.props, ngeom.node.getLocalGeom().getNumPrims(7));
                List<Object> childNodes = new ArrayList(this.children.size());
                for (Map.Entry<ITransform, DisplayGeomBuilder> entry : this.children.entrySet()) {
                    DisplayGeom dg = entry.getValue().finish().toDisplay();
                    propsBuilder.add(dg.props, dg.node.getLocalGeom().getNumPrims(7));
                    GeomNodeLeaf cnode = GeomNodeUtil.newNode(entry.getKey(), dg.node.getLocalGeom(), dg.node.getLocalElements());
                    childNodes.add(cnode);
                }
                if (ngeom == DisplayGeom.EMPTY) {
                    if (childNodes.isEmpty()) {
                        return DisplayGeom.EMPTY;
                    }
                    if (childNodes.size() == 1) {
                        rootNode = (IGeomNode)childNodes.get(0);
                        childNodes = Collections.emptyList();
                    }
                }
                IGeomNode node = GeomNodeUtil.newNode(rootNode.getLocalTransform(), rootNode.getLocalGeom(), rootNode.getLocalElements(), childNodes);
                return new DisplayGeom(node, propsBuilder.finalizeProps());
            }
        }
    }
}

