/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in.ifc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.cad.in.MaterialPnl;
import thunderheadeng.cad.in.OptionsPnl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.IPropertySet;

public class IfcPropEditor
extends guiPanel
implements IEditor<IPropertySet> {
    private static final List<IPropertySet.Prop<?>> MAT_PROPS = Arrays.asList(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS);
    public static final IPropertySet.Prop<IfcGrouping> IFC_GROUPING = new IPropertySet.Prop<IfcGrouping>("GeomImportSession.IFC_GROUPING", IfcGrouping.SPATIAL);
    public static final List<IPropertySet.Prop<?>> PROPS = new ArrayList();
    private final OptionsPnl d_options = new OptionsPnl();
    private final MaterialPnl d_materials = new MaterialPnl(MAT_PROPS);
    private final ObjectsPnl d_objects = new ObjectsPnl();

    public IfcPropEditor() {
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_options, 0, 1.0);
        gb.addTitle(Intl.intl("Materials"));
        gb.addIdentRow(this.d_materials, 0, 1.0);
        gb.addTitle(Intl.intl("Objects"));
        gb.addIdentRow(this.d_objects, 0, 1.0);
        gb.finalizeRows();
    }

    @Override
    public void init(IPropertySet dataObj) {
        this.d_options.init(dataObj);
        this.d_materials.init(dataObj);
        this.d_objects.init(dataObj);
    }

    @Override
    public IPropertySet commit(IPropertySet dataObj) {
        this.d_options.commit(dataObj);
        this.d_materials.commit(dataObj);
        this.d_objects.commit(dataObj);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    static {
        PROPS.addAll(OptionsPnl.PROPS);
        PROPS.addAll(MAT_PROPS);
        PROPS.add(IFC_GROUPING);
    }

    private static class ObjectsPnl
    extends guiPanel
    implements IEditor<IPropertySet> {
        private final guiComboBox<IfcGrouping> d_grouping = guiUtil.newCombo(IfcGrouping.SPATIAL, Intl.intl("Spatial"), Intl.intl("Groups objects by their spatial structure. For example, Building->Floor 1->Slab 1"), new Object[]{IfcGrouping.TYPE, Intl.intl("By Type"), Intl.intl("Groups objects by their type. For example, Wall -> {Wall 1, Wall 2}")});

        public ObjectsPnl() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Object Grouping:"), this.d_grouping, 0);
            gb.finalizeRows();
        }

        @Override
        public void init(IPropertySet dataObj) {
            this.d_grouping.setSelectedItem((Object)dataObj.get(IFC_GROUPING));
        }

        @Override
        public IPropertySet commit(IPropertySet dataObj) {
            dataObj.set(IFC_GROUPING, this.d_grouping.getSelectedItem());
            return dataObj;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    public static enum IfcGrouping {
        SPATIAL,
        TYPE;

    }
}

