/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import thunderheadeng.Intl;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IPropertySet;

public class ExporterPnl
extends guiPanel
implements IEditor<IPropertySet> {
    public static final IPropertySet.Prop<CadImporter.Exporter> EXPORTER = new IPropertySet.Prop<CadImporter.Exporter>("ExporterPnl.EXPORTER", CadImporter.Exporter.UNKNOWN);
    public static final IPropertySet.Prop<CadImporter.Exporter> DETECTED_EXPORTER = new IPropertySet.Prop<Object>("ExporterPnl.DETECTED_EXPORTER", null);
    public static final List<IPropertySet.Prop<?>> PROPS = Arrays.asList(EXPORTER, DETECTED_EXPORTER);
    private final guiComboBox<CadImporter.Exporter> d_exporterCB;
    private CadImporter.Exporter d_detectedExporter = null;

    public ExporterPnl(IPropertySet props) {
        this.d_detectedExporter = props.get(DETECTED_EXPORTER);
        this.d_exporterCB = new guiComboBox<CadImporter.Exporter>(CadImporter.Exporter.values());
        this.d_exporterCB.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String lbl;
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                switch ((CadImporter.Exporter)((Object)value)) {
                    case SIMLAB: {
                        lbl = Intl.intl("SimLab");
                        break;
                    }
                    default: {
                        lbl = Intl.intl("Unknown");
                    }
                }
                if (value == ExporterPnl.this.d_detectedExporter && ExporterPnl.this.d_detectedExporter != CadImporter.Exporter.UNKNOWN) {
                    lbl = String.format("%s (detected)", lbl);
                }
                this.setText(lbl);
                return this;
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        guiLabel whichLbl = new guiLabel(Intl.intl("Which software was used to export the FBX file?"));
        whichLbl.setToolTipText(Intl.intl("This controls which options are selected in the following steps."));
        gb.addFilledRow(whichLbl);
        gb.addIdentRow(this.d_exporterCB, 0);
        gb.finalizeRows();
    }

    @Override
    public void init(IPropertySet dataObj) {
        this.d_exporterCB.setSelectedItem((Object)dataObj.get(EXPORTER));
    }

    @Override
    public IPropertySet commit(IPropertySet dataObj) {
        CadImporter.Exporter newVal = this.d_exporterCB.getSelectedItem();
        if (newVal != dataObj.get(EXPORTER)) {
            ExporterPnl.initExporter(dataObj, newVal);
        }
        dataObj.setIfNotDefault(EXPORTER, newVal);
        return dataObj;
    }

    public static void initExporter(IPropertySet dataObj, CadImporter.Exporter exporter) {
        dataObj.set(EXPORTER, exporter);
        switch (exporter) {
            case SIMLAB: {
                dataObj.setIfNotDefault(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR, true);
                dataObj.setIfNotDefault(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS, true);
                break;
            }
            default: {
                dataObj.setIfNotDefault(IGeomImportSession.IGNORE_TRANSPARENCY_COLOR, false);
                dataObj.setIfNotDefault(IGeomImportSession.REPLACE_IDENTICAL_MATERIALS, false);
            }
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

