/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class CadSplitter {
    private final Map<IGeom, SplitGeom> geomSplitCache = new IdentityHashMap<IGeom, SplitGeom>();
    private final Map<IGeomNode, SplitNodeGeom> gnodeSplitCache = new IdentityHashMap<IGeomNode, SplitNodeGeom>();
    private final Map<IGeomImportSession.Node, Pair<IGeomImportSession.Node, IGeomImportSession.Node>> nodeSplitCache = new IdentityHashMap<IGeomImportSession.Node, Pair<IGeomImportSession.Node, IGeomImportSession.Node>>();

    public List<Pair<IGeomImportSession.Node, IGeomImportSession.Node>> splitGeom(Collection<IGeomImportSession.Node> nodes) {
        ArrayList<Pair<IGeomImportSession.Node, IGeomImportSession.Node>> result = new ArrayList<Pair<IGeomImportSession.Node, IGeomImportSession.Node>>(nodes.size());
        for (IGeomImportSession.Node node : nodes) {
            result.add(this.splitNode(node));
        }
        return result;
    }

    public Pair<IGeomImportSession.Node, IGeomImportSession.Node> splitNode(IGeomImportSession.Node node) {
        Pair<IGeomImportSession.Node, Object> result;
        Pair<IGeomImportSession.Node, IGeomImportSession.Node> cached = this.nodeSplitCache.get(node);
        if (cached != null) {
            return cached;
        }
        int numFaces = CadSplitter.getNumPrims(node, 1);
        int numNonFaces = CadSplitter.getNumPrims(node, 6);
        if (numFaces > 0 && numNonFaces > 0) {
            Pair<DisplayGeom, DisplayGeom> splitDisplay = this.splitDisplay(node.dg);
            ArrayList<IGeomImportSession.Node> faceChildren = new ArrayList<IGeomImportSession.Node>();
            ArrayList<IGeomImportSession.Node> nonFaceChildren = new ArrayList<IGeomImportSession.Node>();
            for (IGeomImportSession.Node child : node.children) {
                Pair<IGeomImportSession.Node, IGeomImportSession.Node> splitChild = this.splitNode(child);
                if (splitChild.v1 != null) {
                    faceChildren.add((IGeomImportSession.Node)splitChild.v1);
                }
                if (splitChild.v2 == null) continue;
                nonFaceChildren.add((IGeomImportSession.Node)splitChild.v2);
            }
            IGeomImportSession.Node faceNode = new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, splitDisplay.v1 != null ? (DisplayGeom)splitDisplay.v1 : DisplayGeom.EMPTY, faceChildren);
            IGeomImportSession.Node nonFaceNode = new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, splitDisplay.v2 != null ? (DisplayGeom)splitDisplay.v2 : DisplayGeom.EMPTY, nonFaceChildren);
            result = new Pair<IGeomImportSession.Node, IGeomImportSession.Node>(faceNode, nonFaceNode);
        } else {
            result = numFaces > 0 ? new Pair<IGeomImportSession.Node, Object>(node, null) : new Pair<Object, IGeomImportSession.Node>(null, node);
        }
        this.nodeSplitCache.put(node, result);
        return result;
    }

    private static int getNumPrims(IGeomImportSession.Node node, int types) {
        int count = node.dg.node.getNumPrims(types);
        for (IGeomImportSession.Node child : node.children) {
            count += CadSplitter.getNumPrims(child, types);
        }
        return count;
    }

    public Pair<DisplayGeom, DisplayGeom> splitDisplay(DisplayGeom dg) {
        SplitNodeGeom splitGNode = this.splitGeomNode(dg.node);
        return splitGNode.split(dg.props);
    }

    /*
     * WARNING - void declaration
     */
    public SplitNodeGeom splitGeomNode(IGeomNode gnode) {
        SplitNodeGeom result;
        SplitNodeGeom cached = this.gnodeSplitCache.get(gnode);
        if (cached != null) {
            return cached;
        }
        int numFaces = gnode.getNumPrims(1);
        int numNonFaces = gnode.getNumPrims(6);
        if (numFaces > 0 && numNonFaces > 0) {
            SplitGeom sgeom = this.splitGeom(gnode.getLocalGeom());
            ArrayList<IGeomNode> faceNodes = new ArrayList<IGeomNode>();
            ArrayList<IGeomNode> nonFaceNodes = new ArrayList<IGeomNode>();
            ArrayList<Integer> faceOffsets = new ArrayList<Integer>();
            if (sgeom.faceOffsets != null) {
                void var12_15;
                int[] nArray = sgeom.faceOffsets;
                int n = nArray.length;
                boolean bl = false;
                while (var12_15 < n) {
                    int fo = nArray[var12_15];
                    faceOffsets.add(fo);
                    ++var12_15;
                }
            } else if (sgeom.faces != null) {
                int numLocalFaces = sgeom.faces.getNumPrims(1);
                for (int m = 0; m < numLocalFaces; ++m) {
                    faceOffsets.add(m);
                }
            }
            int primOffset = gnode.getLocalGeom().getNumPrims(7);
            for (IGeomNode iGeomNode : gnode.getChildren()) {
                SplitNodeGeom splitChildNode = this.splitGeomNode(iGeomNode);
                if (splitChildNode.faces != null) {
                    faceNodes.add(splitChildNode.faces);
                    if (splitChildNode.faceOffsets != null) {
                        for (int foffset : splitChildNode.faceOffsets) {
                            faceOffsets.add(foffset + primOffset);
                        }
                    } else {
                        int numChildFaces = splitChildNode.faces.getNumPrims(1);
                        for (int m = 0; m < numChildFaces; ++m) {
                            faceOffsets.add(m + primOffset);
                        }
                    }
                }
                if (splitChildNode.nonFaces != null) {
                    nonFaceNodes.add(splitChildNode.nonFaces);
                }
                primOffset += iGeomNode.getNumPrims(7);
            }
            faceNodes.trimToSize();
            nonFaceNodes.trimToSize();
            IGeomNode faceNode = GeomNodeUtil.newNode(gnode.getLocalTransform(), sgeom.faces != null ? sgeom.faces : EmptyGeom.INSTANCE, sgeom.getFaceProps(new ElBuilder(), gnode.getLocalElements()), faceNodes);
            IGeomNode iGeomNode = GeomNodeUtil.newNode(gnode.getLocalTransform(), sgeom.nonFaces != null ? sgeom.nonFaces : EmptyGeom.INSTANCE, sgeom.getNonFaceProps(new ElBuilder(), gnode.getLocalElements()), nonFaceNodes);
            result = new SplitNodeGeom(gnode, faceNode, iGeomNode, theUtil.toIntArray(faceOffsets));
        } else {
            result = numFaces > 0 ? new SplitNodeGeom(gnode, gnode, null, null) : new SplitNodeGeom(gnode, null, gnode, null);
        }
        this.gnodeSplitCache.put(gnode, result);
        return result;
    }

    public SplitGeom splitGeom(IGeom geom) {
        SplitGeom result;
        SplitGeom cached = this.geomSplitCache.get(geom);
        if (cached != null) {
            return cached;
        }
        int numFaces = geom.getNumPrims(1);
        int numNonFaces = geom.getNumPrims(6);
        if (numFaces > 0 && numNonFaces > 0) {
            if (geom instanceof GeomGroup) {
                GeomGroup group = (GeomGroup)geom;
                ArrayList<IGeom> faces = new ArrayList<IGeom>();
                ArrayList<IGeom> nonFaces = new ArrayList<IGeom>();
                ArrayList<Integer> faceOffsets = new ArrayList<Integer>();
                int primOffset = 0;
                for (IGeom child : group.children) {
                    SplitGeom splitChild = this.splitGeom(child);
                    if (splitChild.faces != null) {
                        faces.add(splitChild.faces);
                        if (splitChild.faceOffsets != null) {
                            for (int foffset : splitChild.faceOffsets) {
                                faceOffsets.add(foffset + primOffset);
                            }
                        } else {
                            int numChildFaces = splitChild.faces.getNumPrims(1);
                            for (int m = 0; m < numChildFaces; ++m) {
                                faceOffsets.add(m + primOffset);
                            }
                        }
                    }
                    if (splitChild.nonFaces != null) {
                        nonFaces.add(splitChild.nonFaces);
                    }
                    primOffset += child.getNumPrims(7);
                }
                assert (!faces.isEmpty() && !nonFaces.isEmpty());
                result = new SplitGeom(geom, GeomUtil.group(faces), GeomUtil.group(nonFaces), theUtil.toIntArray(faceOffsets));
            } else {
                ArrayList<IPrimitive> faces = new ArrayList<IPrimitive>(numFaces);
                ArrayList<IPrimitive> nonFaces = new ArrayList<IPrimitive>(numNonFaces);
                int[] faceOffsets = new int[numFaces];
                List<IPrimitive> prims = GeomUtil.explodeToTypes(geom, 7);
                for (int m = 0; m < prims.size(); ++m) {
                    IPrimitive prim = prims.get(m);
                    if (prim instanceof IFace) {
                        faceOffsets[faces.size()] = m;
                        faces.add(prim);
                        continue;
                    }
                    nonFaces.add(prim);
                }
                result = new SplitGeom(geom, GeomUtil.group(faces), GeomUtil.group(nonFaces), faceOffsets);
            }
        } else {
            result = numFaces > 0 ? new SplitGeom(geom, geom, null, null) : new SplitGeom(geom, null, geom, null);
        }
        this.geomSplitCache.put(geom, result);
        return result;
    }

    private static <SrcT> SrcT getFaceProps(ItemBuilder<SrcT> builder, SrcT srcProps, int numFaces, int[] faceOffsets) {
        return CadSplitter.getItems(builder, srcProps, numFaces, faceOffsets);
    }

    private static <SrcT> SrcT getNonFaceProps(ItemBuilder<SrcT> builder, SrcT srcProps, int totNumPrim, int numNonFaces, int[] faceOffsets) {
        int[] offsets = faceOffsets != null ? CadSplitter.invertOffsets(faceOffsets, totNumPrim) : null;
        return CadSplitter.getItems(builder, srcProps, numNonFaces, offsets);
    }

    private static <SrcT> SrcT getItems(ItemBuilder<SrcT> builder, SrcT srcProps, int primCount, int[] offsets) {
        if (offsets == null) {
            builder.add(srcProps, primCount);
        } else {
            int m = 0;
            while (m < offsets.length) {
                int[] range = CadSplitter.getSequentialRange(offsets, m);
                int fo = offsets[range[0]];
                int count = range[1] - range[0];
                builder.add(srcProps, fo, count);
                m = range[1];
            }
        }
        return builder.finalizeItems();
    }

    private static int[] getSequentialRange(int[] offsets, int begin) {
        int prev = offsets[begin];
        for (int m = begin + 1; m < offsets.length; ++m) {
            int next = offsets[m];
            if (next != prev + 1) {
                return new int[]{begin, m};
            }
            prev = next;
        }
        return new int[]{begin, offsets.length};
    }

    private static int[] invertOffsets(int[] faceOffsets, int primCount) {
        int[] inverted = new int[primCount - faceOffsets.length];
        int ix = 0;
        int offset = 0;
        for (int m = 0; m < faceOffsets.length; ++m) {
            while (offset < faceOffsets[m]) {
                inverted[ix++] = offset++;
            }
            ++offset;
        }
        while (offset < primCount) {
            inverted[ix++] = offset++;
        }
        return inverted;
    }

    private static class ElBuilder
    implements ItemBuilder<IPropertySet> {
        private final ElementsBuilder d_builder = new ElementsBuilder();

        private ElBuilder() {
        }

        @Override
        public void add(IPropertySet src, int count) {
            this.d_builder.add(src, count);
        }

        @Override
        public void add(IPropertySet src, int offset, int count) {
            this.d_builder.addRange(src, offset, count);
        }

        @Override
        public IPropertySet finalizeItems() {
            return this.d_builder.finish();
        }
    }

    private static class PropBuilder
    implements ItemBuilder<IPropsSrc> {
        private final PropsBuilder d_builder = new PropsBuilder();

        private PropBuilder() {
        }

        @Override
        public void add(IPropsSrc src, int count) {
            this.d_builder.add(src, count);
        }

        @Override
        public void add(IPropsSrc src, int offset, int count) {
            this.d_builder.add(src.subset(offset, count), count);
        }

        @Override
        public IPropsSrc finalizeItems() {
            return this.d_builder.finalizeProps();
        }
    }

    public static interface ItemBuilder<SrcT> {
        public void add(SrcT var1, int var2);

        public void add(SrcT var1, int var2, int var3);

        public SrcT finalizeItems();
    }

    public static class SplitGeom {
        public final IGeom original;
        public final IGeom faces;
        public final IGeom nonFaces;
        public final int[] faceOffsets;

        public SplitGeom(IGeom original, IGeom faces, IGeom nonFaces, int[] originalFaceOffsets) {
            this.original = original;
            this.faces = faces;
            this.nonFaces = nonFaces;
            this.faceOffsets = originalFaceOffsets;
        }

        public <SrcT> SrcT getFaceProps(ItemBuilder<SrcT> builder, SrcT src) {
            return (SrcT)CadSplitter.getFaceProps(builder, src, this.faces != null ? this.faces.getNumPrims(7) : 0, this.faceOffsets);
        }

        public <SrcT> SrcT getNonFaceProps(ItemBuilder<SrcT> builder, SrcT src) {
            return (SrcT)CadSplitter.getNonFaceProps(builder, src, this.original.getNumPrims(7), this.nonFaces != null ? this.nonFaces.getNumPrims(7) : 0, this.faceOffsets);
        }
    }

    public static class SplitNodeGeom {
        public final IGeomNode original;
        public final IGeomNode faces;
        public final IGeomNode nonFaces;
        public final int[] faceOffsets;

        public SplitNodeGeom(IGeomNode original, IGeomNode faces, IGeomNode nonFaces, int[] faceOffsets) {
            this.original = original;
            this.faceOffsets = faceOffsets;
            this.faces = faces;
            this.nonFaces = nonFaces;
        }

        public Pair<DisplayGeom, DisplayGeom> split(IPropsSrc props) {
            if (this.faces != null && this.nonFaces != null) {
                int numFaces = this.faces.getNumPrims(7);
                int numNonFaces = this.nonFaces.getNumPrims(7);
                IPropsSrc fprops = (IPropsSrc)CadSplitter.getFaceProps(new PropBuilder(), props, numFaces, this.faceOffsets);
                IPropsSrc nfprops = (IPropsSrc)CadSplitter.getNonFaceProps(new PropBuilder(), props, numFaces + numNonFaces, numNonFaces, this.faceOffsets);
                return new Pair<DisplayGeom, DisplayGeom>(new DisplayGeom(this.faces, fprops), new DisplayGeom(this.nonFaces, nfprops));
            }
            if (this.faces != null) {
                return new Pair<DisplayGeom, Object>(new DisplayGeom(this.original, props), null);
            }
            return new Pair<Object, DisplayGeom>(null, new DisplayGeom(this.original, props));
        }
    }
}

