/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.cad.in;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.CadSplitter;
import thunderheadeng.cad.in.GeomImportSession;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.gui.wizard.WizardDlg;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class CadImportUI {
    public static final IPropertySet.Prop<File> FILE = new IPropertySet.Prop<Object>("SepImportCAD.FILE", null);
    public static final IPropertySet.Prop<IUnitSrc> LENGTH_UNIT_SRC = new IPropertySet.Prop<Object>("SepImportCAD.LENGTH_UNIT_SRC", null);
    public static final IPropertySet.Prop<BiFunction<String, IMatAttrs, IMaterial>> MAT_FACTORY = new IPropertySet.Prop<BiFunction<String, IMatAttrs, IMaterial>>("SepImportCAD.MAT_FACTORY", (name, attrs) -> null);
    public static final IPropertySet.Prop<UnitDouble> DEF_Z_LOC = new IPropertySet.Prop<UnitDouble>("SepImportCAD.DEF_Z_LOC", new UnitDouble(0.0, (Unit)SI.METER));
    public static final IPropertySet.Prop<Boolean> INCLUDE_ELEMENT_SUBTRACTIONS = new IPropertySet.Prop<Boolean>("SepImportCAD.INCLUDE_ELEMENT_SUBTRACTIONS", false);
    public static final IPropertySet.Prop<WarningReport<Warning>> WARNINGS = new IPropertySet.Prop<Object>("CadImportUI.WARNINGS", null);
    private static final IPropertySet.Prop<CADImportMgr> MGR = new IPropertySet.Prop<Object>("SepImportCAD.MGR", null);
    private static final IPropertySet.Prop<Boolean> IMPORT_LINES = new IPropertySet.Prop<Boolean>("IMPORT_LINES", false);
    private static final IPropertySet.Prop<Boolean> IMPORT_FACES = new IPropertySet.Prop<Boolean>("IMPORT_FACES", false);
    private static final IPropertySet.Prop<UnitDouble> Z_OFFSET = new IPropertySet.Prop<Object>("Z_OFFSET", null);
    private static final IPropertySet.Prop<Boolean> FLATTEN = new IPropertySet.Prop<Boolean>("FLATTEN", false);
    private static final IPropertySet.Prop<Color> BG_QUADS_COLOR = new IPropertySet.Prop<Object>("BG_QUADS_COLOR", null);
    private static final IPropertySet.Prop<Supplier<Stream<? extends IPropertySet.Prop<?>>>> IMPORTER_PROPS = new IPropertySet.Prop<Supplier<Stream>>("IMPORTER_PROPS", Collections.EMPTY_LIST::stream);

    public static String[] getFileFilters() {
        return CadImporter.getSupportedFileFormats();
    }

    public static AWizardCard<IPropertySet> getFirstWizardCard(IPropertySet options) {
        options.set(MGR, new CADImportMgr());
        return new OpenCard(options);
    }

    public static WizardDlg<IPropertySet> createWizard(Window parent, IPropertySet options) {
        WizardDlg<IPropertySet> wizard = new WizardDlg<IPropertySet>(parent, Intl.intl("Import"), String.format(Intl.intl("Import %s"), options.get(FILE).getName()), CadImportUI.getFirstWizardCard(options));
        wizard.init(options);
        return wizard;
    }

    public static void cleanup(IPropertySet options) {
        CADImportMgr mgr = options.get(MGR);
        if (mgr != null) {
            mgr.cleanup();
            options.setIfNotDefault(MGR, null);
        }
    }

    private static void getBounds(IGeomImportSession.Node node, AABox bounds) {
        AABox btransformer = GeomUtil.getBoundsTransformer(node.transform.getInfo(), bounds);
        node.dg.node.getBoundingBox(btransformer);
        for (IGeomImportSession.Node child : node.children) {
            CadImportUI.getBounds(child, btransformer);
        }
    }

    public static Collection<IGeomImportSession.Node> finalizeResult(IPropertySet options) {
        Collection<IGeomImportSession.Node> result = ((Analysis)options.get(CadImportUI.MGR).analyze.get()).importedNodes;
        Predicate<IGeomImportSession.Node> nodeFilter = Predicates.alwaysTrue();
        if (!options.get(INCLUDE_ELEMENT_SUBTRACTIONS).booleanValue()) {
            nodeFilter = Predicates.and(nodeFilter, n -> !n.props.getBIMType().isDescendentOf(BIMType.FeatureElementSubtraction));
        }
        result = CadImportUI.filter(result, nodeFilter);
        ArrayList<IGeomImportSession.Node> result2 = new ArrayList<IGeomImportSession.Node>();
        CadSplitter splitter = new CadSplitter();
        for (IGeomImportSession.Node node : result) {
            result2.add(CadImportUI.split(options, splitter, node));
        }
        result = result2;
        if (options.get(Z_OFFSET) != null) {
            AABox importBounds = new AABox();
            for (IGeomImportSession.Node node : result) {
                CadImportUI.getBounds(node, importBounds);
            }
            double z = options.get(Z_OFFSET).getValue(options.get(IGeomImportSession.DST_LENGTH_UNIT));
            Matrix4d xform = new Matrix4d(GeomConstants.IDENTITY4d);
            double moveDist = z - importBounds.getMinZ();
            if (!theUtil.eq0(moveDist, 1.0E-6)) {
                xform.mul(Util.translateMat(0.0, 0.0, moveDist));
            }
            System.out.println(importBounds.getMinZ());
            if (options.get(FLATTEN).booleanValue() && !theUtil.eq0(importBounds.getHeight(), 1.0E-6)) {
                Matrix4d projectionXform = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0E-9, importBounds.getMinZ(), 0.0, 0.0, 0.0, 1.0);
                xform.mul(projectionXform);
            }
            if (!xform.equals(GeomConstants.IDENTITY4d)) {
                MatrixXform transform = new MatrixXform(xform);
                ArrayList<IGeomImportSession.Node> xformed = new ArrayList<IGeomImportSession.Node>(result.size());
                for (IGeomImportSession.Node node : result) {
                    xformed.add(new IGeomImportSession.Node(node.id, node.name, transform.concatenate(node.transform), node.props, node.dg, node.children));
                }
                result = xformed;
            }
        }
        result = CadImportUI.removeUnsafeGeometry(result, options);
        return result;
    }

    private static ITransform computeTransform(List<IGeomImportSession.Node> path, IGeomImportSession.Node n, Map<IGeomImportSession.Node, ITransform> cache) {
        if (path.isEmpty()) {
            return n.transform;
        }
        IGeomImportSession.Node parent = path.get(path.size() - 1);
        ITransform parentXform = cache.computeIfAbsent(parent, p -> CadImportUI.computeTransform(path.subList(0, path.size() - 1), p, cache));
        return parentXform.concatenate(n.transform);
    }

    private static Collection<IGeomImportSession.Node> removeUnsafeGeometry(Collection<IGeomImportSession.Node> nodes, IPropertySet options) {
        WarningReport<Warning> warningReport = options.get(WARNINGS);
        IdentityHashMap xformCache = new IdentityHashMap();
        BiPredicate<List<IGeomImportSession.Node>, IGeomImportSession.Node> unsafeGeomFilter = (path, n) -> {
            if (!n.children.isEmpty()) {
                return true;
            }
            ITransform nxform = CadImportUI.computeTransform(path, n, xformCache);
            AABox importBounds = new AABox();
            AABox boundsCalc = GeomUtil.getBoundsTransformer(nxform.getInfo(), importBounds);
            n.dg.node.getBoundingBox(boundsCalc);
            if (!importBounds.isValid()) {
                return true;
            }
            boolean unsafe = importBounds.hasUnsafeBounds();
            if (unsafe && warningReport != null) {
                warningReport.addWarning(new Warning(String.format(Intl.intl("Geometry \"%s\" is unsafe - excessively large bounds."), n.name), Intl.intl("Geometry was ignored during import.")));
            }
            return !unsafe;
        };
        return CadImportUI.filter(nodes, unsafeGeomFilter);
    }

    public static DisplayGeom createBackgroundQuad(IPropertySet options, Supplier<AABox> modelBounds) {
        if (options.get(Z_OFFSET) != null && options.get(BG_QUADS_COLOR) != null) {
            AABox importBounds = modelBounds.get();
            double z = options.get(Z_OFFSET).getValue(options.get(IGeomImportSession.DST_LENGTH_UNIT));
            return CadImportUI.createBackgroundQuad(importBounds, z, options.get(BG_QUADS_COLOR));
        }
        return null;
    }

    public static DisplayGeom createBackgroundQuad(AABox geomBounds, double z, Color color) {
        AABox bb = geomBounds.scale(1.05);
        Quad quad = new Quad(new Point3d(bb.getMinX(), bb.getMinY(), z), new Point3d(bb.getMaxX(), bb.getMinY(), z), new Point3d(bb.getMaxX(), bb.getMaxY(), z), new Point3d(bb.getMinX(), bb.getMaxY(), z));
        IPrimProps.Face props = new IPrimProps.Face(color, null, 0);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(quad), (IPrimProps)props);
    }

    public static Collection<IGeomImportSession.Node> filter(Collection<IGeomImportSession.Node> nodes, Predicate<IGeomImportSession.Node> nodeFilter) {
        if (Predicates.alwaysTrue(nodeFilter)) {
            return nodes;
        }
        return CadImportUI.filter(nodes, (List<IGeomImportSession.Node> path, IGeomImportSession.Node node) -> nodeFilter.test((IGeomImportSession.Node)node));
    }

    public static Collection<IGeomImportSession.Node> filter(Collection<IGeomImportSession.Node> nodes, BiPredicate<List<IGeomImportSession.Node>, IGeomImportSession.Node> nodeFilter) {
        ArrayList<IGeomImportSession.Node> result2 = new ArrayList<IGeomImportSession.Node>();
        ArrayList<IGeomImportSession.Node> path = new ArrayList<IGeomImportSession.Node>();
        for (IGeomImportSession.Node node : nodes) {
            IGeomImportSession.Node fnode = CadImportUI.filter(path, node, nodeFilter);
            if (fnode == null) continue;
            result2.add(fnode);
        }
        return result2;
    }

    private static IGeomImportSession.Node filter(List<IGeomImportSession.Node> path, IGeomImportSession.Node node, BiPredicate<List<IGeomImportSession.Node>, IGeomImportSession.Node> filter) {
        if (!filter.test(path, node)) {
            return null;
        }
        path.add(node);
        ArrayList<IGeomImportSession.Node> newChildren = new ArrayList<IGeomImportSession.Node>();
        for (IGeomImportSession.Node child : node.children) {
            IGeomImportSession.Node fchild = CadImportUI.filter(path, child, filter);
            if (fchild == null) continue;
            newChildren.add(fchild);
        }
        path.remove(path.size() - 1);
        return new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, node.dg, newChildren);
    }

    private static IGeomImportSession.Node split(IPropertySet options, CadSplitter splitter, IGeomImportSession.Node node) {
        ArrayList<IGeomImportSession.Node> objs = new ArrayList<IGeomImportSession.Node>();
        if (node.dg != DisplayGeom.EMPTY) {
            String name;
            boolean nonFaces;
            Pair<DisplayGeom, DisplayGeom> split = splitter.splitDisplay(node.dg);
            boolean faces = options.get(IMPORT_FACES) != false && split.v1 != null;
            boolean bl = nonFaces = options.get(IMPORT_LINES) != false && split.v2 != null;
            if (faces) {
                name = split.v2 != null ? String.format(Intl.intl("%s [Faces]"), node.name) : node.name;
                IGeomImportSession.Node fnode = new IGeomImportSession.Node(node.id, name, TransformUtil.IDENTITY, node.props, (DisplayGeom)split.v1, Collections.emptyList());
                objs.add(fnode);
            }
            if (nonFaces) {
                name = split.v1 != null ? String.format(Intl.intl("%s [Lines]"), node.name) : node.name;
                IGeomImportSession.Node nfnode = new IGeomImportSession.Node(node.id, name, TransformUtil.IDENTITY, node.props, (DisplayGeom)split.v2, Collections.emptyList());
                objs.add(nfnode);
            }
            if (node.children.isEmpty() && objs.size() == 1) {
                IGeomImportSession.Node obj = (IGeomImportSession.Node)objs.get(0);
                return new IGeomImportSession.Node(obj.id, obj.name, node.transform.concatenate(obj.transform), obj.props, obj.dg, obj.children);
            }
        }
        for (IGeomImportSession.Node child : node.children) {
            objs.add(CadImportUI.split(options, splitter, child));
        }
        return new IGeomImportSession.Node(node.id, node.name, node.transform, node.props, DisplayGeom.EMPTY, objs);
    }

    private static Timer startProgressTimer(TaskProgress progress, ProgressPnl progPnl, Runnable whenDone) {
        Timer timer = new Timer(16, e -> {
            if (!progress.isRunning()) {
                Timer ltimer = (Timer)e.getSource();
                ltimer.stop();
                whenDone.run();
            } else {
                boolean indeterminate;
                int[] prog = progress.getProgress();
                boolean bl = indeterminate = prog == null;
                if (indeterminate != progPnl.d_progBar.isIndeterminate()) {
                    progPnl.d_progBar.setIndeterminate(indeterminate);
                }
                if (!indeterminate) {
                    progPnl.d_progBar.setMaximum(prog[1]);
                    progPnl.d_progBar.setValue(prog[0]);
                }
                progPnl.d_msg.setText(progress.getMessage());
            }
        });
        timer.start();
        return timer;
    }

    private static class ProgressPnl
    extends guiPanel {
        private final JProgressBar d_progBar = new JProgressBar(0, 100);
        private final guiLabel d_msg = new guiLabel("");

        public ProgressPnl() {
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_msg, 0);
            gb.addFilledRow(this.d_progBar);
        }
    }

    private static class Callback<T>
    extends GeomImportSession.ACallback {
        private final WizardDlg<T> d_parent;
        private final IPropertySet d_options;
        private boolean d_cancelled = false;
        private boolean d_skipAllMissing = false;
        private File d_lastAddedDir = null;
        private Set<String> d_skippedPaths = new HashSet<String>();

        public Callback(WizardDlg<T> parent, IPropertySet options) {
            super(options.get(FILE).getParentFile(), new File(options.get(FILE).getParentFile(), FilenameManager.splitFilename(options.get(FILE).getName())[0]));
            this.d_parent = parent;
            this.d_options = options;
            this.d_lastAddedDir = options.get(FILE).getParentFile();
        }

        @Override
        public File resolvePath(String path) {
            while (!this.d_cancelled) {
                File result = super.resolvePath(path);
                if (result != null) {
                    return result;
                }
                if (this.d_skipAllMissing || this.d_skippedPaths.contains(path)) {
                    return null;
                }
                String CHOOSE_DIR = Intl.intl("Choose another search location.");
                String SKIP_FILE = Intl.intl("Skip this file.");
                String SKIP_ALL = Intl.intl("Skip all missing files.");
                Object sel = JOptionPane.showInputDialog(this.d_parent, "<html>" + String.format(Intl.intl("The following file was referenced in the import but could not be found:<br>%s<br>What would you like to do?"), path), Intl.intl("Missing File"), 2, null, new Object[]{CHOOSE_DIR, SKIP_FILE, SKIP_ALL}, CHOOSE_DIR);
                if (sel == CHOOSE_DIR) {
                    guiFileChooser chooser = new guiFileChooser();
                    chooser.setFileSelectionMode(1);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setCurrentDirectory(this.d_lastAddedDir);
                    if (chooser.showOpenDialog(this.d_parent) != 0) continue;
                    File file = chooser.getSelectedFile();
                    this.addLibDir(file);
                    this.d_lastAddedDir = file.getParentFile();
                    continue;
                }
                if (sel == SKIP_FILE) {
                    this.d_skippedPaths.add(path);
                    return null;
                }
                if (sel == SKIP_ALL) {
                    this.d_skipAllMissing = true;
                    return null;
                }
                if (!this.d_parent.cancel()) continue;
                this.d_cancelled = true;
                return null;
            }
            return null;
        }

        @Override
        public IMaterial createMaterial(GeomImportSession.Material imat, IMatAttrs attrs) {
            return this.d_options.get(MAT_FACTORY).apply(imat.name, attrs);
        }
    }

    private static class AnalyzeCard
    extends AWizardCard<IPropertySet> {
        private static final String PROGRESS_CARD = "Progress";
        private static final String OPTIONS_CARD = "Options";
        private final CardLayout d_layout;
        private final ProgressPnl d_progPnl = new ProgressPnl();
        private final OptionsPnl d_optsPnl;
        private Timer d_progTimer;

        public AnalyzeCard(IPropertySet options) {
            super("");
            this.d_optsPnl = new OptionsPnl(options);
            this.d_layout = new CardLayout();
            this.setLayout(this.d_layout);
            this.add((Component)this.d_progPnl, PROGRESS_CARD);
            this.add((Component)this.d_optsPnl, OPTIONS_CARD);
        }

        @Override
        public boolean isActionEnabled(IPropertySet data, int action) {
            CADImportMgr mgr = (CADImportMgr)data.get(MGR);
            switch (action) {
                case 0: {
                    return true;
                }
                case 4: {
                    return mgr.analyze != null && mgr.analyze.isFinished();
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet data) {
            CADImportMgr mgr = (CADImportMgr)data.get(MGR);
            mgr.analyze(data, options -> new Callback(this.getWizard(), (IPropertySet)options));
            if (mgr.analyze.isRunning()) {
                this.setSubTitle(Intl.intl("Analyzing File"));
                this.d_layout.show(this, PROGRESS_CARD);
                this.d_progTimer = CadImportUI.startProgressTimer(mgr.analyze.progress, this.d_progPnl, () -> this.initFrom(data));
                return;
            }
            this.d_progTimer = null;
            try {
                mgr.analyze.validate();
            }
            catch (CancellationException e) {
                return;
            }
            catch (Throwable e) {
                String msg = String.format(Intl.intl("Error reading %s."), data.get(FILE).getAbsolutePath());
                guiUtil.showError(this, Intl.intl("Import Error"), msg, e);
                return;
            }
            this.setSubTitle(Intl.intl("Import Options"));
            Analysis analysis = (Analysis)mgr.analyze.get();
            Collection<IGeomImportSession.Node> nodes = analysis.importedNodes;
            assert (nodes != null);
            analysis.getConvertOptions(data);
            this.d_optsPnl.initFrom(analysis, data);
            this.d_layout.show(this, OPTIONS_CARD);
            this.setModified(true);
        }

        @Override
        public void saveTo(IPropertySet data) {
            this.d_optsPnl.saveTo(data);
        }

        @Override
        public AWizardCard getNext() {
            return null;
        }

        @Override
        public void cancel() {
            if (this.d_progTimer != null) {
                this.d_progTimer.stop();
                this.d_progTimer = null;
            }
        }

        private static class OptionsPnl
        extends guiPanel {
            private final guiLabel d_typeLbl;
            private final guiCheckBox d_linesCB;
            private final guiCheckBox d_facesCB;
            private final ComponentGroup d_geomTypeGroup;
            private final guiCheckBox d_offsetToZCB;
            private final ValueField<UnitDouble> d_offsetZ;
            private final guiCheckBox d_flattenCB;
            private final guiCheckBox d_makeBoxesCB;
            private final ColorButton d_makeBoxesColor;

            public OptionsPnl(IPropertySet options) {
                this.d_typeLbl = new guiLabel(Analysis.Type.FLOORPLAN.name);
                this.d_typeLbl.setFont(this.d_typeLbl.getFont().deriveFont(1));
                guiLabel geomTypeLbl = new guiLabel(Intl.intl("Geometry types to import:"));
                this.d_linesCB = new guiCheckBox(Intl.intl("Lines"));
                this.d_facesCB = new guiCheckBox(Intl.intl("Faces"));
                this.d_geomTypeGroup = new ComponentGroup(new Component[]{geomTypeLbl, this.d_linesCB, this.d_facesCB});
                this.d_offsetToZCB = new guiCheckBox(Intl.intl("Move geometry to Z = "));
                IUnitSrc offsetUnit = options.get(LENGTH_UNIT_SRC) != null ? options.get(LENGTH_UNIT_SRC) : new ConstantUnitSrc(SI.MILLI((Unit)SI.METER));
                this.d_offsetZ = ValueFields.udFld(offsetUnit);
                this.d_flattenCB = new guiCheckBox(Intl.intl("Flatten so geometry lies in one plane"));
                this.d_makeBoxesCB = new guiCheckBox(Intl.intl("Add a blank rectangle to obscure lower floors"));
                this.d_makeBoxesColor = new ColorButton();
                guiLabel colorLbl = new guiLabel(Intl.intl("Color:"));
                LinkStatus.link2((AbstractButton)this.d_offsetToZCB, this.d_offsetZ, this.d_flattenCB, this.d_makeBoxesCB, this.d_makeBoxesColor, colorLbl);
                LinkStatus.link2((AbstractButton)this.d_makeBoxesCB, this.d_makeBoxesColor, colorLbl);
                GridBagHelper gb = new GridBagHelper(this, true);
                gb.addRow(Intl.intl("Detected Geometry Type:"), this.d_typeLbl);
                gb.addRow(geomTypeLbl, 0);
                gb.addIdentRow(this.d_linesCB, 0);
                gb.addIdentRow(this.d_facesCB, 0);
                gb.addRow(this.d_offsetToZCB, this.d_offsetZ, 0);
                gb.indent();
                gb.addRow(this.d_flattenCB, 0);
                gb.addRow(this.d_makeBoxesCB, 0);
                gb.indent();
                guiPanel colorPnl = new guiPanel(new FlowLayout(0, gb.d_colSpace, 0));
                colorPnl.add(colorLbl);
                colorPnl.add(this.d_makeBoxesColor);
                gb.addRow(colorPnl, 0);
                gb.unindent();
                gb.unindent();
                gb.finalizeRows();
            }

            public void initFrom(Analysis analysis, IPropertySet co) {
                this.d_offsetZ.setValue(co.get(DEF_Z_LOC));
                this.d_linesCB.setSelected((Boolean)co.get(IMPORT_LINES));
                this.d_facesCB.setSelected((Boolean)co.get(IMPORT_FACES));
                boolean offsetting = co.get(Z_OFFSET) != null;
                this.d_offsetToZCB.setSelected(offsetting);
                if (co.get(Z_OFFSET) != null) {
                    this.d_offsetZ.setValue(co.get(Z_OFFSET));
                }
                this.d_flattenCB.setSelected(offsetting && (Boolean)co.get(FLATTEN) != false);
                this.d_makeBoxesCB.setSelected(offsetting && co.get(BG_QUADS_COLOR) != null);
                Color bgColor = co.get(BG_QUADS_COLOR) != null ? (Color)co.get(BG_QUADS_COLOR) : Color.BLACK;
                this.d_makeBoxesColor.setColor(bgColor);
                int[] counts = new int[]{0, 0};
                for (IGeomImportSession.Node node : analysis.importedNodes) {
                    this.countPrims(node, counts);
                }
                int numFaces = counts[0];
                int numLines = counts[1];
                boolean showGeomTypeGroup = false;
                showGeomTypeGroup |= (Boolean)co.get(IMPORT_LINES) == false && numLines != 0;
                this.d_geomTypeGroup.setVisible(showGeomTypeGroup |= (Boolean)co.get(IMPORT_FACES) == false && numFaces != 0);
                this.d_linesCB.setText(String.format(Intl.intl("Lines (%d detected)"), numLines));
                this.d_facesCB.setText(String.format(Intl.intl("Faces (%d detected)"), numFaces));
                this.d_typeLbl.setText(analysis.detectedType.name);
            }

            private void countPrims(IGeomImportSession.Node node, int[] counts) {
                counts[0] = counts[0] + node.dg.node.getNumPrims(1);
                counts[1] = counts[1] + node.dg.node.getNumPrims(-2);
                for (IGeomImportSession.Node ent : node.children) {
                    this.countPrims(ent, counts);
                }
            }

            public void saveTo(IPropertySet data) {
                boolean offsetting = this.d_offsetToZCB.isSelected();
                data.set(Z_OFFSET, offsetting ? (UnitDouble)this.d_offsetZ.getValue() : null);
                if (offsetting) {
                    data.set(FLATTEN, this.d_flattenCB.isSelected());
                    data.set(BG_QUADS_COLOR, this.d_makeBoxesCB.isSelected() ? this.d_makeBoxesColor.getColor() : null);
                }
                data.set(IMPORT_FACES, this.d_facesCB.isSelected());
                data.set(IMPORT_LINES, this.d_linesCB.isSelected());
            }

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                if (!this.d_linesCB.isSelected() && !this.d_facesCB.isSelected()) {
                    if (showWarn) {
                        String msg = Intl.intl("At least lines or faces must be imported.");
                        guiDialog.showInvalidEntryMessage(this, msg);
                    }
                    return false;
                }
                return true;
            }
        }
    }

    private static class OpenCard
    extends AWizardCard<IPropertySet> {
        private final CadImporter d_importer;
        private final ProgressPnl d_progPnl;
        private final IPropertySet d_options;
        private Timer d_progTimer;

        public OpenCard(IPropertySet options) {
            super(Intl.intl("Import Settings"));
            this.setSubTitle(Intl.intl("Opening File"));
            this.d_options = options;
            this.d_importer = ((CADImportMgr)options.get(MGR)).importer;
            this.d_progPnl = new ProgressPnl();
            this.add(this.d_progPnl);
        }

        @Override
        public boolean isActionEnabled(IPropertySet data, int action) {
            CADImportMgr mgr = (CADImportMgr)data.get(MGR);
            switch (action) {
                case 0: {
                    return true;
                }
                case 4: {
                    return false;
                }
                case 1: {
                    return mgr.open != null && !mgr.open.progress.isRunning();
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet data) {
            CADImportMgr mgr = (CADImportMgr)data.get(MGR);
            mgr.open(data);
            if (mgr.open.progress.isRunning()) {
                this.d_progTimer = CadImportUI.startProgressTimer(mgr.open.progress, this.d_progPnl, () -> this.initFrom(data));
                return;
            }
            this.d_progTimer = null;
            try {
                mgr.open.validate();
            }
            catch (CancellationException e) {
                return;
            }
            catch (Throwable t) {
                guiUtil.showError(SwingUtilities.getWindowAncestor(this), Intl.intl("File Error"), String.format(Intl.intl("Error opening file: %s"), data.get(FILE).getAbsolutePath()), t);
                return;
            }
            this.setModified(true);
            WizardDlg wizard = this.getWizard();
            if (wizard != null) {
                wizard.skip();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return OpenCard.getMaxDimension(super.getPreferredSize(), new AnalyzeCard(this.d_options).getPreferredSize());
        }

        @Override
        public void cancel() {
            if (this.d_progTimer != null) {
                this.d_progTimer.stop();
                this.d_progTimer = null;
            }
        }

        private List<CadImporter.Editor> createEditors(IPropertySet options) {
            return this.d_importer.createPropertyEditors(true, true, options, options.get(LENGTH_UNIT_SRC));
        }

        @Override
        public void saveTo(IPropertySet data) {
            List<CadImporter.Editor> editors = this.createEditors(data);
            List editorProps = editors.stream().flatMap(ed -> ed.props.stream()).collect(Collectors.toList());
            Supplier<Stream> propsSrc = editorProps::stream;
            data.set(IMPORTER_PROPS, propsSrc);
            PropertySet oprops = (PropertySet)((CADImportMgr)data.get(MGR)).open.get();
            data.merge((IPropertySet)oprops, propsSrc.get());
        }

        @Override
        public AWizardCard getNext() {
            List<CadImporter.Editor> editors = this.createEditors(this.d_options);
            if (editors.isEmpty()) {
                return new AnalyzeCard(this.d_options);
            }
            return new ImporterPropCard(this.d_options, editors, 0);
        }
    }

    private static class ImporterPropCard
    extends AWizardCard<IPropertySet> {
        private final List<CadImporter.Editor> d_editors;
        private final int d_ix;
        private final IPropertySet d_options;

        public ImporterPropCard(IPropertySet options, List<CadImporter.Editor> editors, int ix) {
            super(editors.get((int)ix).desc);
            this.d_options = options;
            this.d_editors = editors;
            this.d_ix = ix;
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addFilledRow(editors.get((int)ix).editor.getEditorPanel());
            gb.finalizeRows();
        }

        @Override
        public boolean isActionEnabled(IPropertySet data, int action) {
            switch (action) {
                case 4: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void initFrom(IPropertySet data) {
            this.d_editors.get((int)this.d_ix).editor.init(data);
        }

        @Override
        public void saveTo(IPropertySet data) {
            this.d_editors.get((int)this.d_ix).editor.commit(data);
        }

        @Override
        public Dimension getPreferredSize() {
            return ImporterPropCard.getMaxDimension(super.getPreferredSize(), new AnalyzeCard(this.d_options).getPreferredSize());
        }

        @Override
        public AWizardCard getNext() {
            if (this.d_ix < this.d_editors.size() - 1) {
                return new ImporterPropCard(this.d_options, this.d_editors, this.d_ix + 1);
            }
            return new AnalyzeCard(this.d_options);
        }

        @Override
        public void cancel() {
        }
    }

    public static class CADImportMgr {
        public static final List<? extends IPropertySet.Prop<?>> ANALYZE_PROPS = Arrays.asList(CadImportUI.access$200(), CadImportUI.access$100(), CadImportUI.access$400(), CadImportUI.access$300(), CadImportUI.access$500());
        public CadImporter importer = new CadImporter();
        public OpenTask open = null;
        public AnalyzeTask analyze = null;

        public void cleanup() {
            if (this.open != null) {
                this.open.cancel();
                this.open = null;
            }
            if (this.analyze != null) {
                this.analyze.cancel();
                this.analyze = null;
            }
            if (this.importer != null) {
                this.importer.freeData();
                this.importer = null;
            }
        }

        public void open(IPropertySet options) {
            if (this.open != null) {
                File file = options.get(FILE);
                assert (file != null);
                if (this.open.filename.equalsIgnoreCase(file.getAbsolutePath())) {
                    return;
                }
                this.open.cancel();
                this.open = null;
            }
            assert (this.importer != null);
            this.open = new OpenTask(options);
        }

        public void analyze(IPropertySet options, Function<IPropertySet, GeomImportSession.ICallback> callbackSupplier) {
            if (this.analyze != null) {
                if (this.analyze.props.compare(options, AnalyzeTask.getInputProps(options))) {
                    return;
                }
                this.analyze.cancel();
                this.analyze = null;
            }
            assert (this.importer != null);
            this.analyze = new AnalyzeTask(options, callbackSupplier);
        }
    }

    private static class ConvertOptions
    implements Cloneable {
        public boolean importLines;
        public boolean importFaces;
        public UnitDouble zOffset;
        public boolean flatten;
        public Color backgroundQuadsColor;

        private ConvertOptions() {
        }

        public ConvertOptions clone() {
            try {
                return (ConvertOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static class AnalyzeTask
    extends Task<Analysis> {
        private static final List<? extends IPropertySet.Prop<?>> INPUT_PROPS = IGeomImportSession.PROPS;
        public final PropertySet props = new PropertySet();

        public AnalyzeTask(IPropertySet options, Function<IPropertySet, GeomImportSession.ICallback> callbackSupplier) {
            super(progress -> {
                try {
                    CADImportMgr mgr = (CADImportMgr)options.get(MGR);
                    IGeomImportSession cadGeom = mgr.importer.createCompatibleGeomTarget((GeomImportSession.ICallback)callbackSupplier.apply(options), options);
                    if (cadGeom == null) {
                        throw new IOException(String.format(Intl.intl("Could not create importer for %s"), options.get(FILE).getName()));
                    }
                    mgr.importer.setProperties(options);
                    mgr.importer.importCad((TaskProgress)progress, cadGeom);
                    return new Analysis(cadGeom.finalizeGeom());
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            });
            this.props.merge(options, AnalyzeTask.getInputProps(options));
        }

        public static Stream<? extends IPropertySet.Prop<?>> getInputProps(IPropertySet options) {
            return Stream.concat((Stream)((Supplier)options.get(IMPORTER_PROPS)).get(), INPUT_PROPS.stream());
        }
    }

    private static class Analysis {
        public final Collection<IGeomImportSession.Node> importedNodes;
        public final Type detectedType;

        public Analysis(Collection<IGeomImportSession.Node> importedNodes) {
            this.importedNodes = importedNodes;
            this.detectedType = Analysis.detectType(importedNodes);
        }

        private static Type detectType(Collection<IGeomImportSession.Node> nodes) {
            for (IGeomImportSession.Node node : nodes) {
                if (!Analysis.isModel(node)) continue;
                return Type.MODEL;
            }
            return Type.FLOORPLAN;
        }

        private static boolean isModel(IGeomImportSession.Node node) {
            if (Analysis.isModel(node.dg.node)) {
                return true;
            }
            for (IGeomImportSession.Node child : node.children) {
                if (!Analysis.isModel(child)) continue;
                return true;
            }
            return false;
        }

        private static boolean isModel(IGeomNode node) {
            AABox bounds = new AABox();
            for (IPrimitive iPrimitive : GeomUtil.explode(node.getLocalGeom(), IPrimitive.class)) {
                bounds.reset();
                iPrimitive.getBoundingBox(bounds);
                if (!theUtil.gt0(bounds.getHeight(), 0.01)) continue;
                return true;
            }
            for (IGeomNode iGeomNode : node.getChildren()) {
                if (!Analysis.isModel(iGeomNode)) continue;
                return true;
            }
            return false;
        }

        public void getConvertOptions(IPropertySet opts) {
            switch (this.detectedType) {
                case FLOORPLAN: {
                    opts.set(IMPORT_FACES, false);
                    opts.set(IMPORT_LINES, true);
                    opts.set(Z_OFFSET, opts.get(DEF_Z_LOC));
                    opts.set(FLATTEN, true);
                    if (opts.get(BG_QUADS_COLOR) != null) break;
                    opts.set(BG_QUADS_COLOR, Color.BLACK);
                    break;
                }
                case MODEL: {
                    opts.set(IMPORT_LINES, false);
                    opts.set(IMPORT_FACES, true);
                    opts.set(Z_OFFSET, null);
                    opts.set(FLATTEN, false);
                    opts.set(BG_QUADS_COLOR, null);
                }
            }
        }

        public static enum Type {
            FLOORPLAN(Intl.intl("2D Floorplan")),
            MODEL(Intl.intl("3D Model"));

            public final String name;

            private Type(String name) {
                this.name = name;
            }
        }
    }

    private static class OpenTask
    extends Task<PropertySet> {
        public final String filename;

        public OpenTask(IPropertySet options) {
            super((TaskProgress progress) -> {
                CADImportMgr mgr = (CADImportMgr)options.get(MGR);
                try {
                    mgr.importer.openCad((TaskProgress)progress, options.get(FILE).getAbsolutePath());
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                PropertySet result = new PropertySet();
                mgr.importer.initProperties(result, true);
                return result;
            });
            this.filename = options.get(FILE).getAbsolutePath();
        }
    }

    private static class Task<T> {
        public final TaskProgress progress = new TaskProgress();
        private Throwable d_caughtError;
        private T d_data;
        private boolean d_running = true;

        public Task(Function<TaskProgress, T> tsk) {
            Runnable task = () -> {
                try {
                    Object result = tsk.apply(this.progress);
                    Task task = this;
                    synchronized (task) {
                        this.d_data = result;
                    }
                }
                catch (RuntimeException e) {
                    Task task = this;
                    synchronized (task) {
                        this.d_caughtError = e.getCause();
                    }
                }
                finally {
                    Task task = this;
                    synchronized (task) {
                        this.progress.cancel();
                        this.d_running = false;
                        this.notifyAll();
                    }
                }
            };
            new Thread(task).start();
        }

        public synchronized T get() {
            return this.d_data;
        }

        public synchronized void cancel() {
            while (this.d_running) {
                this.progress.cancel();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public boolean isFinished() {
            return !this.progress.isRunning() && this.get() != null;
        }

        public boolean isRunning() {
            return this.progress.isRunning();
        }

        public synchronized void validate() throws ExecutionException, CancellationException {
            if (this.d_caughtError instanceof CancellationException) {
                throw new CancellationException();
            }
            if (this.d_caughtError != null) {
                throw new ExecutionException(this.d_caughtError);
            }
        }
    }
}

