/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import thunderheadeng.geometry.objs.GeneralPoly;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.NGon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.io.LegacyDictionary;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashSet;
import thunderheadeng.legacy.v1.util.ListSet;
import thunderheadeng.legacy.v1.util.theHashMap;
import thunderheadeng.legacy.v1.util.theHashSet;
import thunderheadeng.legacy.v1.util.theLinkedHashMap;
import thunderheadeng.legacy.v1.util.theLinkedHashSet;
import thunderheadeng.legacy.v10.scene3d.geom.DefMaterial;
import thunderheadeng.legacy.v11.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.legacy.v12.util.AcceptAllFilter;
import thunderheadeng.legacy.v12.util.AcceptNoneFilter;
import thunderheadeng.legacy.v12.util.Filters;
import thunderheadeng.legacy.v13.geometry.objs.AProxyGeom;
import thunderheadeng.legacy.v13.geometry.objs.GeomGroup;
import thunderheadeng.legacy.v13.geometry.objs.ShapeGeom;
import thunderheadeng.legacy.v13.geometry.objs.SolidGeom;
import thunderheadeng.legacy.v13.geometry.objs.TransformedGeom;
import thunderheadeng.legacy.v13.scene3d.geom.IUVPrim;
import thunderheadeng.legacy.v13.scene3d.geom.UVEmpty;
import thunderheadeng.legacy.v13.scene3d.geom.UVFlattened;
import thunderheadeng.legacy.v13.scene3d.geom.UVGroup;
import thunderheadeng.legacy.v13.scene3d.geom.UVMesh;
import thunderheadeng.legacy.v13.scene3d.geom.UVPoly;
import thunderheadeng.legacy.v13.scene3d.geom.UVUniform;
import thunderheadeng.legacy.v16.cad.BIMType;
import thunderheadeng.legacy.v4.geometry.objs.Mesh;
import thunderheadeng.legacy.v5.geometry.objs.WallGeom;
import thunderheadeng.legacy.v7.scene3d.geom.IPrimProps;
import thunderheadeng.legacy.v8.io.StreamSources;
import thunderheadeng.legacy.v9.image.Image;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class TeciIO {
    public static final int VERSION_001 = 1;
    public static final int VERSION_002 = 2;
    public static final int VERSION_003 = 3;
    public static final int VERSION_004 = 4;
    public static final int VERSION_005 = 5;
    public static final int VERSION_006 = 6;
    public static final int VERSION_007 = 7;
    public static final int VERSION_008 = 8;
    public static final int VERSION_009 = 9;
    public static final int VERSION_010 = 10;
    public static final int VERSION_011 = 11;
    public static final int VERSION_012 = 12;
    public static final int VERSION_013 = 13;
    public static final int VERSION_014 = 14;
    public static final int VERSION_015 = 15;
    public static final int VERSION_016 = 16;
    public static final int VERSION_017 = 17;
    public static final int CURR_VERSION = 17;
    private final int d_version;
    private final LegacyDictionary d_legDictionary;
    private final List<MatAttrs> d_pre16MatAttrs = new ArrayList<MatAttrs>();

    public TeciIO(int version) {
        this.d_version = version;
        this.d_legDictionary = new LegacyDictionary(version);
        this.map(2, "thunderheadeng.util.LinkedIdentityHashMap", LinkedIdentityHashMap.class);
        this.map(2, "thunderheadeng.util.LinkedIdentityHashSet", LinkedIdentityHashSet.class);
        this.map(2, "thunderheadeng.util.ListSet", ListSet.class);
        this.map(2, "thunderheadeng.util.theHashMap", theHashMap.class);
        this.map(2, "thunderheadeng.util.theHashSet", theHashSet.class);
        this.map(2, "thunderheadeng.util.theLinkedHashMap", theLinkedHashMap.class);
        this.map(2, "thunderheadeng.util.theLinkedHashSet", theLinkedHashSet.class);
        this.map(3, "thunderheadeng.scene3d.nativebuffered.Image", Image.class);
        this.map(5, "thunderheadeng.geometry.objs.Mesh", Mesh.class);
        this.map(6, "thunderheadeng.geometry.objs.WallGeom", WallGeom.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$AProps", IPrimProps.AProps.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$GenericProps", IPrimProps.GenericProps.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$Face", IPrimProps.Face.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$Edge", IPrimProps.Edge.class);
        this.map(8, "thunderheadeng.scene3d.geom.IPrimProps$Vertex", IPrimProps.Vertex.class);
        this.map(9, "thunderheadeng.io.StreamSources$FileSrc", StreamSources.FileSrc.class);
        this.map(9, "thunderheadeng.io.StreamSources$ByteArraySrc", StreamSources.ByteArraySrc.class);
        this.map(9, "thunderheadeng.io.StreamSources$ByteBufferSrc", StreamSources.ByteBufferSrc.class);
        this.map(9, "thunderheadeng.io.StreamSources$DecryptSrc", StreamSources.DecryptSrc.class);
        this.map(10, "thunderheadeng.image.Image", Image.class);
        this.map(11, "thunderheadeng.scene3d.geom.DefMaterial", DefMaterial.class);
        this.map(12, "thunderheadeng.scene3d.nativebuffered.CameraRecord", CameraRecord.class);
        this.map(13, "thunderheadeng.util.Filters$Logic", Filters.Logic.class);
        this.map(13, "thunderheadeng.util.Filters$InvertFilter", Filters.InvertFilter.class);
        this.map(13, "thunderheadeng.util.Filters$CompoundFilter", Filters.CompoundFilter.class);
        this.map(13, "thunderheadeng.util.Filters$MultiCompoundFilter", Filters.MultiCompoundFilter.class);
        this.map(13, "thunderheadeng.util.Filters$CachedFilter", Filters.CachedFilter.class);
        this.map(13, "thunderheadeng.util.AcceptAllFilter", AcceptAllFilter.class);
        this.map(13, "thunderheadeng.util.AcceptNoneFilter", AcceptNoneFilter.class);
        this.map(14, "thunderheadeng.scene3d.geom.IUVPrim", IUVPrim.class);
        this.map(14, "thunderheadeng.scene3d.geom.MatAttrs", thunderheadeng.legacy.v13.scene3d.geom.MatAttrs.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVEmpty", UVEmpty.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVEmpty$1", UVEmpty.UV_OBJ.getClass());
        this.map(14, "thunderheadeng.scene3d.geom.UVFlattened", UVFlattened.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVGroup", UVGroup.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVGroup$Entry", UVGroup.Entry.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVMesh", UVMesh.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVMesh$Prim", UVMesh.Prim.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVPoly", UVPoly.class);
        this.map(14, "thunderheadeng.scene3d.geom.UVUniform", UVUniform.class);
        this.map(14, "thunderheadeng.geometry.objs.AProxyGeom", AProxyGeom.class);
        this.map(14, "thunderheadeng.geometry.objs.GeomGroup", GeomGroup.class);
        this.map(14, "thunderheadeng.geometry.objs.SolidGeom", SolidGeom.class);
        this.map(14, "thunderheadeng.geometry.objs.TransformedGeom", TransformedGeom.class);
        this.map(15, "thunderheadeng.geometry.objs.WallGeom", thunderheadeng.legacy.v14.geometry.objs.WallGeom.class);
        this.map(17, "thunderheadeng.cad.BIMType", BIMType.class);
    }

    private void map(int version, String name, Class clazz) {
        this.d_legDictionary.addLegClass(version, name, clazz);
    }

    public Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        if (name.equals("thunderheadeng.geometry.objs.ShapeGeom$ShapePrimitive") && osc.getSerialVersionUID() == 1106115886445448015L) {
            return ShapeGeom.ShapePrimitive.class;
        }
        if (name.equals("thunderheadeng.geometry.objs.ShapeGeom$ShapeCurve") && osc.getSerialVersionUID() == 5421416398197187057L) {
            return ShapeGeom.ShapeCurve.class;
        }
        TriConsumer<String, Long, Long> fixSUID = (cname, oldId, newId) -> {
            if (name.equals(cname) && osc.getSerialVersionUID() == oldId.longValue()) {
                try {
                    theUtil.assignFinalField(osc, ObjectStreamClass.class, "suid", newId);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        fixSUID.accept("thunderheadeng.geometry.objs.ClosedLinearCurve", 8783959934722819851L, 4032153402700153011L);
        return this.d_legDictionary.resolveClass(name);
    }

    public Object resolveObject(Object obj) throws IOException {
        if (this.d_version < 4 && obj instanceof NGon) {
            return TeciIO.resolvePre4NGon((NGon)obj);
        }
        if (this.d_version < 7 && obj instanceof Quad) {
            Quad q = (Quad)obj;
            return PolyUtil.newPoly(q.p1, q.p2, q.p3, q.p4);
        }
        if (this.d_version < 16 && obj instanceof MatAttrs) {
            return TeciIO.resolvePre16MatAttrs((MatAttrs)obj);
        }
        if (this.d_version < 17 && obj instanceof BIMType) {
            return ((BIMType)((Object)obj)).convert();
        }
        return obj;
    }

    private static IPolygon resolvePre4NGon(NGon poly) {
        Point3d[] points = poly.points;
        ArrayList<Integer> loops = new ArrayList<Integer>();
        int ix = 0;
        while (ix < points.length) {
            Point3d next;
            Point3d first = points[ix];
            loops.add(ix++);
            while (ix < points.length && !first.equals((Tuple3d)(next = points[ix++]))) {
            }
        }
        if (loops.size() <= 1) {
            return poly;
        }
        return new GeneralPoly(points, theUtil.toIntArray(loops));
    }

    public static MatAttrs resolvePre16MatAttrs(MatAttrs attrs) {
        Color diffColor = attrs.get(IMatAttrs.DIFFUSE_COLOR);
        if (diffColor.getAlpha() < 255) {
            int a = diffColor.getAlpha();
            Color newDiffuse = new Color(diffColor.getRed(), diffColor.getGreen(), diffColor.getBlue(), 255);
            Color newOpac = new Color(a, a, a);
            attrs = attrs.apply(IMatAttrs.DIFFUSE_COLOR, newDiffuse, IMatAttrs.OPACITY_COLOR, newOpac);
        }
        return attrs;
    }
}

