/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.MathMLSerializer;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.swing.MathComponentUI;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMathComponent
extends JComponent
implements SwingConstants {
    private static final String DEFAULT_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE math PUBLIC \"-//W3C//DTD MathML 2.0//EN\" \"http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\">\n<math mode=\"display\">\n    <mrow>\n        <munderover>\n            <mo>&#x0222B;</mo>\n            <mn>1</mn>\n            <mi>x</mi>\n        </munderover>\n        <mfrac>\n            <mi>dt</mi>\n            <mi>t</mi>\n        </mfrac>\n    </mrow>\n</math>";
    private static final String FONT_SEPARATOR = ",";
    private static final long serialVersionUID = 1L;
    private static final String UI_CLASS_ID = "MathComponentUI";
    private Document document;
    private int horizontalAlignment = 0;
    private final Map<ParameterKey, String> parameters = MathBase.getDefaultParameters();
    private int verticalAlignment = 0;

    public JMathComponent() {
        this.updateUI();
        this.fontCompat();
        this.setContent(DEFAULT_DOCUMENT);
    }

    private void fontCompat() {
        String fontName = this.getFontsSerif().split(FONT_SEPARATOR)[0];
        float fontSize = this.getFontSize();
        super.setFont(new Font(fontName, 0, (int)fontSize));
    }

    public String getContent() {
        return MathMLSerializer.serializeDocument(this.getDocument(), false, false);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getFontsDoublestruck() {
        return this.parameters.get((Object)ParameterKey.FontsDoublestruck);
    }

    public String getFontsFraktur() {
        return this.parameters.get((Object)ParameterKey.FontsFraktur);
    }

    public float getFontSize() {
        return Float.parseFloat(this.parameters.get((Object)ParameterKey.FontSize));
    }

    public String getFontsMonospaced() {
        return this.parameters.get((Object)ParameterKey.FontsMonospaced);
    }

    public String getFontsSanserif() {
        return this.parameters.get((Object)ParameterKey.FontsSanserif);
    }

    public String getFontsScript() {
        return this.parameters.get((Object)ParameterKey.FontsScript);
    }

    public String getFontsSerif() {
        return this.parameters.get((Object)ParameterKey.FontsSerif);
    }

    @Override
    public Color getForeground() {
        return AttributesHelper.stringToColor(this.parameters.get((Object)ParameterKey.ForegroundColor), Color.BLACK);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public MathComponentUI getUI() {
        return (MathComponentUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    private void reval() {
        this.repaint();
        this.revalidate();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.reval();
    }

    public void setContent(String contentString) {
        try {
            this.setDocument(MathMLParserSupport.parseString(contentString));
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDebug(boolean dbg) {
        this.parameterChange(ParameterKey.DebugMode, Boolean.toString(dbg));
    }

    public void setDocument(Document doc) {
        Document oldValue = this.document;
        this.firePropertyChange("document", oldValue, doc);
        this.document = doc;
        if (doc != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    @Deprecated
    public void setFont(Font f) {
        super.setFont(f);
        this.setFontSize(f.getSize2D());
        this.setFontsSerif(f.getFamily() + FONT_SEPARATOR + this.getFontsSerif());
    }

    public void setFontsDoublestruck(String newFonts) {
        this.parameterChange(ParameterKey.FontsDoublestruck, newFonts);
    }

    public void setFontsFraktur(String newFonts) {
        this.parameterChange(ParameterKey.FontsFraktur, newFonts);
    }

    private void parameterChange(ParameterKey key, String newValue) {
        String oldValue = this.parameters.get((Object)key);
        this.parameters.put(key, newValue);
        this.firePropertyChange(key.name(), oldValue, this.parameters.get((Object)key));
        this.revalidate();
        this.repaint();
    }

    public void setFontSize(float fontSize) {
        this.parameterChange(ParameterKey.FontSize, Float.toString(fontSize));
    }

    public void setFontsMonospaced(String newFonts) {
        this.parameterChange(ParameterKey.FontsMonospaced, newFonts);
    }

    public void setFontsSanserif(String newFonts) {
        this.parameterChange(ParameterKey.FontsSanserif, newFonts);
    }

    public void setFontsScript(String newFonts) {
        this.parameterChange(ParameterKey.FontsScript, newFonts);
    }

    public void setFontsSerif(String newFonts) {
        this.parameterChange(ParameterKey.FontsSerif, newFonts);
        this.fontCompat();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.parameterChange(ParameterKey.ForegroundColor, "" + fg.getRGB());
    }

    public void setHorizontalAlignment(int hAlignment) {
        this.horizontalAlignment = hAlignment;
    }

    @Override
    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        this.reval();
    }

    public final void setParameter(ParameterKey key, String value) {
        this.parameterChange(key, value);
    }

    public void setVerticalAlignment(int vAlignment) {
        this.verticalAlignment = vAlignment;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(new MathComponentUI());
        }
    }

    public Map<ParameterKey, String> getParameters() {
        return this.parameters;
    }
}

