/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.List;
import net.sourceforge.jeuclid.Defense;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.dom.ChangeTrackingInterface;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import org.w3c.dom.mathml.MathMLOperatorElement;
import org.w3c.dom.mathml.MathMLUnderOverElement;

public class Mo
extends AbstractJEuclidElement
implements MathMLOperatorElement {
    public static final String ATTR_FORM = "form";
    public static final String ATTR_SEPARATOR = "separator";
    public static final String ATTR_LSPACE = "lspace";
    public static final String ATTR_RSPACE = "rspace";
    public static final String ATTR_MINSIZE = "minsize";
    public static final String ATTR_MAXSIZE = "maxsize";
    public static final String ATTR_MOVEABLEWRONG = "moveablelimits";
    public static final String ATTR_MOVABLELIMITS = "movablelimits";
    public static final String ATTR_ACCENT = "accent";
    public static final String ELEMENT = "mo";
    public static final float LARGEOP_CORRECTOR_INLINE = 1.2f;
    public static final float LARGEOP_CORRECTOR_BLOCK = 1.5f;
    public static final String ATTR_STRETCHY = "stretchy";
    public static final String ATTR_LARGEOP = "largeop";
    public static final String ATTR_SYMMETRIC = "symmetric";
    public static final String ATTR_FENCE = "fence";
    public static final String HOR_DELIMITERS = "_\u00af\u0332\u0333\u033f\u2190\u2192\u2194\u23b4\u23b5\ufe35\ufe36\ufe37\ufe38";
    public static final String VER_DELIMITERS = "[{()}]|\u2223\u2225\u2329\u232a";
    private float calcScaleX = 1.0f;
    private float calcScaleY = 1.0f;
    private float calcBaselineShift;

    public Mo(MathBase base) {
        super(base);
        this.setDefaultMathAttribute(ATTR_FORM, "infix");
        this.setDefaultMathAttribute(ATTR_FENCE, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_SEPARATOR, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_LSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_RSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_STRETCHY, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_SYMMETRIC, MathBase.TRUE);
        this.setDefaultMathAttribute(ATTR_MAXSIZE, "9999999pt");
        this.setDefaultMathAttribute(ATTR_MINSIZE, "1");
        this.setDefaultMathAttribute(ATTR_LARGEOP, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_MOVABLELIMITS, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_ACCENT, MathBase.FALSE);
    }

    private float getLspaceAsFloat() {
        return AttributesHelper.convertSizeToPt(this.getLspace(), this, "pt");
    }

    public float getLargeOpCorrector() {
        if (this.isChildBlock(null)) {
            return 1.5f;
        }
        return 1.2f;
    }

    private float getRspaceAsFloat() {
        return AttributesHelper.convertSizeToPt(this.getRspace(), this, "pt");
    }

    private boolean isFence() {
        return Boolean.parseBoolean(this.getFence());
    }

    public void setMaxsize(String maxsize) {
        this.setAttribute(ATTR_MAXSIZE, maxsize);
    }

    public String getMaxsize() {
        return this.getMathAttribute(ATTR_MAXSIZE);
    }

    public void setMinsize(String minsize) {
        this.setAttribute(ATTR_MINSIZE, minsize);
    }

    public String getMinsize() {
        return this.getMathAttribute(ATTR_MINSIZE);
    }

    private boolean isVerticalDelimeter() {
        return this.getText().length() == 1 && (VER_DELIMITERS.indexOf(this.getText().charAt(0)) >= 0 || this.isFence());
    }

    private boolean isHorizontalDelimeter() {
        return this.getText().length() == 1 && HOR_DELIMITERS.indexOf(this.getText().charAt(0)) >= 0;
    }

    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        this.calculateSpecs(g);
        if (this.getText().length() > 0) {
            TextLayout theLayout = this.produceUnstrechtedLayout(g);
            AffineTransform saveAt = g.getTransform();
            g.translate(this.getLspaceAsFloat() + posX, posY + this.calcBaselineShift);
            g.transform(AffineTransform.getScaleInstance(this.calcScaleX, this.calcScaleY));
            theLayout.draw(g, 0.0f, 0.0f);
            g.setTransform(saveAt);
        }
    }

    private TextLayout produceUnstrechtedLayout(Graphics2D g) {
        Defense.notNull(g, "g");
        float fontSizeInPoint = this.getFontsizeInPoint();
        if (Boolean.parseBoolean(this.getLargeop())) {
            fontSizeInPoint *= this.getLargeOpCorrector();
        }
        String theText = this.getText();
        AttributedString aString = StringUtil.convertStringtoAttributedString(theText, this.getMathvariantAsVariant(), fontSizeInPoint, this.getMathBase());
        TextLayout theLayout = StringUtil.createTextLayoutFromAttributedString(g, aString, this.getMathBase());
        return theLayout;
    }

    private void calculateSpecs(Graphics2D g) {
        if (Boolean.parseBoolean(this.getStretchy())) {
            Rectangle2D textBounds = this.produceUnstrechtedLayout(g).getBounds();
            this.calculateVerticalStretchAndBaseline(g, textBounds);
            this.calculateHorizontalStrech(g, textBounds);
        } else {
            this.calcScaleX = 1.0f;
            this.calcScaleY = 1.0f;
            this.calcBaselineShift = 0.0f;
        }
    }

    private void calculateHorizontalStrech(Graphics2D g, Rectangle2D textBounds) {
        JEuclidElement parent = this.getParent();
        if (this.isHorizontalDelimeter() && parent instanceof MathMLUnderOverElement) {
            float realwidth = (float)(textBounds.getWidth() + textBounds.getX());
            MathMLUnderOverElement muo = (MathMLUnderOverElement)((Object)parent);
            JEuclidElement base = (JEuclidElement)muo.getBase();
            parent.setCalculatingSize(true);
            float targetwidth = base.getWidth(g);
            parent.setCalculatingSize(false);
            this.calcScaleX = realwidth > 0.0f ? targetwidth / realwidth : 1.0f;
        } else {
            this.calcScaleX = 1.0f;
        }
    }

    private void calculateVerticalStretchAndBaseline(Graphics2D g, Rectangle2D textBounds) {
        if (this.isVerticalDelimeter()) {
            JEuclidElement parent = this.getParent();
            parent.setCalculatingSize(true);
            List<JEuclidElement> parentsChildren = ElementListSupport.createListOfChildren(parent);
            float ascent = ElementListSupport.getAscentHeight(g, parentsChildren);
            float descent = ElementListSupport.getDescentHeight(g, parentsChildren);
            parent.setCalculatingSize(false);
            float realheight = (float)textBounds.getHeight();
            float targetheight = Math.max(realheight, ascent + descent);
            this.calcScaleY = realheight > 0.0f ? targetheight / realheight : 1.0f;
            float realDescent = (float)((textBounds.getY() + textBounds.getHeight()) * (double)this.calcScaleY);
            this.calcBaselineShift = descent - realDescent;
        } else {
            this.calcScaleY = 1.0f;
            this.calcBaselineShift = 0.0f;
        }
    }

    public float calculateWidth(Graphics2D g) {
        float scaleFactor;
        float space = this.getLspaceAsFloat() + this.getRspaceAsFloat();
        if (this.getText().equals("")) {
            return space;
        }
        if (this.getParent().isCalculatingSize()) {
            scaleFactor = 1.0f;
        } else {
            this.calculateSpecs(g);
            scaleFactor = this.calcScaleX;
        }
        return StringUtil.getWidthForTextLayout(this.produceUnstrechtedLayout(g)) * scaleFactor + space;
    }

    public float getXCenter(Graphics2D g) {
        return (this.getWidth(g) - this.getRspaceAsFloat() + this.getLspaceAsFloat()) / 2.0f;
    }

    public float calculateAscentHeight(Graphics2D g) {
        float scaleFactor;
        if (this.getText().equals("")) {
            return g.getFontMetrics().getAscent();
        }
        if (this.getParent().isCalculatingSize()) {
            scaleFactor = 1.0f;
        } else {
            this.calculateSpecs(g);
            scaleFactor = this.calcScaleY;
        }
        Rectangle2D textBounds = this.produceUnstrechtedLayout(g).getBounds();
        return (float)(-textBounds.getY() * (double)scaleFactor - (double)this.calcBaselineShift);
    }

    private float descentWithoutScaleFactor(Graphics2D g) {
        Rectangle2D textBounds = this.produceUnstrechtedLayout(g).getBounds();
        return (float)(textBounds.getY() + textBounds.getHeight());
    }

    public float calculateDescentHeight(Graphics2D g) {
        float scaleFactor;
        if (this.getText().equals("")) {
            return g.getFontMetrics().getDescent();
        }
        if (this.getParent().isCalculatingSize()) {
            scaleFactor = 1.0f;
        } else {
            this.calculateSpecs(g);
            scaleFactor = this.calcScaleY;
        }
        return this.descentWithoutScaleFactor(g) * scaleFactor + this.calcBaselineShift;
    }

    protected void changeHook() {
        super.changeHook();
        this.detectFormParameter();
        this.loadAttributeFromDictionary(ATTR_LARGEOP, MathBase.FALSE);
        this.loadAttributeFromDictionary(ATTR_SYMMETRIC, MathBase.TRUE);
        this.loadAttributeFromDictionary(ATTR_STRETCHY, MathBase.FALSE);
        this.loadAttributeFromDictionary(ATTR_FENCE, MathBase.FALSE);
        this.loadAttributeFromDictionary(ATTR_LSPACE, "0.277778em");
        this.loadAttributeFromDictionary(ATTR_RSPACE, "0.277778em");
        this.loadAttributeFromDictionary(ATTR_MOVABLELIMITS, MathBase.FALSE);
        JEuclidElement parent = this.getParent();
        if (parent != null) {
            if (parent.hasChildPostscripts(this)) {
                this.setDefaultMathAttribute(ATTR_RSPACE, "0");
            }
            if (parent.hasChildPrescripts(this)) {
                this.setDefaultMathAttribute(ATTR_LSPACE, "0");
            }
            if (parent instanceof ChangeTrackingInterface) {
                parent.addListener(this);
            }
        }
        if (this.isFence()) {
            this.setDefaultMathAttribute(ATTR_STRETCHY, MathBase.TRUE);
        }
    }

    private void loadAttributeFromDictionary(String attrname, String defvalue) {
        String attr;
        try {
            attr = OperatorDictionary.getDefaultAttributeValue(this.getText(), this.getForm(), attrname);
        }
        catch (UnknownAttributeException e) {
            attr = defvalue;
        }
        if (attr.equals("NULL")) {
            attr = defvalue;
        }
        this.setDefaultMathAttribute(attrname, attr);
    }

    private void detectFormParameter() {
        int index;
        JEuclidElement parent = this.getParent();
        String form = parent != null && parent instanceof Mrow ? ((index = parent.getIndexOfMathElement(this)) == 0 && parent.getMathElementCount() > 0 ? "prefix" : (index == parent.getMathElementCount() - 1 && parent.getMathElementCount() > 0 ? "postfix" : "infix")) : "infix";
        this.setDefaultMathAttribute(ATTR_FORM, form);
    }

    public String getTagName() {
        return ELEMENT;
    }

    public String getLargeop() {
        return this.getMathAttribute(ATTR_LARGEOP);
    }

    public String getLspace() {
        return this.getMathAttribute(ATTR_LSPACE);
    }

    public String getMovablelimits() {
        String wrongAttr = this.getMathAttribute(ATTR_MOVEABLEWRONG);
        if (wrongAttr != null) {
            return wrongAttr;
        }
        return this.getMathAttribute(ATTR_MOVABLELIMITS);
    }

    public String getRspace() {
        return this.getMathAttribute(ATTR_RSPACE);
    }

    public void setAccent(String accent) {
        this.setAttribute(ATTR_ACCENT, accent);
    }

    public void setFence(String fence) {
        this.setAttribute(ATTR_FENCE, fence);
    }

    public void setForm(String form) {
        this.setAttribute(ATTR_FORM, form);
    }

    public void setLargeop(String largeop) {
        this.setAttribute(ATTR_LARGEOP, largeop);
    }

    public void setLspace(String lspace) {
        this.setAttribute(ATTR_LSPACE, lspace);
    }

    public void setMovablelimits(String movablelimits) {
        this.setAttribute(ATTR_MOVABLELIMITS, movablelimits);
    }

    public void setRspace(String rspace) {
        this.setAttribute(ATTR_RSPACE, rspace);
    }

    public void setSeparator(String separator) {
        this.setAttribute(ATTR_SEPARATOR, separator);
    }

    public void setStretchy(String stretchy) {
        this.setAttribute(ATTR_STRETCHY, stretchy);
    }

    public void setSymmetric(String symmetric) {
        this.setAttribute(ATTR_SYMMETRIC, symmetric);
    }

    public String getFence() {
        return this.getMathAttribute(ATTR_FENCE);
    }

    public String getForm() {
        return this.getMathAttribute(ATTR_FORM);
    }

    public String getSeparator() {
        return this.getMathAttribute(ATTR_SEPARATOR);
    }

    public String getStretchy() {
        return this.getMathAttribute(ATTR_STRETCHY);
    }

    public String getAccent() {
        return this.getMathAttribute(ATTR_ACCENT);
    }

    public String getSymmetric() {
        return this.getMathAttribute(ATTR_SYMMETRIC);
    }
}

