/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements;

import java.awt.Graphics2D;
import java.util.List;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.AbstractContainer;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementWithDelegates
extends AbstractContainer {
    private List<JEuclidElement> delegates;

    public AbstractElementWithDelegates(MathBase base) {
        super(base);
    }

    protected abstract List<JEuclidElement> createDelegates();

    private void prepareDelegates() {
        this.delegates = this.createDelegates();
        for (JEuclidElement element : this.delegates) {
            element.setFakeParent(this);
        }
    }

    @Override
    public float calculateAscentHeight(Graphics2D g) {
        return ElementListSupport.getAscentHeight(g, this.delegates);
    }

    @Override
    public float calculateDescentHeight(Graphics2D g) {
        return ElementListSupport.getDescentHeight(g, this.delegates);
    }

    @Override
    public float calculateWidth(Graphics2D g) {
        return ElementListSupport.getWidth(g, this.delegates);
    }

    @Override
    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        ElementListSupport.paint(g, posX, posY, this.delegates);
    }

    @Override
    protected void changeHook() {
        super.changeHook();
        this.prepareDelegates();
    }
}

