/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterPlugin;

public class ImageIOConverter
implements ConverterPlugin {
    private final ImageWriter writer;

    ImageIOConverter(ImageWriter iw) {
        this.writer = iw;
    }

    public Dimension convert(MathBase base, OutputStream outStream) throws IOException {
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(outStream);
        this.writer.setOutput(ios);
        BufferedImage image = Converter.getConverter().render(base);
        this.writer.write(image);
        ios.close();
        Graphics2D temp = (Graphics2D)image.getGraphics();
        return new Dimension((int)Math.ceil(base.getWidth(temp)), (int)Math.ceil(base.getWidth(temp)));
    }
}

