/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.util.Stack;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElementFactory;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import net.sourceforge.jeuclid.elements.support.attributes.SAXAttributeMap;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class SAXBuilder
implements ContentHandler {
    private DocumentElement rootElement;
    private final Stack<Node> stack = new Stack();
    private final MathBase mbase = new MathBase(MathBase.getDefaultParameters());

    public DocumentElement getMathRootElement() {
        return this.rootElement;
    }

    public void characters(char[] ch, int start, int length) {
        if (!this.stack.empty()) {
            ((AbstractJEuclidElement)this.stack.peek()).addText(new String(ch, start, length));
        }
    }

    public void endDocument() {
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (!this.stack.empty()) {
            this.stack.pop();
        }
    }

    public void startDocument() {
        this.rootElement = null;
        this.stack.clear();
        this.rootElement = new DocumentElement(this.mbase);
        this.mbase.setRootElement(this.rootElement);
        this.stack.push(this.rootElement);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (this.stack.empty()) {
            return;
        }
        SAXAttributeMap aMap = new SAXAttributeMap(attributes);
        MathMLElement element = JEuclidElementFactory.elementFromName(localName, aMap, this.mbase);
        if (!this.stack.empty()) {
            this.stack.peek().appendChild(element);
        }
        this.stack.push(element);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }
}

