/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import javolution.xml.sax.AttributeEntry;
import javolution.xml.sax.Attributes;
import javolution.xml.sax.CharSequenceImpl;

final class AttributesImpl
implements Attributes {
    int _length;
    AttributeEntry[] _entries = new AttributeEntry[0];

    public AttributesImpl() {
        this.ensureCapacity(64);
    }

    public int getLength() {
        return this._length;
    }

    public CharSequence getURI(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].uri;
        }
        return null;
    }

    public CharSequence getLocalName(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].localName;
        }
        return null;
    }

    public CharSequence getQName(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].qName;
        }
        return null;
    }

    public String getType(int n) {
        if (n >= 0 && n < this._length) {
            return "CDATA";
        }
        return null;
    }

    public CharSequence getValue(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].value;
        }
        return null;
    }

    public int getIndex(CharSequence charSequence, CharSequence charSequence2) {
        for (int i = 0; i < this._length; ++i) {
            AttributeEntry attributeEntry = this._entries[i];
            if (!attributeEntry.localName.equals(charSequence2) || !attributeEntry.uri.equals(charSequence)) continue;
            return i;
        }
        return -1;
    }

    int getIndex(String string, String string2) {
        for (int i = 0; i < this._length; ++i) {
            AttributeEntry attributeEntry = this._entries[i];
            if (!attributeEntry.localName.equals(string2) || !attributeEntry.uri.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(CharSequence charSequence) {
        for (int i = 0; i < this._length; ++i) {
            if (!this._entries[i].qName.equals(charSequence)) continue;
            return i;
        }
        return -1;
    }

    int getIndex(String string) {
        for (int i = 0; i < this._length; ++i) {
            if (!this._entries[i].qName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getType(CharSequence charSequence, CharSequence charSequence2) {
        return this.getIndex(charSequence, charSequence2) >= 0 ? "CDATA" : null;
    }

    String getType(String string, String string2) {
        return this.getIndex(string, string2) >= 0 ? "CDATA" : null;
    }

    public String getType(CharSequence charSequence) {
        return this.getIndex(charSequence) >= 0 ? "CDATA" : null;
    }

    String getType(String string) {
        return this.getIndex(string) >= 0 ? "CDATA" : null;
    }

    public CharSequence getValue(CharSequence charSequence, CharSequence charSequence2) {
        int n = this.getIndex(charSequence, charSequence2);
        return n >= 0 ? this._entries[n].value : null;
    }

    String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n >= 0 ? this._entries[n].value.toString() : null;
    }

    public CharSequence getValue(CharSequence charSequence) {
        int n = this.getIndex(charSequence);
        return n >= 0 ? this._entries[n].value : null;
    }

    String getValue(String string) {
        int n = this.getIndex(string);
        return n >= 0 ? this._entries[n].value.toString() : null;
    }

    public void add(CharSequenceImpl charSequenceImpl, CharSequenceImpl charSequenceImpl2, CharSequenceImpl charSequenceImpl3, CharSequenceImpl charSequenceImpl4) {
        if (this._length >= this._entries.length) {
            this.ensureCapacity(this._entries.length * 2);
        }
        AttributeEntry attributeEntry = this._entries[this._length++];
        attributeEntry.uri = charSequenceImpl;
        attributeEntry.localName = charSequenceImpl2;
        attributeEntry.qName = charSequenceImpl3;
        attributeEntry.value = charSequenceImpl4;
    }

    void clear() {
        this._length = 0;
    }

    public void ensureCapacity(int n) {
        AttributeEntry[] attributeEntryArray = new AttributeEntry[n];
        System.arraycopy(this._entries, 0, attributeEntryArray, 0, this._entries.length);
        for (int i = this._entries.length; i < attributeEntryArray.length; ++i) {
            attributeEntryArray[i] = new AttributeEntry();
        }
        this._entries = attributeEntryArray;
    }
}

