/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import javolution.lang.Enum;
import javolution.lang.Text;
import javolution.lang.TypeFormat;
import javolution.util.FastList;
import javolution.xml.XmlException;
import javolution.xml.XmlFormat;
import javolution.xml.sax.Attributes;

public final class XmlElement {
    Class _objectClass;
    XmlFormat _format;
    Object _object;
    CharSequence _idValue;
    XmlElement _parent;
    final AttributesImpl _attributes = new AttributesImpl();
    final FastList _content = new FastList();

    XmlElement() {
    }

    public Object object() throws XmlException {
        if (this._object == null) {
            try {
                this._object = this._objectClass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XmlException(this._objectClass + " default constructor inaccessible");
            }
            catch (InstantiationException instantiationException) {
                throw new XmlException(this._objectClass + " default constructor throws an exception");
            }
        }
        return this._object;
    }

    public FastList getContent() {
        return this._content;
    }

    void setAttribute(Object object, CharSequence charSequence) {
        this._attributes.add(object, charSequence);
    }

    public void setAttribute(String string, CharSequence charSequence) {
        this._attributes.add(string, charSequence);
    }

    public void setAttribute(String string, String string2) {
        String string3 = string2;
        if (string3 instanceof CharSequence) {
            this._attributes.add(string, string3);
        } else {
            this._attributes.add(string, Text.valueOf(string2));
        }
    }

    public void setAttribute(String string, boolean bl) {
        this._attributes.add(string, Text.valueOf(bl));
    }

    public void setAttribute(String string, int n) {
        this._attributes.add(string, Text.valueOf(n));
    }

    public void setAttribute(String string, long l) {
        this._attributes.add(string, Text.valueOf(l));
    }

    public void setAttribute(String string, float f) {
        this._attributes.add(string, Text.valueOf(f));
    }

    public void setAttribute(String string, double d) {
        this._attributes.add(string, Text.valueOf(d));
    }

    public void setAttribute(String string, Enum enum_) {
        this.setAttribute(string, enum_.name());
    }

    public Class objectClass() {
        return this._objectClass;
    }

    public XmlElement getParent() {
        return this._parent;
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public boolean isAttribute(String string) {
        return this._attributes.indexOf(string) >= 0;
    }

    public CharSequence getAttribute(String string) {
        int n = this._attributes.indexOf(string);
        return n >= 0 ? this._attributes._values[n] : null;
    }

    public String getAttribute(String string, String string2) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? ((Object)charSequence).toString() : string2;
    }

    public boolean getAttribute(String string, boolean bl) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseBoolean(charSequence) : bl;
    }

    public int getAttribute(String string, int n) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseInt(charSequence) : n;
    }

    public long getAttribute(String string, long l) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseLong(charSequence) : l;
    }

    public float getAttribute(String string, float f) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? (float)TypeFormat.parseDouble(charSequence) : f;
    }

    public double getAttribute(String string, double d) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseDouble(charSequence) : d;
    }

    public Enum getAttribute(String string, Enum enum_) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? Enum.valueOf(enum_.getClass(), ((Object)charSequence).toString()) : enum_;
    }

    void reset() {
        this._object = null;
        this._format = null;
        this._objectClass = null;
        this._idValue = null;
        this._attributes.clear();
        this._content.clear();
    }

    static final class AttributesImpl
    implements Attributes {
        Object[] _names = new Object[16];
        CharSequence[] _values = new CharSequence[16];
        int _length = 0;

        AttributesImpl() {
        }

        public void add(Object object, CharSequence charSequence) {
            if (this._length == this._names.length) {
                Object[] objectArray = new Object[this._length * 2];
                System.arraycopy(this._names, 0, objectArray, 0, this._length);
                this._names = objectArray;
                CharSequence[] charSequenceArray = new CharSequence[this._length * 2];
                System.arraycopy(this._values, 0, charSequenceArray, 0, this._length);
                this._values = charSequenceArray;
            }
            this._names[this._length] = object;
            this._values[this._length++] = charSequence;
        }

        public void clear() {
            int n = this._length;
            while (n > 0) {
                this._names[--n] = null;
                this._values[n] = null;
            }
            this._length = 0;
        }

        public int indexOf(Object object) {
            int n = this._length;
            while (n > 0) {
                if (!object.equals(this._names[--n]) && !this._names[n].equals(object)) continue;
                return n;
            }
            return -1;
        }

        public int getLength() {
            return this._length;
        }

        public CharSequence getURI(int n) {
            return n >= 0 && n < this._length ? Text.EMPTY : null;
        }

        public CharSequence getLocalName(int n) {
            return this.getQName(n);
        }

        public CharSequence getQName(int n) {
            if (n >= 0 && n < this._length) {
                Object object = this._names[n];
                return object instanceof CharSequence ? (CharSequence)object : Text.valueOf(object);
            }
            return null;
        }

        public String getType(int n) {
            return n >= 0 && n < this._length ? "CDATA" : null;
        }

        public CharSequence getValue(int n) {
            return n >= 0 && n < this._length ? this._values[n] : null;
        }

        public int getIndex(CharSequence charSequence, CharSequence charSequence2) {
            return charSequence.length() == 0 ? this.getIndex(charSequence2) : -1;
        }

        public int getIndex(CharSequence charSequence) {
            return this.indexOf(charSequence);
        }

        public String getType(CharSequence charSequence, CharSequence charSequence2) {
            return this.getIndex(charSequence, charSequence2) >= 0 ? "CDATA" : null;
        }

        public String getType(CharSequence charSequence) {
            return this.getIndex(charSequence) >= 0 ? "CDATA" : null;
        }

        public CharSequence getValue(CharSequence charSequence, CharSequence charSequence2) {
            int n = this.getIndex(charSequence, charSequence2);
            return n >= 0 ? this._values[n] : null;
        }

        public CharSequence getValue(CharSequence charSequence) {
            int n = this.getIndex(charSequence);
            return n >= 0 ? this._values[n] : null;
        }
    }
}

