/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javolution.io.Utf8ByteBufferWriter;
import javolution.io.Utf8StreamWriter;
import javolution.lang.Reusable;
import javolution.lang.Text;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.CharacterData;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import javolution.xml.sax.ContentHandler;
import javolution.xml.sax.WriterHandler;
import org.xml.sax.SAXException;

public class ObjectWriter
implements Reusable {
    private int _idCount;
    private final FastMap _objectToId = new FastMap().setKeyComparator(FastMap.IDENTITY);
    private FastList _namespaces = new FastList();
    private final FastMap _classInfo = new FastMap();
    private final XmlElement[] _stack = new XmlElement[64];
    private final Utf8StreamWriter _utf8StreamWriter = new Utf8StreamWriter();
    private final Utf8ByteBufferWriter _utf8ByteBufferWriter = new Utf8ByteBufferWriter();
    private final WriterHandler _writerHandler = new WriterHandler();
    private static final Text JAVA = Text.valueOf("java:").intern();
    private static final Text SEMICOLON = Text.valueOf(':').intern();

    public ObjectWriter() {
        this._stack[0] = new XmlElement();
        for (int i = 1; i < this._stack.length; ++i) {
            this._stack[i] = new XmlElement();
            this._stack[i]._parent = this._stack[i - 1];
        }
    }

    public void setNamespace(String string, String string2) {
        if (string.length() == 0) {
            this.setNamespace("root", "");
        }
        this._namespaces.add(string);
        this._namespaces.add(string2);
    }

    public void reset() {
        this._objectToId.clear();
        this._namespaces.clear();
        this._idCount = 0;
        Iterator iterator = this._classInfo.fastValuesIterator();
        while (iterator.hasNext()) {
            ((ClassInfo)iterator.next()).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object, Writer writer) throws IOException {
        try {
            this._writerHandler.setWriter(writer);
            this.write(object, this._writerHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof IOException) {
                throw (IOException)sAXException.getException();
            }
        }
        finally {
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object, OutputStream outputStream) throws IOException {
        try {
            this._utf8StreamWriter.setOutputStream(outputStream);
            this._writerHandler.setWriter(this._utf8StreamWriter);
            this.write(object, this._writerHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof IOException) {
                throw (IOException)sAXException.getException();
            }
        }
        finally {
            this._utf8StreamWriter.reset();
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object, ByteBuffer byteBuffer) throws IOException {
        try {
            this._utf8ByteBufferWriter.setByteBuffer(byteBuffer);
            this._writerHandler.setWriter(this._utf8ByteBufferWriter);
            this.write(object, this._writerHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof IOException) {
                throw (IOException)sAXException.getException();
            }
        }
        finally {
            this._utf8ByteBufferWriter.reset();
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object, ContentHandler contentHandler) throws SAXException {
        Object e;
        Object e2;
        Iterator iterator;
        contentHandler.startDocument();
        try {
            iterator = this._namespaces.fastIterator();
            while (iterator.hasNext()) {
                e2 = iterator.next();
                e = iterator.next();
                if (e2 instanceof CharSequence) {
                    contentHandler.startPrefixMapping((CharSequence)e2, JAVA.concat((CharSequence)e));
                    continue;
                }
                contentHandler.startPrefixMapping(Text.valueOf(e2), JAVA.plus(Text.valueOf(e)));
            }
            this.writeElement(object, contentHandler, 0);
        }
        finally {
            iterator = this._namespaces.fastIterator();
            while (iterator.hasNext()) {
                e2 = iterator.next();
                e = iterator.next();
                if (e2 instanceof CharSequence) {
                    contentHandler.endPrefixMapping((CharSequence)e2);
                    continue;
                }
                contentHandler.endPrefixMapping(Text.valueOf(e2));
            }
            contentHandler.endDocument();
        }
    }

    private void writeElement(Object object, ContentHandler contentHandler, int n) throws SAXException {
        Object object2;
        Object object3;
        if (object == null) {
            this.writeElement(XmlFormat.NULL, contentHandler, n);
            return;
        }
        if (object instanceof CharacterData) {
            CharacterData characterData = (CharacterData)object;
            contentHandler.characters(characterData._chars, 0, characterData._length);
            return;
        }
        Class<?> clazz = object.getClass();
        ClassInfo classInfo = (ClassInfo)this._classInfo.get(clazz);
        if (classInfo == null) {
            classInfo = new ClassInfo();
            this._classInfo.put(clazz, classInfo);
        }
        if (classInfo.format == null) {
            classInfo.format = XmlFormat.getInstance(clazz);
            classInfo.formatId = classInfo.format.identifier(false);
            object3 = XmlFormat.nameFor(clazz);
            int n2 = -1;
            object2 = this._namespaces.fastIterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                String string2 = (String)object2.next();
                int n3 = string2.length();
                if (!((String)object3).startsWith(string2) || n3 <= n2) continue;
                classInfo.uri = JAVA.plus(Text.valueOf(string2));
                classInfo.localName = n3 > 0 ? Text.valueOf((String)object3).subtext(n3 + 1) : Text.valueOf((String)object3);
                classInfo.qName = string.length() > 0 ? Text.valueOf(string).plus(SEMICOLON).plus(classInfo.localName) : classInfo.localName;
                n2 = n3;
            }
            if (n2 < 0) {
                classInfo.uri = Text.EMPTY;
                classInfo.qName = classInfo.localName = Text.valueOf((String)object3);
            }
        }
        object3 = this._stack[n];
        ((XmlElement)object3)._objectClass = clazz;
        if (classInfo.formatId != null) {
            Text text = (Text)this._objectToId.get(object);
            if (text != null) {
                ((XmlElement)object3).setAttribute(classInfo.format.identifier(true), (CharSequence)text);
            } else {
                classInfo.format.format(object, (XmlElement)object3);
                object2 = ((XmlElement)object3).getAttribute(classInfo.formatId);
                text = object2 == null ? Text.valueOf(++this._idCount) : Text.valueOf(object2);
                this._objectToId.put(object, text);
                ((XmlElement)object3).setAttribute(classInfo.formatId, (CharSequence)text);
            }
        } else {
            classInfo.format.format(object, (XmlElement)object3);
        }
        contentHandler.startElement(classInfo.uri, classInfo.localName, classInfo.qName, ((XmlElement)object3).getAttributes());
        Iterator iterator = ((XmlElement)object3)._content.fastIterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            this.writeElement(object2, contentHandler, n + 1);
        }
        contentHandler.endElement(classInfo.uri, classInfo.localName, classInfo.qName);
        ((XmlElement)object3).reset();
    }

    private static final class ClassInfo {
        XmlFormat format;
        String formatId;
        Text uri;
        Text qName;
        Text localName;

        private ClassInfo() {
        }

        void reset() {
            this.format = null;
            this.formatId = null;
            this.uri = null;
            this.qName = null;
            this.localName = null;
        }
    }
}

