/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javolution.Configuration;
import javolution.lang.Text;
import javolution.lang.TextBuilder;
import javolution.lang.TypeFormat;
import javolution.realtime.ArrayPool;
import javolution.realtime.Realtime;
import javolution.realtime.RealtimeObject;
import javolution.util.FastCollection;

public class FastMap
extends RealtimeObject
implements Map,
Serializable {
    private transient EntryImpl[] _entries;
    private transient int _capacity;
    private transient EntryImpl _poolFirst;
    private transient EntryImpl _mapFirst;
    private transient int _size;
    private boolean _hasConstantCapacity;
    private KeyComparator _keyComparator;
    private static final FastMapFactory[] FACTORIES = new FastMapFactory[28];
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;
    public static final KeyComparator FAST;
    public static final KeyComparator REHASH;
    public static final KeyComparator IDENTITY;
    public static final KeyComparator LEXICAL;
    private static final KeyComparator DEFAULT;

    public FastMap() {
        this(16);
    }

    public FastMap(int n) {
        this._mapFirst = this._poolFirst = new EntryImpl();
        this._keyComparator = DEFAULT;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this.setCapacity(n);
    }

    public static FastMap newInstance(int n) {
        return (FastMap)FACTORIES[ArrayPool.indexFor(n)].object();
    }

    public FastMap setKeyComparator(KeyComparator keyComparator) {
        this._keyComparator = keyComparator;
        return this;
    }

    public final Iterator fastEntriesIterator() {
        return this._entrySet.fastIterator();
    }

    public final Iterator fastKeysIterator() {
        return this._keySet.fastIterator();
    }

    public final Iterator fastValuesIterator() {
        return this._values.fastIterator();
    }

    public final int size() {
        return this._size;
    }

    public final int capacity() {
        return this._capacity;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final boolean containsKey(Object object) {
        int n = this._keyComparator == FAST ? object.hashCode() : this._keyComparator.keyHash(object);
        EntryImpl entryImpl = this._entries[n & this._entries.length - 1];
        while (entryImpl != null) {
            if (object == entryImpl._key || entryImpl._keyHash == n && this._keyComparator.areEquals(object, entryImpl._key)) {
                return true;
            }
            entryImpl = entryImpl._next;
        }
        return false;
    }

    public final boolean containsValue(Object object) {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != this._poolFirst) {
            if (object.equals(entryImpl._value)) {
                return true;
            }
            entryImpl = entryImpl._after;
        }
        return false;
    }

    public final Object get(Object object) {
        int n = this._keyComparator == FAST ? object.hashCode() : this._keyComparator.keyHash(object);
        EntryImpl entryImpl = this._entries[n & this._entries.length - 1];
        while (entryImpl != null) {
            if (object == entryImpl._key || entryImpl._keyHash == n && this._keyComparator.areEquals(object, entryImpl._key)) {
                return entryImpl._value;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public final Map.Entry getEntry(Object object) {
        int n = this._keyComparator == FAST ? object.hashCode() : this._keyComparator.keyHash(object);
        EntryImpl entryImpl = this._entries[n & this._entries.length - 1];
        while (entryImpl != null) {
            if (entryImpl._keyHash == n && this._keyComparator.areEquals(object, entryImpl._key)) {
                return entryImpl;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public final Object put(Object object, Object object2) {
        int n = this._keyComparator == FAST ? object.hashCode() : this._keyComparator.keyHash(object);
        EntryImpl entryImpl = this._entries[n & this._entries.length - 1];
        while (entryImpl != null) {
            if (object == entryImpl._key || entryImpl._keyHash == n && this._keyComparator.areEquals(object, entryImpl._key)) {
                Object object3 = entryImpl._value;
                entryImpl._value = object2;
                return object3;
            }
            entryImpl = entryImpl._next;
        }
        this.addEntry(n, object, object2);
        return null;
    }

    public final void putAll(Map map) {
        if (map instanceof FastMap) {
            FastMap fastMap = (FastMap)map;
            EntryImpl entryImpl = fastMap._mapFirst;
            while (entryImpl != fastMap._poolFirst) {
                this.put(entryImpl._key, entryImpl._value);
                entryImpl = entryImpl._after;
            }
        } else {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public final Object remove(Object object) {
        int n = this._keyComparator == FAST ? object.hashCode() : this._keyComparator.keyHash(object);
        EntryImpl entryImpl = this._entries[n & this._entries.length - 1];
        while (entryImpl != null) {
            if (object == entryImpl._key || entryImpl._keyHash == n && this._keyComparator.areEquals(object, entryImpl._key)) {
                Object object2 = entryImpl._value;
                this.removeEntry(entryImpl);
                return object2;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public final void clear() {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != this._poolFirst) {
            entryImpl._key = null;
            entryImpl._value = null;
            if (entryImpl._previous == null) {
                this._entries[((EntryImpl)entryImpl)._keyHash & this._entries.length - 1] = null;
            }
            entryImpl = entryImpl._after;
        }
        if (this._size != 0) {
            this._poolFirst = this._mapFirst;
            this._size = 0;
            if (!this._hasConstantCapacity) {
                this.sizeChanged();
            }
        }
    }

    public final void setCapacity(int n) {
        int n2;
        EntryImpl entryImpl;
        int n3;
        EntryImpl entryImpl2;
        if (n > this._capacity) {
            entryImpl2 = this._poolFirst._before;
            for (n3 = this._capacity; n3 < n; ++n3) {
                entryImpl = new EntryImpl();
                entryImpl._after = this._poolFirst;
                this._poolFirst._before = entryImpl;
                this._poolFirst = entryImpl;
            }
            this._capacity = n;
            if (entryImpl2 != null) {
                entryImpl2._after = this._poolFirst;
                this._poolFirst._before = entryImpl2;
            } else {
                this._mapFirst = this._poolFirst;
            }
        } else if (n < this._capacity) {
            entryImpl2 = this._poolFirst;
            while (entryImpl2 != null) {
                entryImpl2._previous = null;
                entryImpl2._next = null;
                entryImpl2 = entryImpl2._after;
            }
            entryImpl2 = this._poolFirst._before;
            for (n3 = n; n3 < this._capacity && (entryImpl = this._poolFirst._after) != null; ++n3) {
                this._poolFirst._after = null;
                this._poolFirst._before = null;
                this._poolFirst = entryImpl;
                --this._capacity;
            }
            this._poolFirst._before = entryImpl2;
            if (entryImpl2 != null) {
                entryImpl2._after = this._poolFirst;
            } else {
                this._mapFirst = this._poolFirst;
            }
        }
        for (n2 = 16; n2 < this._capacity; n2 <<= 1) {
        }
        if (this._entries == null || this._entries.length != n2) {
            this._entries = new EntryImpl[n2];
            EntryImpl entryImpl3 = this._mapFirst;
            while (entryImpl3 != this._poolFirst) {
                int n4 = entryImpl3._keyHash & n2 - 1;
                EntryImpl entryImpl4 = this._entries[n4];
                this._entries[n4] = entryImpl3;
                entryImpl3._previous = null;
                entryImpl3._next = entryImpl4;
                if (entryImpl4 != null) {
                    entryImpl4._previous = entryImpl3;
                }
                entryImpl3 = entryImpl3._after;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() == map.size()) {
                EntryImpl entryImpl = this._mapFirst;
                while (entryImpl != this._poolFirst) {
                    if (!map.entrySet().contains(entryImpl)) {
                        return false;
                    }
                    entryImpl = entryImpl._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != this._poolFirst) {
            n += entryImpl.hashCode();
            entryImpl = entryImpl._after;
        }
        return n;
    }

    public Text toText() {
        return this._entrySet.toText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream printStream) {
        Object object;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this._entries.length; ++i) {
            object = this._entries[i];
            int n3 = 0;
            while (object != null) {
                if (++n3 > n) {
                    n = n3;
                }
                if (n3 > 1) {
                    ++n2;
                }
                object = ((EntryImpl)object)._next;
            }
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(100 * n2 / this.size());
        textBuilder.append('%');
        object = printStream;
        synchronized (object) {
            printStream.print("SIZE: " + this.size());
            printStream.print(", CAPACITY: " + this.capacity());
            printStream.print(", AVG COLLISIONS: " + textBuilder);
            printStream.print(", MAX SLOT OCCUPANCY: " + n);
            printStream.print(", KEY COMPARATOR: " + this._keyComparator);
            printStream.println();
        }
    }

    public final Collection values() {
        return this._values;
    }

    public final Set entrySet() {
        return this._entrySet;
    }

    public final Set keySet() {
        return this._keySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private void addEntry(int n, Object object, Object object2) {
        EntryImpl entryImpl = this._poolFirst;
        entryImpl._keyHash = n;
        entryImpl._key = object;
        entryImpl._value = object2;
        int n2 = n & this._entries.length - 1;
        EntryImpl entryImpl2 = this._entries[n2];
        entryImpl._next = entryImpl2;
        if (entryImpl2 != null) {
            entryImpl2._previous = entryImpl;
        }
        entryImpl._previous = null;
        this._entries[n2] = entryImpl;
        this._poolFirst = this._poolFirst._after;
        if (this._poolFirst == null) {
            this._poolFirst = new EntryImpl();
            this._poolFirst._before = entryImpl;
            entryImpl._after = this._poolFirst;
            ++this._capacity;
        }
        ++this._size;
        if (!this._hasConstantCapacity) {
            this.sizeChanged();
        }
    }

    private void removeEntry(EntryImpl entryImpl) {
        entryImpl._key = null;
        entryImpl._value = null;
        EntryImpl entryImpl2 = entryImpl._previous;
        EntryImpl entryImpl3 = entryImpl._next;
        if (entryImpl2 != null) {
            entryImpl2._next = entryImpl3;
        } else {
            this._entries[((EntryImpl)entryImpl)._keyHash & this._entries.length - 1] = entryImpl3;
        }
        if (entryImpl3 != null) {
            entryImpl3._previous = entryImpl2;
        }
        if (entryImpl._after == this._poolFirst) {
            this._poolFirst = entryImpl;
        } else {
            EntryImpl entryImpl4 = entryImpl._before;
            EntryImpl entryImpl5 = entryImpl._after;
            if (entryImpl4 != null) {
                entryImpl4._after = entryImpl5;
            } else {
                this._mapFirst = entryImpl5;
            }
            entryImpl5._before = entryImpl4;
            EntryImpl entryImpl6 = this._poolFirst._before;
            entryImpl._after = this._poolFirst;
            entryImpl._before = entryImpl6;
            this._poolFirst._before = entryImpl;
            entryImpl6._after = entryImpl;
            this._poolFirst = entryImpl;
        }
        --this._size;
        if (!this._hasConstantCapacity) {
            this.sizeChanged();
        }
    }

    public void move(Realtime.ContextSpace contextSpace) {
        super.move(contextSpace);
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != this._poolFirst) {
            if (entryImpl._key instanceof Realtime) {
                ((Realtime)entryImpl._key).move(contextSpace);
            }
            if (entryImpl._value instanceof Realtime) {
                ((Realtime)entryImpl._value).move(contextSpace);
            }
            entryImpl = entryImpl._after;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (Configuration.isPoorSystemHash() && this._keyComparator instanceof Fast) {
            this._keyComparator = REHASH;
        }
        this._mapFirst = this._poolFirst = new EntryImpl();
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        int n = objectInputStream.readInt();
        this.setCapacity(n);
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.addEntry(this._keyComparator.keyHash(object), object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._capacity);
        objectOutputStream.writeInt(this._size);
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != this._poolFirst) {
            objectOutputStream.writeObject(entryImpl._key);
            objectOutputStream.writeObject(entryImpl._value);
            entryImpl = entryImpl._after;
        }
    }

    static {
        int n = FACTORIES.length;
        while (n > 0) {
            FastMap.FACTORIES[--n] = new FastMapFactory(16 << n);
        }
        FAST = new Fast();
        REHASH = new Rehash();
        IDENTITY = new Identity();
        LEXICAL = new Lexical();
        DEFAULT = Configuration.isPoorSystemHash() ? REHASH : FAST;
    }

    public static abstract class KeyComparator
    implements Serializable {
        public abstract int keyHash(Object var1);

        public abstract boolean areEquals(Object var1, Object var2);
    }

    private static class Lexical
    extends KeyComparator {
        private Lexical() {
        }

        public int keyHash(Object object) {
            if (object instanceof String) {
                return object.hashCode();
            }
            CharSequence charSequence = (CharSequence)object;
            int n = 0;
            int n2 = charSequence.length();
            int n3 = 0;
            while (n3 < n2) {
                n = 31 * n + charSequence.charAt(n3++);
            }
            return n;
        }

        public boolean areEquals(Object object, Object object2) {
            return TypeFormat.LEXICAL_COMPARATOR.compare(object, object2) == 0;
        }

        public String toString() {
            return "LEXICAL";
        }
    }

    private static class Identity
    extends KeyComparator {
        private boolean _rehash = !Configuration.isPoorSystemHash();

        private Identity() {
        }

        public int keyHash(Object object) {
            int n = System.identityHashCode(object);
            if (this._rehash) {
                n += ~(n << 9);
                n ^= n >>> 14;
                n += n << 4;
                return n ^ n >>> 10;
            }
            return n;
        }

        public boolean areEquals(Object object, Object object2) {
            return object == object2;
        }

        public String toString() {
            return "IDENTITY";
        }
    }

    private static class Rehash
    extends KeyComparator {
        private Rehash() {
        }

        public int keyHash(Object object) {
            int n = object.hashCode();
            n += ~(n << 9);
            n ^= n >>> 14;
            n += n << 4;
            return n ^ n >>> 10;
        }

        public boolean areEquals(Object object, Object object2) {
            return object.equals(object2);
        }

        public String toString() {
            return "REHASH";
        }
    }

    private static class Fast
    extends KeyComparator {
        private Fast() {
        }

        public int keyHash(Object object) {
            return object.hashCode();
        }

        public boolean areEquals(Object object, Object object2) {
            return object.equals(object2);
        }

        public String toString() {
            return "FAST";
        }
    }

    private final class EntryImpl
    implements Map.Entry {
        private Object _key;
        private Object _value;
        private int _keyHash;
        private EntryImpl _previous;
        private EntryImpl _next;
        private EntryImpl _before;
        private EntryImpl _after;

        private EntryImpl() {
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object object) {
            Object object2 = this._value;
            this._value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return FastMap.this._keyComparator.areEquals(this._key, entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        public int hashCode() {
            return this._keyHash ^ (this._value != null ? this._value.hashCode() : 0);
        }
    }

    private static final class KeyIterator
    extends RealtimeObject
    implements Iterator {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new KeyIterator();
            }

            public void cleanup(Object object) {
                KeyIterator keyIterator = (KeyIterator)object;
                keyIterator.map = null;
                keyIterator.after = null;
                keyIterator.end = null;
            }
        };
        FastMap map;
        EntryImpl after;
        EntryImpl end;

        private KeyIterator() {
        }

        public void remove() {
            if (this.after._before == null) {
                throw new IllegalStateException();
            }
            this.map.removeEntry(this.after._before);
        }

        public boolean hasNext() {
            return this.after != this.end;
        }

        public Object next() {
            if (this.after == this.end) {
                throw new NoSuchElementException();
            }
            EntryImpl entryImpl = this.after;
            this.after = entryImpl._after;
            return entryImpl._key;
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private final KeyIterator _fastIterator = new KeyIterator();

        private KeySet() {
        }

        public final Iterator fastIterator() {
            this._fastIterator.map = FastMap.this;
            this._fastIterator.after = FastMap.this._mapFirst;
            this._fastIterator.end = FastMap.this._poolFirst;
            return this._fastIterator;
        }

        public Iterator iterator() {
            KeyIterator keyIterator = (KeyIterator)KeyIterator.FACTORY.object();
            keyIterator.map = FastMap.this;
            keyIterator.after = FastMap.this._mapFirst;
            keyIterator.end = FastMap.this._poolFirst;
            return keyIterator;
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }
    }

    private static final class EntryIterator
    extends RealtimeObject
    implements Iterator {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new EntryIterator();
            }

            public void cleanup(Object object) {
                EntryIterator entryIterator = (EntryIterator)object;
                entryIterator.map = null;
                entryIterator.after = null;
                entryIterator.end = null;
            }
        };
        FastMap map;
        EntryImpl after;
        EntryImpl end;

        private EntryIterator() {
        }

        public void remove() {
            if (this.after._before == null) {
                throw new IllegalStateException();
            }
            this.map.removeEntry(this.after._before);
        }

        public boolean hasNext() {
            return this.after != this.end;
        }

        public Object next() {
            if (this.after == this.end) {
                throw new NoSuchElementException();
            }
            EntryImpl entryImpl = this.after;
            this.after = entryImpl._after;
            return entryImpl;
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private final EntryIterator _fastIterator = new EntryIterator();

        private EntrySet() {
        }

        public final Iterator fastIterator() {
            this._fastIterator.map = FastMap.this;
            this._fastIterator.after = FastMap.this._mapFirst;
            this._fastIterator.end = FastMap.this._poolFirst;
            return this._fastIterator;
        }

        public Iterator iterator() {
            EntryIterator entryIterator = (EntryIterator)EntryIterator.FACTORY.object();
            entryIterator.map = FastMap.this;
            entryIterator.after = FastMap.this._mapFirst;
            entryIterator.end = FastMap.this._poolFirst;
            return entryIterator;
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = FastMap.this.getEntry(entry.getKey());
                return ((Object)entry).equals(entry2);
            }
            return false;
        }

        public boolean remove(Object object) {
            Map.Entry entry;
            EntryImpl entryImpl;
            if (object instanceof Map.Entry && (entryImpl = (EntryImpl)FastMap.this.getEntry((entry = (Map.Entry)object).getKey())) != null && entry.getValue().equals(entryImpl._value)) {
                FastMap.this.removeEntry(entryImpl);
                return true;
            }
            return false;
        }

        public Text toText() {
            TextBuilder textBuilder = TextBuilder.newInstance();
            textBuilder.append("[");
            Iterator iterator = this.iterator();
            int n = this.size();
            while (n > 0) {
                EntryImpl entryImpl = (EntryImpl)iterator.next();
                textBuilder.append(entryImpl._key);
                textBuilder.append('=');
                textBuilder.append(entryImpl._value);
                if (--n == 0) continue;
                textBuilder.append(", ");
            }
            textBuilder.append("]");
            return textBuilder.toText();
        }
    }

    private static final class ValueIterator
    extends RealtimeObject
    implements Iterator {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new ValueIterator();
            }

            public void cleanup(Object object) {
                ValueIterator valueIterator = (ValueIterator)object;
                valueIterator.map = null;
                valueIterator.after = null;
                valueIterator.end = null;
            }
        };
        FastMap map;
        EntryImpl after;
        EntryImpl end;

        private ValueIterator() {
        }

        public void remove() {
            if (this.after._before == null) {
                throw new IllegalStateException();
            }
            this.map.removeEntry(this.after._before);
        }

        public boolean hasNext() {
            return this.after != this.end;
        }

        public Object next() {
            if (this.after == this.end) {
                throw new NoSuchElementException();
            }
            EntryImpl entryImpl = this.after;
            this.after = entryImpl._after;
            return entryImpl._value;
        }
    }

    private final class Values
    extends FastCollection {
        private final ValueIterator _fastIterator = new ValueIterator();

        private Values() {
        }

        public final Iterator fastIterator() {
            this._fastIterator.map = FastMap.this;
            this._fastIterator.after = FastMap.this._mapFirst;
            this._fastIterator.end = FastMap.this._poolFirst;
            return this._fastIterator;
        }

        public Iterator iterator() {
            ValueIterator valueIterator = (ValueIterator)ValueIterator.FACTORY.object();
            valueIterator.map = FastMap.this;
            valueIterator.after = FastMap.this._mapFirst;
            valueIterator.end = FastMap.this._poolFirst;
            return valueIterator;
        }

        public int size() {
            return FastMap.this._size;
        }

        public boolean contains(Object object) {
            return FastMap.this.containsValue(object);
        }

        public void clear() {
            FastMap.this.clear();
        }
    }

    private static final class FastMapFactory
    extends RealtimeObject.Factory {
        private final int _capacity;

        private FastMapFactory(int n) {
            this._capacity = n;
        }

        public Object create() {
            FastMap fastMap = new FastMap(this._capacity);
            fastMap._hasConstantCapacity = true;
            return fastMap;
        }

        public void cleanup(Object object) {
            FastMap fastMap = (FastMap)object;
            fastMap._keyComparator = DEFAULT;
            fastMap.clear();
        }
    }
}

