/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import java.io.IOException;
import javolution.JavolutionError;
import javolution.lang.Appendable;
import javolution.lang.Text;
import javolution.lang.TextBuilder;
import javolution.lang.TypeFormat;
import javolution.realtime.ObjectFactory;
import javolution.realtime.ObjectPool;
import javolution.realtime.Realtime;

public abstract class RealtimeObject
implements Realtime {
    private transient Pool _pool;
    private transient int _poolIndex;

    protected RealtimeObject() {
    }

    public final String toString() {
        return this.toText().stringValue();
    }

    public Text toText() {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(this.getClass().getName());
        textBuilder.append('@');
        try {
            TypeFormat.format(this.hashCode(), 16, (Appendable)textBuilder);
            return textBuilder.toText();
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final Object export() {
        this.move(Realtime.ContextSpace.OUTER);
        return this;
    }

    public final Object moveHeap() {
        this.move(Realtime.ContextSpace.HEAP);
        return this;
    }

    public final Object preserve(boolean bl) {
        this.move(bl ? Realtime.ContextSpace.SHARED : Realtime.ContextSpace.LOCAL);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Realtime.ContextSpace contextSpace) {
        if (contextSpace == Realtime.ContextSpace.OUTER) {
            if (this._pool != null && this._pool.isLocal()) {
                this._pool.export(this);
            }
        } else if (contextSpace == Realtime.ContextSpace.HEAP) {
            if (this._pool != null) {
                if (this._pool.isLocal()) {
                    this._pool.remove(this);
                } else {
                    Pool pool = this._pool;
                    synchronized (pool) {
                        this._pool.remove(this);
                    }
                }
            }
        } else if (contextSpace == Realtime.ContextSpace.SHARED) {
            if (this._pool != null) {
                if (this._pool.isLocal()) {
                    this._pool.preserve(this);
                } else {
                    Pool pool = this._pool;
                    synchronized (pool) {
                        this._pool.preserve(this);
                    }
                }
            }
        } else if (contextSpace == Realtime.ContextSpace.LOCAL && this._pool != null) {
            if (this._pool.isLocal()) {
                this._pool.unpreserve(this);
            } else {
                Pool pool = this._pool;
                synchronized (pool) {
                    this._pool.unpreserve(this);
                }
            }
        }
    }

    protected void recycle() {
        if (this._pool != null && this._pool.isLocal()) {
            this._pool.recycle(this);
        }
    }

    private static final class Pool
    extends ObjectPool {
        private RealtimeObject[] _objects = new RealtimeObject[32];
        private int _index;
        private int _length;
        private boolean _isCleanupEnabled = true;
        private final Factory _factory;

        public Pool(Factory factory) {
            this._factory = factory;
        }

        public String toString() {
            if (this.getUser() != null) {
                return "LOCAL POOL (Nesting Level: " + this.getNesting() + ", Usage: " + (this._length - this._index) + ", Capacity: " + this._length + ")";
            }
            return "INACTIVE POOL (Usage: " + (this._length - this._index) + ", Capacity: " + this._length + ")";
        }

        private int getNesting() {
            return this.getOuter() != null ? ((Pool)this.getOuter()).getNesting() + 1 : 0;
        }

        public Object next() {
            return this._index > 0 ? this._objects[--this._index] : this.allocate();
        }

        private Object allocate() {
            RealtimeObject realtimeObject = (RealtimeObject)this._factory.create();
            if (this._length >= this._objects.length) {
                RealtimeObject[] realtimeObjectArray = new RealtimeObject[this._length * 2];
                System.arraycopy(this._objects, 0, realtimeObjectArray, 0, this._length);
                this._objects = realtimeObjectArray;
            }
            realtimeObject._pool = this;
            realtimeObject._poolIndex = this._length;
            this._objects[this._length++] = realtimeObject;
            return realtimeObject;
        }

        public void recycle(Object object) {
            RealtimeObject realtimeObject = (RealtimeObject)object;
            if (realtimeObject._pool == this) {
                RealtimeObject realtimeObject2;
                this._objects[((RealtimeObject)realtimeObject)._poolIndex] = realtimeObject2 = this._objects[this._index];
                realtimeObject2._poolIndex = realtimeObject._poolIndex;
                this._objects[this._index] = realtimeObject;
                realtimeObject._poolIndex = this._index++;
                if (this._isCleanupEnabled) {
                    this.cleanup(object);
                }
            } else {
                throw new IllegalArgumentException("obj: Object not in the pool");
            }
        }

        protected void recycleAll() {
            int n = this._index;
            while (this._isCleanupEnabled && n < this._length) {
                this.cleanup(this._objects[n++]);
            }
            this._index = this._length;
        }

        protected void clearAll() {
            int n = this._length;
            while (n > 0) {
                this._objects[--n]._pool = null;
            }
            this._objects = new RealtimeObject[32];
            this._index = 0;
            this._length = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void export(RealtimeObject realtimeObject) {
            Pool pool = (Pool)this.getOuter();
            if (pool == null) {
                this.remove(realtimeObject);
            } else if (realtimeObject._poolIndex < 0) {
                this.unpreserve(realtimeObject);
                this.export(realtimeObject);
                this.preserve(realtimeObject);
            } else {
                RealtimeObject realtimeObject2;
                Pool pool2 = pool;
                synchronized (pool2) {
                    realtimeObject2 = (RealtimeObject)pool.next();
                }
                this._objects[((RealtimeObject)realtimeObject)._poolIndex] = realtimeObject2;
                pool._objects[((RealtimeObject)realtimeObject2)._poolIndex] = realtimeObject;
                realtimeObject2._pool = this;
                realtimeObject._pool = pool;
                int n = realtimeObject._poolIndex;
                realtimeObject._poolIndex = realtimeObject2._poolIndex;
                realtimeObject2._poolIndex = n;
            }
        }

        private void remove(RealtimeObject realtimeObject) {
            if (realtimeObject._poolIndex >= 0) {
                this._objects[((RealtimeObject)realtimeObject)._poolIndex] = this._objects[--this._length];
                this._objects[this._length]._poolIndex = realtimeObject._poolIndex;
                this._objects[this._length] = null;
            }
            realtimeObject._pool = null;
            realtimeObject._poolIndex = 0;
        }

        private void preserve(RealtimeObject realtimeObject) {
            if (realtimeObject._poolIndex >= 0) {
                this._objects[((RealtimeObject)realtimeObject)._poolIndex] = this._objects[--this._length];
                this._objects[this._length]._poolIndex = realtimeObject._poolIndex;
                this._objects[this._length] = null;
                realtimeObject._poolIndex = -1;
            }
        }

        private void unpreserve(RealtimeObject realtimeObject) {
            if (realtimeObject._poolIndex < 0) {
                realtimeObject._poolIndex = this._length;
                this._objects[this._length++] = realtimeObject;
            }
        }

        private void cleanup(Object object) {
            try {
                this._factory.cleanup(object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this._isCleanupEnabled = false;
            }
        }
    }

    public static abstract class Factory
    extends ObjectFactory {
        private Pool _cachedPool = new Pool(null);

        protected Factory() {
        }

        public final Object object() {
            Thread thread = Thread.currentThread();
            Pool pool = this._cachedPool;
            if (pool.getUser() == thread) {
                return pool._index > 0 ? pool._objects[--pool._index] : pool.allocate();
            }
            ObjectPool objectPool = this.currentPool();
            if (objectPool != this.heap()) {
                pool = (Pool)objectPool;
                Object object = pool.next();
                this._cachedPool = pool;
                return object;
            }
            return this.create();
        }

        protected ObjectPool newPool() {
            return new Pool(this);
        }
    }
}

