/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.JavolutionError;

public abstract class ObjectPool {
    protected static final int DEFAULT_POOL_SIZE = 32;
    ObjectPool outer;
    Thread user;
    boolean inUse;

    protected ObjectPool() {
    }

    public final Thread getUser() {
        return this.user;
    }

    public final boolean isLocal() {
        if (this.inUse) {
            if (this.user == null) {
                return false;
            }
            if (this.user == Thread.currentThread()) {
                return true;
            }
            throw new JavolutionError("Concurrent access to local pool detected");
        }
        throw new JavolutionError("Access to inner pool or unused pool detected");
    }

    public final boolean inUse() {
        return this.inUse;
    }

    public final ObjectPool getOuter() {
        return this.outer;
    }

    public abstract Object next();

    public abstract void recycle(Object var1);

    protected abstract void recycleAll();

    protected abstract void clearAll();
}

