/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import javolution.lang.Reusable;
import javolution.lang.Text;

public final class Utf8ByteBufferReader
extends Reader
implements Reusable {
    private ByteBuffer _byteBuffer;
    private int _code;
    private int _moreBytes;

    public Utf8ByteBufferReader setByteBuffer(ByteBuffer byteBuffer) {
        if (this._byteBuffer != null) {
            throw new IllegalStateException("Reader not closed or reset");
        }
        this._byteBuffer = byteBuffer;
        return this;
    }

    public boolean ready() throws IOException {
        if (this._byteBuffer != null) {
            return this._byteBuffer.hasRemaining();
        }
        throw new IOException("Reader closed");
    }

    public void close() throws IOException {
        if (this._byteBuffer != null) {
            this.reset();
        }
    }

    public int read() throws IOException {
        if (this._byteBuffer != null) {
            if (this._byteBuffer.hasRemaining()) {
                int n = this._byteBuffer.get();
                return n >= 0 ? n : this.read2((byte)n);
            }
            return -1;
        }
        throw new IOException("Reader closed");
    }

    private int read2(byte by) throws IOException {
        try {
            if (by >= 0 && this._moreBytes == 0) {
                return by;
            }
            if ((by & 0xC0) == 128 && this._moreBytes != 0) {
                this._code = this._code << 6 | by & 0x3F;
                if (--this._moreBytes == 0) {
                    return this._code;
                }
                return this.read2(this._byteBuffer.get());
            }
            if ((by & 0xE0) == 192 && this._moreBytes == 0) {
                this._code = by & 0x1F;
                this._moreBytes = 1;
                return this.read2(this._byteBuffer.get());
            }
            if ((by & 0xF0) == 224 && this._moreBytes == 0) {
                this._code = by & 0xF;
                this._moreBytes = 2;
                return this.read2(this._byteBuffer.get());
            }
            if ((by & 0xF8) == 240 && this._moreBytes == 0) {
                this._code = by & 7;
                this._moreBytes = 3;
                return this.read2(this._byteBuffer.get());
            }
            if ((by & 0xFC) == 248 && this._moreBytes == 0) {
                this._code = by & 3;
                this._moreBytes = 4;
                return this.read2(this._byteBuffer.get());
            }
            if ((by & 0xFE) == 252 && this._moreBytes == 0) {
                this._code = by & 1;
                this._moreBytes = 5;
                return this.read2(this._byteBuffer.get());
            }
            throw new CharConversionException("Invalid UTF-8 Encoding");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new CharConversionException("Incomplete Sequence");
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this._byteBuffer != null) {
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                if (this._byteBuffer.hasRemaining()) {
                    byte by = this._byteBuffer.get();
                    if (by >= 0) {
                        cArray[n4++] = (char)by;
                        continue;
                    }
                    if (n4 < n3 - 1) {
                        int n5 = this.read2(by);
                        if (n5 < 65536) {
                            cArray[n4++] = (char)n5;
                            continue;
                        }
                        if (n5 <= 0x10FFFF) {
                            cArray[n4++] = (char)((n5 - 65536 >> 10) + 55296);
                            cArray[n4++] = (char)((n5 - 65536 & 0x3FF) + 56320);
                            continue;
                        }
                        throw new CharConversionException("Cannot convert U+" + Text.valueOf(n5, 16) + " to char (code greater than U+10FFFF)");
                    }
                    ((Buffer)this._byteBuffer).position(this._byteBuffer.position() - 1);
                    return n4 - n;
                }
                return n4 - n;
            }
            return n2;
        }
        throw new IOException("Reader closed");
    }

    public void reset() {
        this._byteBuffer = null;
        this._code = 0;
        this._moreBytes = 0;
    }
}

