/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.realtime.PoolContext;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.Reflection;

final class Perf_Util
extends Javolution
implements Runnable {
    private static final int COLLECTION_SIZE = 200;
    private final Object[] _objects = new Object[200];

    Perf_Util() {
    }

    public void run() throws JavolutionError {
        for (int i = 0; i < 200; ++i) {
            this._objects[i] = new Object();
        }
        Javolution.println("-- HashMap/LinkedMap versus FastMap --");
        this.benchmarkMap("HashMap", Reflection.getConstructor("java.util.HashMap(int)"));
        this.benchmarkMap("LinkedHashMap", Reflection.getConstructor("java.util.LinkedHashMap(int)"));
        this.benchmarkMap("FastMap", new Reflection.Constructor(){

            public Object allocate(Object[] objectArray) {
                return FastMap.newInstance((Integer)objectArray[0]);
            }
        });
        Javolution.println("");
        Javolution.println("-- HashSet/LinkedHashSet/TreeSet versus FastSet --");
        this.benchmarkSet("HashSet", Reflection.getConstructor("java.util.HashSet(int)"));
        this.benchmarkSet("LinkedHashSet", Reflection.getConstructor("java.util.LinkedHashSet(int)"));
        this.benchmarkSet("FastSet", new Reflection.Constructor(){

            public Object allocate(Object[] objectArray) {
                return FastSet.newInstance((Integer)objectArray[0]);
            }
        });
        Javolution.println("");
        Javolution.println("-- ArrayList/LinkedList versus FastList --");
        this.benchmarkList("ArrayList", Reflection.getConstructor("java.util.ArrayList()"));
        this.benchmarkList("LinkedList", Reflection.getConstructor("java.util.LinkedList()"));
        this.benchmarkList("FastList", new Reflection.Constructor(){

            public Object allocate(Object[] objectArray) {
                return FastList.newInstance();
            }
        });
        Javolution.println("");
    }

    private void benchmarkMap(String string, Reflection.Constructor constructor) {
        Map map = null;
        if (constructor != null) {
            int n;
            int n2;
            Javolution.println(string);
            Javolution.print("    Creates/populates map of 200 entries: ");
            Javolution.startTime();
            for (n2 = 0; n2 < 50000; ++n2) {
                PoolContext.enter();
                map = (Map)constructor.newInstance(new Integer(200));
                for (n = 0; n < 200; ++n) {
                    map.put(this._objects[n], this._objects[n]);
                }
                PoolContext.exit();
            }
            Javolution.endTime(50000);
            Javolution.print("    Access (get): ");
            map = (Map)constructor.newInstance(new Integer(200));
            for (n2 = 0; n2 < 200; ++n2) {
                map.put(this._objects[n2], this._objects[n2]);
            }
            Javolution.startTime();
            for (n2 = 0; n2 < 50000; ++n2) {
                for (n = 0; n < 200; ++n) {
                    map.get(this._objects[n]);
                }
            }
            Javolution.endTime(10000000);
            Javolution.print("    Iterates through all map entries: ");
            Javolution.startTime();
            for (n2 = 0; n2 < 50000; ++n2) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            Javolution.endTime(50000);
            if (map instanceof FastMap) {
                Javolution.print("    ");
                ((FastMap)map).printStatistics(System.out);
            }
        }
    }

    private void benchmarkSet(String string, Reflection.Constructor constructor) {
        Set set = null;
        if (constructor != null) {
            int n;
            int n2;
            Javolution.println(string);
            Javolution.print("    Creates/populates set of 200 elements: ");
            Javolution.startTime();
            for (n2 = 0; n2 < 50000; ++n2) {
                PoolContext.enter();
                set = (Set)constructor.newInstance(new Integer(200));
                for (n = 0; n < 200; ++n) {
                    set.add(this._objects[n]);
                }
                PoolContext.exit();
            }
            Javolution.endTime(50000);
            Javolution.print("    Access (contains): ");
            set = (Set)constructor.newInstance(new Integer(200));
            for (n2 = 0; n2 < 200; ++n2) {
                set.add(this._objects[n2]);
            }
            Javolution.startTime();
            for (n2 = 0; n2 < 50000; ++n2) {
                for (n = 0; n < 200; ++n) {
                    set.contains(this._objects[n]);
                }
            }
            Javolution.endTime(10000000);
            Javolution.print("    Iterates through all set elements: ");
            Javolution.startTime();
            for (n2 = 0; n2 < 50000; ++n2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            Javolution.endTime(50000);
        }
    }

    private void benchmarkList(String string, Reflection.Constructor constructor) {
        List list = null;
        if (constructor != null) {
            int n;
            Javolution.println(string);
            Javolution.print("    Creates new list and appends 200 elements: ");
            Javolution.startTime();
            for (n = 0; n < 50000; ++n) {
                PoolContext.enter();
                list = (List)constructor.newInstance();
                for (int i = 0; i < 200; ++i) {
                    list.add(this._objects[i]);
                }
                PoolContext.exit();
            }
            Javolution.endTime(50000);
            Javolution.print("    Iterates through all list elements: ");
            Javolution.startTime();
            list = (List)constructor.newInstance();
            for (n = 0; n < 200; ++n) {
                list.add(this._objects[n]);
            }
            for (n = 0; n < 50000; ++n) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            Javolution.endTime(50000);
        }
    }
}

