/*
 * Decompiled with CFR 0.152.
 */
package com.reprisesoftware.rlm;

import com.reprisesoftware.rlm.RlmConstants;
import com.reprisesoftware.rlm.RlmException;
import com.reprisesoftware.rlm.RlmHandle;

public class RlmActHandle
implements RlmConstants {
    private static int RLM_ACT_HANDLE_ISV = 1;
    private static int RLM_ACT_HANDLE_HOSTID_LIST = 2;
    private static int RLM_ACT_HANDLE_HOSTNAME = 3;
    private static int RLM_ACT_HANDLE_EXTRA = 4;
    private static int RLM_ACT_HANDLE_LOG = 5;
    private static int RLM_ACT_HANDLE_REHOST = 6;
    private long actHandleL;
    private long rlmHandleL;
    private RlmHandle rlmHandle;

    private static native long rlmActNewHandle(long var0);

    private static native void rlmActDestroyHandle(long var0);

    private static native int rlmActSetHandle(long var0, int var2, String var3);

    private static native int rlmActSetHandleInt(long var0, int var2, int var3);

    public RlmActHandle(RlmHandle rh) {
        this.rlmHandle = rh;
        this.rlmHandleL = rh.getHandle();
        this.actHandleL = RlmActHandle.rlmActNewHandle(this.rlmHandleL);
    }

    public void setExtra(String extra) throws RlmException {
        int stat = RlmActHandle.rlmActSetHandle(this.actHandleL, RLM_ACT_HANDLE_EXTRA, extra);
        if (stat != 0) {
            throw new RlmException(stat, this.rlmHandle);
        }
    }

    public void setHostidList(String hostidList) throws RlmException {
        int stat = RlmActHandle.rlmActSetHandle(this.actHandleL, RLM_ACT_HANDLE_HOSTID_LIST, hostidList);
        if (stat != 0) {
            throw new RlmException(stat, this.rlmHandle);
        }
    }

    public void setHostname(String hostname) throws RlmException {
        int stat = RlmActHandle.rlmActSetHandle(this.actHandleL, RLM_ACT_HANDLE_HOSTNAME, hostname);
        if (stat != 0) {
            throw new RlmException(stat, this.rlmHandle);
        }
    }

    public void setLogString(String logString) throws RlmException {
        int stat = RlmActHandle.rlmActSetHandle(this.actHandleL, RLM_ACT_HANDLE_LOG, logString);
        if (stat != 0) {
            throw new RlmException(stat, this.rlmHandle);
        }
    }

    public void setISV(String ISV) throws RlmException {
        int stat = RlmActHandle.rlmActSetHandle(this.actHandleL, RLM_ACT_HANDLE_ISV, ISV);
        if (stat != 0) {
            throw new RlmException(stat, this.rlmHandle);
        }
    }

    public void setRehostable(boolean rehostable) {
        RlmActHandle.rlmActSetHandleInt(this.actHandleL, RLM_ACT_HANDLE_REHOST, rehostable ? 1 : 0);
    }

    protected long getHandle() {
        return this.actHandleL;
    }

    protected void finalize() {
        RlmActHandle.rlmActDestroyHandle(this.actHandleL);
    }
}

