/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javolution.lang.Reusable;
import javolution.lang.Text;
import javolution.util.FastList;
import javolution.xml.sax.Attributes;
import javolution.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WriterHandler
implements ContentHandler,
Reusable {
    private Writer _writer;
    private CharSequence _prolog = Text.EMPTY;
    private CharSequence _indent = Text.EMPTY;
    private FastList _prefixMappings = new FastList();
    private int _nesting = -1;
    private boolean _isTagOpen;

    public WriterHandler setWriter(Writer writer) {
        this._writer = writer;
        return this;
    }

    public void setIndent(CharSequence charSequence) {
        this._indent = charSequence;
    }

    public void setProlog(CharSequence charSequence) {
        this._prolog = charSequence;
    }

    public void reset() {
        this._writer = null;
        this._indent = Text.EMPTY;
        this._prolog = Text.EMPTY;
        this._prefixMappings.clear();
        this._nesting = -1;
        this._isTagOpen = false;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        if (this._writer == null) {
            throw new SAXException("Writer not set");
        }
        try {
            int n = 0;
            while (n < this._prolog.length()) {
                this._writer.write(this._prolog.charAt(n++));
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this._writer.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(CharSequence charSequence, CharSequence charSequence2) throws SAXException {
        this._prefixMappings.add(charSequence);
        this._prefixMappings.add(charSequence2);
    }

    public void endPrefixMapping(CharSequence charSequence) throws SAXException {
    }

    public void startElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Attributes attributes) throws SAXException {
        try {
            CharSequence charSequence4;
            if (this._isTagOpen) {
                this._writer.write(">\n");
                this._isTagOpen = false;
            }
            ++this._nesting;
            this.indent();
            this._writer.write(60);
            this.write(charSequence3);
            Iterator iterator = this._prefixMappings.fastIterator();
            while (iterator.hasNext()) {
                CharSequence charSequence5 = (CharSequence)iterator.next();
                charSequence4 = (CharSequence)iterator.next();
                if (charSequence5.length() == 0) {
                    this._writer.write(" xmlns=\"");
                    this.write(charSequence4);
                    this._writer.write(34);
                    continue;
                }
                this._writer.write(" xmlns:");
                this.write(charSequence5);
                this._writer.write("=\"");
                this.write(charSequence4);
                this._writer.write(34);
            }
            this._prefixMappings.clear();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                charSequence4 = attributes.getQName(i);
                CharSequence charSequence6 = attributes.getValue(i);
                this._writer.write(32);
                this.write(charSequence4);
                this._writer.write("=\"");
                this.write(charSequence6);
                this._writer.write(34);
            }
            this._isTagOpen = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void indent() throws IOException {
        int n = this._indent.length();
        if (n > 0) {
            for (int i = 0; i < this._nesting; ++i) {
                int n2 = 0;
                while (n2 < n) {
                    this._writer.write(this._indent.charAt(n2++));
                }
            }
        }
    }

    public void endElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws SAXException {
        try {
            if (this._isTagOpen) {
                this._writer.write("/>\n");
                this._isTagOpen = false;
            } else {
                this.indent();
                this._writer.write("</");
                this.write(charSequence3);
                this._writer.write(">\n");
            }
            --this._nesting;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this._isTagOpen) {
                this._writer.write(62);
                this._isTagOpen = false;
            }
            this._writer.write("<![CDATA[");
            this._writer.write(cArray, n, n2);
            this._writer.write("]]>\n");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(CharSequence charSequence, CharSequence charSequence2) throws SAXException {
    }

    public void skippedEntity(CharSequence charSequence) throws SAXException {
    }

    private void write(CharSequence charSequence) throws IOException {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) > '>') {
                this._writer.write(c);
                continue;
            }
            this.escapeWrite(c);
        }
    }

    private void escapeWrite(char c) throws IOException {
        switch (c) {
            case '<': {
                this._writer.write("&lt;");
                break;
            }
            case '>': {
                this._writer.write("&gt;");
                break;
            }
            case '\'': {
                this._writer.write("&apos;");
                break;
            }
            case '\"': {
                this._writer.write("&quot;");
                break;
            }
            case '&': {
                this._writer.write("&amp;");
                break;
            }
            default: {
                if (c >= ' ') {
                    this._writer.write(c);
                    break;
                }
                this._writer.write("&#");
                this._writer.write(48 + c / 10);
                this._writer.write(48 + c % 10);
                this._writer.write(59);
            }
        }
    }
}

