/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.io.OutputStream;
import javolution.lang.Reusable;
import javolution.xml.ObjectWriter;

public class XmlOutputStream
extends OutputStream
implements Reusable {
    static final byte END_XML = -2;
    private OutputStream _outputStream;
    private final ObjectWriter _objectWriter = new ObjectWriter();
    private final OutputStreamProxy _outputStreamProxy = new OutputStreamProxy();

    public XmlOutputStream setOutputStream(OutputStream outputStream) {
        if (this._outputStream != null) {
            throw new IllegalStateException("Stream not closed or reset");
        }
        this._outputStream = outputStream;
        return this;
    }

    public void writeObject(Object object) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._objectWriter.write(object, this._outputStreamProxy);
        this._outputStream.write(-2);
        this._outputStream.flush();
    }

    public void write(int n) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(n);
    }

    public void flush() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.flush();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(byArray, n, n2);
    }

    public void close() throws IOException {
        if (this._outputStream != null) {
            this._outputStream.close();
            this.reset();
        }
    }

    public void reset() {
        this._objectWriter.reset();
        this._outputStream = null;
    }

    private final class OutputStreamProxy
    extends OutputStream {
        private OutputStreamProxy() {
        }

        public void flush() throws IOException {
            XmlOutputStream.this._outputStream.flush();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            XmlOutputStream.this._outputStream.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            XmlOutputStream.this._outputStream.write(n);
        }

        public void close() throws IOException {
        }
    }
}

