/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javolution.JavolutionError;
import javolution.lang.Text;
import javolution.realtime.LocalContext;
import javolution.util.FastMap;
import javolution.util.Reflection;
import javolution.xml.XmlElement;
import javolution.xml.XmlException;

public abstract class XmlFormat {
    private static final FastMap FORMATS = new FastMap(64);
    private static final FastMap CLASS_TO_FORMAT = new FastMap();
    private static final FastMap CLASS_TO_NAME = new FastMap();
    private static final FastMap NAME_TO_CLASS = new FastMap();
    static final Null NULL = new Null();
    public static final XmlFormat NULL_XML = new XmlFormat(NULL.getClass()){

        public void format(Object object, XmlElement xmlElement) {
        }

        public Object parse(XmlElement xmlElement) {
            return null;
        }
    };
    public static final XmlFormat OBJECT_XML;
    public static final XmlFormat COLLECTION_XML;
    public static final XmlFormat MAP_XML;
    public static final XmlFormat STRING_XML;
    private Class _mappedClass;
    private static final FastMap ID_TO_CLASS;

    protected XmlFormat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XmlFormat(Class clazz) {
        this._mappedClass = clazz;
        FastMap fastMap = FORMATS;
        synchronized (fastMap) {
            if (FORMATS.containsKey(this._mappedClass)) {
                throw new IllegalArgumentException("Mapping already exists for " + this._mappedClass);
            }
            FORMATS.put(this._mappedClass, new LocalContext.Variable(this));
            CLASS_TO_FORMAT.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XmlFormat(String string) {
        try {
            this._mappedClass = Reflection.getClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JavolutionError(classNotFoundException);
        }
        FastMap fastMap = FORMATS;
        synchronized (fastMap) {
            if (FORMATS.containsKey(this._mappedClass)) {
                throw new IllegalArgumentException("Mapping already exists for " + this._mappedClass);
            }
            FORMATS.put(this._mappedClass, new LocalContext.Variable(this));
            CLASS_TO_FORMAT.clear();
        }
    }

    public Class getMappedClass() {
        return this._mappedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(XmlFormat xmlFormat, Class clazz) {
        FastMap fastMap = FORMATS;
        synchronized (fastMap) {
            xmlFormat._mappedClass = clazz;
            LocalContext.Variable variable = (LocalContext.Variable)FORMATS.get(clazz);
            if (variable == null) {
                variable = new LocalContext.Variable();
                FORMATS.put(clazz, variable);
            }
            variable.setValue(xmlFormat);
            CLASS_TO_FORMAT.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlFormat getInstance(Class clazz) {
        FastMap fastMap = FORMATS;
        synchronized (fastMap) {
            Object object = CLASS_TO_FORMAT.get(clazz);
            if (object != null) {
                return (XmlFormat)object;
            }
            try {
                Reflection.getClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Class clazz2 = null;
            XmlFormat xmlFormat = null;
            Iterator iterator = FORMATS.fastKeysIterator();
            while (iterator.hasNext()) {
                LocalContext.Variable variable;
                XmlFormat xmlFormat2;
                Class clazz3 = (Class)iterator.next();
                if (!clazz3.isAssignableFrom(clazz) || clazz2 != null && !clazz2.isAssignableFrom(clazz3) || (xmlFormat2 = (XmlFormat)(variable = (LocalContext.Variable)FORMATS.get(clazz3)).getValue()) == null) continue;
                clazz2 = clazz3;
                xmlFormat = xmlFormat2;
            }
            if (xmlFormat == null) {
                xmlFormat = OBJECT_XML;
            }
            CLASS_TO_FORMAT.put(clazz, xmlFormat);
            return xmlFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAlias(Class clazz, String string) {
        FastMap fastMap = CLASS_TO_NAME;
        synchronized (fastMap) {
            CLASS_TO_NAME.put(clazz, string);
            NAME_TO_CLASS.put(string, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String nameFor(Class clazz) {
        FastMap fastMap = CLASS_TO_NAME;
        synchronized (fastMap) {
            String string = (String)CLASS_TO_NAME.get(clazz);
            if (string == null) {
                string = clazz.getName();
                CLASS_TO_NAME.put(clazz, string);
                NAME_TO_CLASS.put(string, clazz);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class classFor(Identifier identifier) {
        FastMap fastMap = ID_TO_CLASS;
        synchronized (fastMap) {
            String string;
            Class clazz = (Class)ID_TO_CLASS.get(identifier);
            if (clazz != null) {
                return clazz;
            }
            Text text = Text.valueOf(identifier.uri).intern();
            Text text2 = Text.valueOf(identifier.localName).intern();
            if (text.length() == 0) {
                string = text2.toString();
            } else if (text.length() >= 5 && text.charAt(0) == 'j' && text.charAt(1) == 'a' && text.charAt(2) == 'v' && text.charAt(3) == 'a' && text.charAt(4) == ':') {
                string = text.length() > 5 ? text.subtext(5, text.length()) + "." + text2 : text2.toString();
            } else {
                throw new XmlException("Invalid URI (must use a java scheme)");
            }
            Object object = CLASS_TO_NAME;
            synchronized (object) {
                clazz = (Class)NAME_TO_CLASS.get(string);
                if (clazz == null) {
                    try {
                        clazz = Reflection.getClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new XmlException(classNotFoundException);
                    }
                    CLASS_TO_NAME.put(clazz, string);
                    NAME_TO_CLASS.put(string, clazz);
                }
            }
            object = new Identifier();
            ((Identifier)object).uri = text;
            ((Identifier)object).localName = text2;
            ID_TO_CLASS.put(object, clazz);
            return clazz;
        }
    }

    public Object preallocate(XmlElement xmlElement) {
        return null;
    }

    public String identifier(boolean bl) {
        return null;
    }

    public abstract void format(Object var1, XmlElement var2);

    public abstract Object parse(XmlElement var1);

    static {
        XmlFormat.setAlias(NULL.getClass(), "Null");
        OBJECT_XML = new XmlFormat(){

            public void format(Object object, XmlElement xmlElement) {
            }

            public Object parse(XmlElement xmlElement) {
                return xmlElement.object();
            }
        };
        COLLECTION_XML = new XmlFormat("java.util.Collection"){

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.getContent().addAll((Collection)object);
            }

            public Object parse(XmlElement xmlElement) {
                Collection collection = (Collection)xmlElement.object();
                collection.addAll(xmlElement.getContent());
                return collection;
            }
        };
        MAP_XML = new XmlFormat("java.util.Map"){

            public void format(Object object, XmlElement xmlElement) {
                Map map = (Map)object;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    xmlElement.getContent().add(entry.getKey());
                    xmlElement.getContent().add(entry.getValue());
                }
            }

            public Object parse(XmlElement xmlElement) {
                Map map = (Map)xmlElement.object();
                Iterator iterator = xmlElement.getContent().fastIterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object e2 = iterator.next();
                    map.put(e, e2);
                }
                return map;
            }
        };
        STRING_XML = new XmlFormat("".getClass()){

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (String)object);
            }

            public Object parse(XmlElement xmlElement) {
                return xmlElement.getAttribute("value", "");
            }
        };
        ID_TO_CLASS = new FastMap();
    }

    static final class Identifier {
        CharSequence uri;
        CharSequence localName;

        Identifier() {
        }

        public boolean equals(Object object) {
            Identifier identifier = (Identifier)object;
            return identifier.uri.equals(this.uri) && identifier.localName.equals(this.localName);
        }

        public int hashCode() {
            return this.localName.hashCode();
        }
    }

    private static class Null {
        private Null() {
        }
    }
}

