/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.realtime.Context;
import javolution.realtime.DefaultPool;
import javolution.realtime.ObjectFactory;
import javolution.realtime.ObjectPool;

public final class PoolContext
extends Context {
    private static final ObjectPool NULL_POOL = new DefaultPool(null);
    final ObjectPool[] _pools = new ObjectPool[ObjectFactory.MAX];
    private final ObjectPool[] _inUsePools = new ObjectPool[ObjectFactory.MAX];
    private int _inUsePoolsLength;
    private static final Class POOL_CONTEXT_CLASS = new PoolContext().getClass();

    PoolContext() {
        int n = this._pools.length;
        while (n > 0) {
            this._pools[--n] = NULL_POOL;
        }
    }

    public static void enter() {
        PoolContext poolContext;
        PoolContext poolContext2 = (PoolContext)Context.push(POOL_CONTEXT_CLASS);
        if (poolContext2 == null) {
            poolContext2 = new PoolContext();
            Context.push(poolContext2);
        }
        if ((poolContext = poolContext2.getOuter().poolContext()) != null) {
            poolContext.setInUsePoolsLocal(false);
        }
    }

    public static void exit() {
        PoolContext poolContext = (PoolContext)Context.pop();
        poolContext.recyclePools();
        PoolContext poolContext2 = poolContext.getOuter().poolContext();
        if (poolContext2 != null) {
            poolContext2.setInUsePoolsLocal(true);
        }
    }

    protected void dispose() {
        int n = ObjectFactory.Count;
        while (n > 0) {
            ObjectPool objectPool;
            if ((objectPool = this._pools[--n]) == NULL_POOL) continue;
            objectPool.clearAll();
        }
        this._inUsePoolsLength = 0;
    }

    void setInUsePoolsLocal(boolean bl) {
        Thread thread = bl ? this.getOwner() : null;
        int n = this._inUsePoolsLength;
        while (n > 0) {
            this._inUsePools[--n].user = thread;
        }
    }

    ObjectPool getLocalPool(int n) {
        ObjectPool objectPool = this._pools[n];
        return objectPool.user != null ? objectPool : this.getLocalPool2(n);
    }

    private ObjectPool getLocalPool2(int n) {
        ObjectPool objectPool = this.getPool(n);
        objectPool.user = this.getOwner();
        return objectPool;
    }

    private synchronized ObjectPool getPool(int n) {
        ObjectPool objectPool = this._pools[n];
        if (objectPool == NULL_POOL) {
            this._pools[n] = objectPool = ObjectFactory.INSTANCES[n].newPool();
        }
        if (!objectPool.inUse) {
            objectPool.inUse = true;
            this._inUsePools[this._inUsePoolsLength++] = objectPool;
            PoolContext poolContext = this.getOuter().poolContext();
            objectPool.outer = poolContext != null ? poolContext.getPool(n) : null;
        }
        return objectPool;
    }

    void recyclePools() {
        int n = this._inUsePoolsLength;
        while (n > 0) {
            ObjectPool objectPool = this._inUsePools[--n];
            objectPool.recycleAll();
            objectPool.user = null;
            objectPool.inUse = false;
        }
        this._inUsePoolsLength = 0;
    }
}

