/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.Configuration;
import javolution.realtime.Context;

public final class LocalContext
extends Context {
    private final Object[] _values = new Object[Variable.MAX];
    private static final Class LOCAL_CONTEXT_CLASS = new LocalContext().getClass();
    private static final Object[] _NULL_VALUES = new Object[Variable.MAX];

    LocalContext() {
    }

    public static void enter() {
        LocalContext localContext = (LocalContext)Context.push(LOCAL_CONTEXT_CLASS);
        if (localContext == null) {
            localContext = new LocalContext();
            Context.push(localContext);
        }
    }

    public static void exit() {
        LocalContext localContext = (LocalContext)Context.pop();
        System.arraycopy(_NULL_VALUES, 0, localContext._values, 0, Variable._Count);
    }

    protected void dispose() {
    }

    public static class Variable {
        public static final int MAX = Configuration.variables();
        private static volatile int _Count = 0;
        private volatile Object _defaultValue;
        private final int _ctxIndex = Variable.index();

        public Variable() {
            this(null);
        }

        public Variable(Object object) {
            this._defaultValue = object;
        }

        private static synchronized int index() {
            if (_Count < MAX) {
                return _Count++;
            }
            throw new UnsupportedOperationException("Maximum number of variables  (system property \"javolution.variables\", value " + MAX + ") has been reached");
        }

        public Object getValue() {
            for (Context context = Context.currentContext(); context != null; context = context.getOuter()) {
                Object object;
                if (!(context instanceof LocalContext) || (object = ((LocalContext)context)._values[this._ctxIndex]) == null) continue;
                return object;
            }
            return this._defaultValue;
        }

        public void setValue(Object object) {
            for (Context context = Context.currentContext(); context != null; context = context.getOuter()) {
                if (!(context instanceof LocalContext)) continue;
                ((LocalContext)((LocalContext)context))._values[this._ctxIndex] = object;
                return;
            }
            this._defaultValue = object;
        }

        public void setDefault(Object object) {
            this._defaultValue = object;
        }
    }
}

