/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.realtime.Context;
import javolution.realtime.PoolContext;

public final class HeapContext
extends Context {
    private static final Class HEAP_CONTEXT_CLASS = new HeapContext().getClass();

    HeapContext() {
    }

    public static void enter() {
        PoolContext poolContext;
        HeapContext heapContext = (HeapContext)Context.push(HEAP_CONTEXT_CLASS);
        if (heapContext == null) {
            heapContext = new HeapContext();
            Context.push(heapContext);
        }
        if ((poolContext = heapContext.getOuter().poolContext()) != null) {
            poolContext.setInUsePoolsLocal(false);
        }
    }

    public static void exit() {
        HeapContext heapContext = (HeapContext)Context.pop();
        PoolContext poolContext = heapContext.getOuter().poolContext();
        if (poolContext != null) {
            poolContext.setInUsePoolsLocal(true);
        }
    }

    protected void dispose() {
    }
}

