/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.realtime.ObjectFactory;
import javolution.realtime.ObjectPool;

final class DefaultPool
extends ObjectPool {
    private Object[] _objects = new Object[32];
    private int _index;
    private int _length;
    private boolean _isCleanupEnabled = true;
    private final ObjectFactory _factory;

    DefaultPool(ObjectFactory objectFactory) {
        this._factory = objectFactory;
    }

    public Object next() {
        return this._index > 0 ? this._objects[--this._index] : this.allocate();
    }

    private Object allocate() {
        Object object = this._factory.create();
        if (this._length >= this._objects.length) {
            Object[] objectArray = new Object[this._length * 2];
            System.arraycopy(this._objects, 0, objectArray, 0, this._length);
            this._objects = objectArray;
        }
        this._objects[this._length++] = object;
        return object;
    }

    public void recycle(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this._objects[n] = this._objects[this._index];
            this._objects[this._index++] = object;
            if (this._isCleanupEnabled) {
                this.cleanup(object);
            }
        } else {
            throw new IllegalArgumentException("obj: Object not in the pool");
        }
    }

    protected void recycleAll() {
        int n = this._index;
        while (this._isCleanupEnabled && n < this._length) {
            this.cleanup(this._objects[n++]);
        }
        this._index = this._length;
    }

    protected void clearAll() {
        this._objects = new Object[32];
        this._index = 0;
        this._length = 0;
    }

    private int indexOf(Object object) {
        for (int i = this._index; i < this._length; ++i) {
            if (this._objects[i] != object) continue;
            return i;
        }
        return -1;
    }

    private void cleanup(Object object) {
        try {
            this._factory.cleanup(object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this._isCleanupEnabled = false;
        }
    }
}

