/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javolution.Configuration;
import javolution.realtime.ConcurrentContext;
import javolution.realtime.Context;
import javolution.realtime.PoolContext;
import javolution.util.Reflection;

public final class ConcurrentThread
extends Thread {
    public static final int MAX = Configuration.concurrency();
    private static final ConcurrentThread[] INSTANCES = new ConcurrentThread[MAX];
    private ConcurrentContext _concurrentContext;
    int logicsLength;
    private final String _name;
    private static final Reflection.Method SET_DAEMON;

    private ConcurrentThread(int n) {
        this._name = "ConcurrentThread-" + n;
        if (SET_DAEMON != null) {
            SET_DAEMON.invoke(this, new Boolean(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int execute(ConcurrentContext concurrentContext) {
        int n = 0;
        if (MAX <= 0) return n;
        ConcurrentThread[] concurrentThreadArray = INSTANCES;
        synchronized (INSTANCES) {
            for (int i = 0; i < MAX; ++i) {
                if (ConcurrentThread.INSTANCES[i]._concurrentContext != null) continue;
                ConcurrentThread concurrentThread = INSTANCES[i];
                synchronized (concurrentThread) {
                    ConcurrentThread.INSTANCES[i]._concurrentContext = concurrentContext;
                    INSTANCES[i].notify();
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        PoolContext poolContext = (PoolContext)Context.currentContext();
        while (true) {
            ConcurrentThread[] concurrentThreadArray;
            try {
                concurrentThreadArray = this;
                // MONITORENTER : this
                while (this._concurrentContext == null) {
                    this.wait();
                }
                // MONITOREXIT : concurrentThreadArray
                poolContext.setOuter(this._concurrentContext);
                while (this._concurrentContext.executeNext()) {
                    poolContext.recyclePools();
                }
                concurrentThreadArray = INSTANCES;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    concurrentThreadArray = INSTANCES;
                }
                catch (Throwable throwable2) {
                    ConcurrentThread[] concurrentThreadArray2 = INSTANCES;
                    // MONITORENTER : INSTANCES
                    this._concurrentContext = null;
                    // MONITOREXIT : concurrentThreadArray2
                    throw throwable2;
                }
                this._concurrentContext = null;
                // MONITOREXIT : concurrentThreadArray
                continue;
            }
            // MONITORENTER : INSTANCES
            this._concurrentContext = null;
            // MONITOREXIT : concurrentThreadArray
            continue;
            break;
        }
    }

    public String toString() {
        return this._name;
    }

    static {
        for (int i = 0; i < MAX; ++i) {
            ConcurrentThread.INSTANCES[i] = new ConcurrentThread(i);
            INSTANCES[i].start();
        }
        SET_DAEMON = Reflection.getMethod("java.lang.Thread.setDaemon(bool)");
    }
}

