/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.Serializable;
import javolution.lang.TextBuilder;
import javolution.lang.TypeFormat;
import javolution.realtime.ArrayPool;
import javolution.realtime.ObjectPool;
import javolution.realtime.Realtime;
import javolution.realtime.RealtimeObject;
import javolution.util.FastMap;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;

public abstract class Text
extends RealtimeObject
implements CharSequence,
Comparable,
Serializable {
    private static final FastMap INTERN_TEXT = new FastMap();
    public static final Text EMPTY = Text.valueOf("").intern();
    protected static final XmlFormat TEXT_XML = new XmlFormat(EMPTY.getClass()){

        public void format(Object object, XmlElement xmlElement) {
            xmlElement.setAttribute("value", (CharSequence)((Text)object));
        }

        public Object parse(XmlElement xmlElement) {
            return Text.valueOf(xmlElement.getAttribute("value"));
        }
    };
    static final Text NULL = Text.valueOf("null").intern();
    int _count;
    int _hashCode;
    private static final Text TRUE = Text.valueOf("true").intern();
    private static final Text FALSE = Text.valueOf("false").intern();
    private static final Text[] ASCII_CHARS = new Text[128];

    private Text() {
    }

    public static Text valueOf(String string) {
        return Text.valueOf(string, 0, string.length());
    }

    static Text valueOf(String string, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 32) {
            Primitive primitive = Primitive.newInstance();
            int n4 = 0;
            while (n4 < n3) {
                primitive._data[primitive._count++] = string.charAt(n + n4++);
            }
            return primitive;
        }
        int n5 = n + (n3 >> 1);
        Composite composite = Composite.newInstance(Text.valueOf(string, n, n5), Text.valueOf(string, n5, n2));
        return composite;
    }

    public static Text valueOf(CharSequence charSequence) {
        return Text.valueOf(charSequence, 0, charSequence.length());
    }

    static Text valueOf(CharSequence charSequence, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 32) {
            Primitive primitive = Primitive.newInstance();
            int n4 = 0;
            while (n4 < n3) {
                primitive._data[primitive._count++] = charSequence.charAt(n + n4++);
            }
            return primitive;
        }
        int n5 = n + (n3 >> 1);
        Composite composite = Composite.newInstance(Text.valueOf(charSequence, n, n5), Text.valueOf(charSequence, n5, n2));
        return composite;
    }

    public static Text valueOf(char[] cArray, int n, int n2) {
        if (n2 <= 32) {
            Primitive primitive = Primitive.newInstance();
            int n3 = 0;
            while (n3 < n2) {
                primitive._data[primitive._count++] = cArray[n + n3++];
            }
            return primitive;
        }
        int n4 = n + (n2 >> 1);
        Composite composite = Composite.newInstance(Text.valueOf(cArray, n, n4 - n), Text.valueOf(cArray, n4, n + n2 - n4));
        return composite;
    }

    public static Text valueOf(Object object) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(object);
        return textBuilder.toText();
    }

    public static Text valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static Text valueOf(char c) {
        if (c < ASCII_CHARS.length) {
            return ASCII_CHARS[c];
        }
        Primitive primitive = Primitive.newInstance();
        primitive._data[primitive._count++] = c;
        return primitive;
    }

    public static Text valueOf(int n) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(n);
        return textBuilder.toText();
    }

    public static Text valueOf(int n, int n2) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(n, n2);
        return textBuilder.toText();
    }

    public static Text valueOf(long l) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l);
        return textBuilder.toText();
    }

    public static Text valueOf(long l, int n) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l, n);
        return textBuilder.toText();
    }

    public static Text valueOf(float f) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(f);
        return textBuilder.toText();
    }

    public static Text valueOf(double d) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(d);
        return textBuilder.toText();
    }

    public final int length() {
        return this._count;
    }

    public final Text subtext(int n) {
        return this.subtext(n, this.length());
    }

    public CharSequence subSequence(int n, int n2) {
        return this.subtext(n, n2);
    }

    public final int indexOf(CharSequence charSequence) {
        return this.indexOf(charSequence, 0);
    }

    public final int indexOf(CharSequence charSequence, int n) {
        return TypeFormat.indexOf(charSequence, this, n);
    }

    public final int lastIndexOf(CharSequence charSequence) {
        return TypeFormat.lastIndexOf(charSequence, this, this.length());
    }

    public final int lastIndexOf(CharSequence charSequence, int n) {
        return TypeFormat.lastIndexOf(charSequence, this, n);
    }

    public final boolean startsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, 0);
    }

    public final boolean endsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, this.length() - charSequence.length());
    }

    public final boolean startsWith(CharSequence charSequence, int n) {
        if (n >= 0 && n <= this.length() - charSequence.length()) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (charSequence.charAt(i) == this.charAt(i + n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final Text concat(CharSequence charSequence) {
        return charSequence instanceof Text ? this.plus((Text)charSequence) : this.plus(Text.valueOf(charSequence));
    }

    public final Text trim() {
        int n;
        int n2 = this.length() - 1;
        for (n = 0; n <= n2 && this.charAt(n) <= ' '; ++n) {
        }
        while (n2 >= n && this.charAt(n2) <= ' ') {
            --n2;
        }
        int n3 = n2 - n + 1;
        return n3 == this.length() ? this : this.subtext(n, n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Text intern() {
        FastMap fastMap = INTERN_TEXT;
        synchronized (fastMap) {
            Text text = (Text)INTERN_TEXT.get(this);
            if (text == null) {
                text = this;
                text.moveHeap();
                INTERN_TEXT.put(text, text);
            }
            return text;
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CharSequence || object instanceof String) {
            return TypeFormat.LEXICAL_COMPARATOR.compare(this, object) == 0;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(CharSequence charSequence) {
        if (this == charSequence) {
            return true;
        }
        int n = this.length();
        if (n == charSequence.length()) {
            int n2 = 0;
            while (n2 < n) {
                char c;
                char c2 = Character.toUpperCase(this.charAt(n2));
                if (c2 == (c = Character.toUpperCase(charSequence.charAt(n2++))) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        int n = this._hashCode;
        if (n == 0) {
            int n2 = this.length();
            int n3 = 0;
            while (n3 < n2) {
                n = 31 * n + this.charAt(n3++);
            }
            this._hashCode = n;
        }
        return n;
    }

    public final int compareTo(Object object) {
        return TypeFormat.LEXICAL_COMPARATOR.compare(this, object);
    }

    public final Text toText() {
        return this;
    }

    public abstract char charAt(int var1);

    public abstract Text subtext(int var1, int var2);

    public abstract Text copy();

    public abstract void getChars(int var1, int var2, char[] var3, int var4);

    public abstract Text plus(Text var1);

    public abstract Text replace(char var1, char var2);

    public abstract String stringValue();

    static {
        for (int i = 0; i < ASCII_CHARS.length; ++i) {
            Primitive primitive = Primitive.newInstance();
            primitive._data[primitive._count++] = (char)i;
            Text.ASCII_CHARS[i] = primitive.intern();
        }
    }

    static final class Composite
    extends Text {
        Text _head;
        Text _tail;
        private static final RealtimeObject.Factory COMPOSITE_FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new Composite();
            }
        };

        private Composite() {
        }

        static Composite newInstance(Text text, Text text2) {
            Composite composite = (Composite)COMPOSITE_FACTORY.object();
            composite._hashCode = 0;
            composite._count = text._count + text2._count;
            composite._head = text;
            composite._tail = text2;
            return composite;
        }

        public char charAt(int n) {
            return n < this._head._count ? this._head.charAt(n) : this._tail.charAt(n - this._head._count);
        }

        public Text subtext(int n, int n2) {
            int n3 = this._head._count;
            if (n2 <= n3) {
                return this._head.subtext(n, n2);
            }
            if (n >= n3) {
                return this._tail.subtext(n - n3, n2 - n3);
            }
            return this._head.subtext(n, n3).plus(this._tail.subtext(0, n2 - n3));
        }

        public Text copy() {
            if (this._count <= 32) {
                Primitive primitive = Primitive.newInstance();
                primitive._count = this._count;
                int n = this._count;
                while (n > 0) {
                    primitive._data[--n] = this.charAt(n);
                }
                return primitive;
            }
            return Composite.newInstance(this._head.copy(), this._tail.copy());
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            int n4 = this._head._count;
            if (n2 <= n4) {
                this._head.getChars(n, n2, cArray, n3);
            } else if (n >= n4) {
                this._tail.getChars(n - n4, n2 - n4, cArray, n3);
            } else {
                this._head.getChars(n, n4, cArray, n3);
                this._tail.getChars(0, n2 - n4, cArray, n3 + n4 - n);
            }
        }

        public Text plus(Text text) {
            if (this._head._count <= this._tail._count) {
                if (text._count <= this._count || text instanceof Primitive) {
                    return Composite.newInstance(this, text);
                }
                Composite composite = (Composite)text;
                return this.plus(composite._head).plus(composite._tail);
            }
            if (text._count + this._tail._count <= this._head._count || text instanceof Primitive) {
                return Composite.newInstance(this._head, this._tail.plus(text));
            }
            Composite composite = (Composite)text;
            return this.plus(composite._head).plus(composite._tail);
        }

        public Text replace(char c, char c2) {
            Text text = this._head.replace(c, c2);
            Text text2 = this._tail.replace(c, c2);
            if (text == this._head && text2 == this._tail) {
                return this;
            }
            return Composite.newInstance(text, text2);
        }

        public String stringValue() {
            ObjectPool objectPool = ArrayPool.charArray(this._count);
            char[] cArray = (char[])objectPool.next();
            this.getChars(0, this._count, cArray, 0);
            objectPool.recycle(cArray);
            return new String(cArray, 0, this._count);
        }

        public void move(Realtime.ContextSpace contextSpace) {
            super.move(contextSpace);
            this._head.move(contextSpace);
            this._tail.move(contextSpace);
        }
    }

    static final class Primitive
    extends Text {
        static final int BLOCK_SIZE = 32;
        final char[] _data = new char[32];
        private static final RealtimeObject.Factory PRIMITIVE_FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new Primitive();
            }
        };

        private Primitive() {
        }

        static Primitive newInstance() {
            Primitive primitive = (Primitive)PRIMITIVE_FACTORY.object();
            primitive._hashCode = 0;
            primitive._count = 0;
            return primitive;
        }

        public char charAt(int n) {
            if (n >= this._count) {
                throw new IndexOutOfBoundsException();
            }
            return this._data[n];
        }

        public Text subtext(int n, int n2) {
            int n3 = n2 - n;
            if (n3 >= 0) {
                Primitive primitive = Primitive.newInstance();
                primitive._count = n3;
                int n4 = n;
                int n5 = 0;
                while (n4 < n2) {
                    primitive._data[n5++] = this._data[n4++];
                }
                return primitive;
            }
            throw new IndexOutOfBoundsException();
        }

        public Text copy() {
            Primitive primitive = Primitive.newInstance();
            primitive._count = this._count;
            int n = this._count;
            while (n > 0) {
                primitive._data[--n] = this._data[n];
            }
            return primitive;
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            if (n2 <= this._count && n2 >= n) {
                int n4 = n;
                int n5 = n3;
                while (n4 < n2) {
                    cArray[n5++] = this._data[n4++];
                }
            } else {
                throw new IndexOutOfBoundsException();
            }
        }

        public Text plus(Text text) {
            int n = this._count + text._count;
            if (n <= 32) {
                Primitive primitive = Primitive.newInstance();
                primitive._count = this._count;
                int n2 = this._count;
                while (n2 > 0) {
                    primitive._data[--n2] = this._data[n2];
                }
                n2 = 0;
                while (n2 < text._count) {
                    primitive._data[primitive._count++] = text.charAt(n2++);
                }
                return primitive;
            }
            return Composite.newInstance(this, text);
        }

        public Text replace(char c, char c2) {
            int n = 0;
            while (n < this._count) {
                if (this._data[n++] != c) continue;
                Primitive primitive = Primitive.newInstance();
                primitive._count = this._count;
                int n2 = this._count;
                while (n2 > 0) {
                    char c3 = this._data[--n2];
                    primitive._data[n2] = c3 == c ? c2 : c3;
                }
                return primitive;
            }
            return this;
        }

        public String stringValue() {
            return new String(this._data, 0, this._count);
        }
    }
}

