/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import javolution.JavolutionError;
import javolution.io.Union;
import javolution.io.Utf8ByteBufferReader;
import javolution.io.Utf8ByteBufferWriter;
import javolution.lang.Appendable;
import javolution.lang.Enum;
import javolution.lang.TextBuilder;
import javolution.lang.TypeFormat;
import javolution.realtime.LocalContext;
import javolution.util.FastList;
import javolution.util.Reflection;

public class Struct {
    private static final LocalContext.Variable OUTER = new LocalContext.Variable();
    private final FastList _inners = new FastList();
    private ByteBuffer _byteBuffer;
    private int _byteBufferPosition;
    private int _bitsUsed;
    private int _alignment;
    private int _bitIndex;
    private boolean _resetIndex = this instanceof Union;
    private final Struct _outer = (Struct)OUTER.getValue();
    private int _outerOffset;
    private static final Reflection.Method ADDRESS_METHOD = Reflection.getMethod("sun.nio.ch.DirectBuffer.address()");
    private static final Struct STRUCT = new Struct();
    private static final Class MEMBER = STRUCT.new Member().getClass();
    private static final Class BOOL = STRUCT.new Bool().getClass();
    private static final Class SIGNED_8 = STRUCT.new Signed8().getClass();
    private static final Class UNSIGNED_8 = STRUCT.new Unsigned8().getClass();
    private static final Class SIGNED_16 = STRUCT.new Signed16().getClass();
    private static final Class UNSIGNED_16 = STRUCT.new Unsigned16().getClass();
    private static final Class SIGNED_32 = STRUCT.new Signed32().getClass();
    private static final Class UNSIGNED_32 = STRUCT.new Unsigned32().getClass();
    private static final Class SIGNED_64 = STRUCT.new Unsigned32().getClass();
    private static final Class FLOAT_32 = STRUCT.new Float32().getClass();
    private static final Class FLOAT_64 = STRUCT.new Float64().getClass();

    public final int size() {
        int n = this._bitsUsed + 7 >> 3;
        return n % this._alignment == 0 ? n : n + this._alignment - n % this._alignment;
    }

    public final ByteBuffer getByteBuffer() {
        return this._byteBuffer != null ? this._byteBuffer : this.newBuffer();
    }

    private ByteBuffer newBuffer() {
        if (this._outer == null) {
            int n = this.size();
            int n2 = this.isPacked() ? ((n & 7) == 0 ? n : n + 8 - (n & 7)) : n;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
            byteBuffer.order(this.byteOrder());
            this.setByteBuffer(byteBuffer, 0);
            return this._byteBuffer;
        }
        return this._outer.newBuffer();
    }

    public final void setByteBuffer(ByteBuffer byteBuffer, int n) {
        this._byteBuffer = byteBuffer;
        this._byteBufferPosition = n;
        Iterator iterator = this._inners.fastIterator();
        while (iterator.hasNext()) {
            Struct struct = (Struct)iterator.next();
            struct.setByteBuffer(byteBuffer, n + struct._outerOffset);
        }
    }

    public final int getByteBufferPosition() {
        return this._byteBufferPosition;
    }

    public final long address() {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (ADDRESS_METHOD != null) {
            Long l = (Long)ADDRESS_METHOD.invoke(byteBuffer);
            return l + (long)this._byteBufferPosition;
        }
        throw new UnsupportedOperationException("Operation not supported for " + byteBuffer.getClass());
    }

    public String toString() {
        try {
            TextBuilder textBuilder = TextBuilder.newInstance();
            int n = this.size();
            ByteBuffer byteBuffer = this.getByteBuffer();
            for (int i = 0; i < n; ++i) {
                int n2 = byteBuffer.get(i + this._byteBufferPosition) & 0xFF;
                if (n2 < 16) {
                    textBuilder.append('0');
                }
                TypeFormat.format(n2, 16, (Appendable)textBuilder);
                if ((i & 0xF) == 15) {
                    textBuilder.append('\n');
                    continue;
                }
                textBuilder.append(' ');
            }
            return textBuilder.toString();
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public ByteOrder byteOrder() {
        if (this._outer != null) {
            return this._outer.byteOrder();
        }
        return ByteOrder.BIG_ENDIAN;
    }

    public boolean isPacked() {
        if (this._outer != null) {
            return this._outer.isPacked();
        }
        return false;
    }

    protected Object newInstance(Class clazz) {
        if (clazz == BOOL) {
            return new Bool();
        }
        if (clazz == SIGNED_8) {
            return new Signed8();
        }
        if (clazz == UNSIGNED_8) {
            return new Unsigned8();
        }
        if (clazz == SIGNED_16) {
            return new Signed16();
        }
        if (clazz == UNSIGNED_16) {
            return new Unsigned16();
        }
        if (clazz == SIGNED_32) {
            return new Signed32();
        }
        if (clazz == UNSIGNED_32) {
            return new Unsigned32();
        }
        if (clazz == SIGNED_64) {
            return new Signed64();
        }
        if (clazz == FLOAT_32) {
            return new Float32();
        }
        if (clazz == FLOAT_64) {
            return new Float64();
        }
        throw new UnsupportedOperationException(clazz + " not recognized or invalid");
    }

    public class Enum64
    extends Member {
        private final long _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum64(List list) {
            this(list, 64);
        }

        public Enum64(List list, int n) {
            this._enumValues = list;
            this.updateIndexes(8, n, 64);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 64 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 64 ? -1L : (1L << n) - 1L << this._shift;
            this._signShift = 64 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == -1L) {
                return (Enum)this._enumValues.get((int)Struct.this.getByteBuffer().getLong(this.position()));
            }
            long l = Struct.this.getByteBuffer().getLong(this.position());
            l &= this._mask;
            l <<= this._signShift;
            return (Enum)this._enumValues.get((int)(l >>= this._signShift + this._shift));
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            long l = n;
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putLong(this.position(), l);
            } else {
                l <<= this._shift;
                long l2 = Struct.this.getByteBuffer().getLong(this.position()) & (this._mask ^ 0xFFFFFFFFFFFFFFFFL);
                Struct.this.getByteBuffer().putLong(this.position(), l2 | (l &= this._mask));
            }
        }
    }

    public class Enum32
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum32(List list) {
            this(list, 32);
        }

        public Enum32(List list, int n) {
            this._enumValues = list;
            this.updateIndexes(4, n, 32);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? -1 : (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == -1) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().getInt(this.position()));
            }
            int n = Struct.this.getByteBuffer().getInt(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (Enum)this._enumValues.get(n >>= this._signShift + this._shift);
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            int n2 = n;
            if (this._mask == -1) {
                Struct.this.getByteBuffer().putInt(this.position(), n2);
            } else {
                n2 <<= this._shift;
                int n3 = Struct.this.getByteBuffer().getInt(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putInt(this.position(), n3 | (n2 &= this._mask));
            }
        }
    }

    public class Enum16
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum16(List list) {
            this(list, 16);
        }

        public Enum16(List list, int n) {
            this._enumValues = list;
            this.updateIndexes(2, n, 16);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == 65535) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().getShort(this.position()));
            }
            int n = Struct.this.getByteBuffer().getShort(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (Enum)this._enumValues.get(n >>= this._signShift + this._shift);
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            short s = (short)n;
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n2 = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(n2 | s));
            }
        }
    }

    public class Enum8
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum8(List list) {
            this(list, 8);
        }

        public Enum8(List list, int n) {
            this._enumValues = list;
            this.updateIndexes(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == 255) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().get(this.position()));
            }
            int n = Struct.this.getByteBuffer().get(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (Enum)this._enumValues.get(n >>= this._signShift + this._shift);
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            byte by = (byte)n;
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), by);
            } else {
                by = (byte)(by << this._shift);
                by = (byte)(by & this._mask);
                int n2 = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(n2 | by));
            }
        }
    }

    public class Reference64
    extends Member {
        private final Class _structClass;
        private Struct _struct;

        public Reference64(Class clazz) {
            super(8, 8);
            this._structClass = clazz;
        }

        public void set(Struct struct) {
            if (this._structClass.isInstance(struct)) {
                Struct.this.getByteBuffer().putLong(this.position(), struct.address());
            } else if (struct == null) {
                Struct.this.getByteBuffer().putLong(this.position(), 0L);
            } else {
                throw new IllegalArgumentException("struct: Is an instance of " + struct.getClass() + ", instance of " + this._structClass + " expected");
            }
            this._struct = struct;
        }

        public Struct get() {
            return this._struct;
        }

        public long value() {
            return Struct.this.getByteBuffer().getLong(this.position());
        }

        public boolean isUpToDate() {
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getLong(this.position()) == this._struct.address();
            }
            return Struct.this.getByteBuffer().getLong(this.position()) == 0L;
        }
    }

    public class Reference32
    extends Member {
        private final Class _structClass;
        private Struct _struct;

        public Reference32(Class clazz) {
            super(4, 4);
            this._structClass = clazz;
        }

        public void set(Struct struct) {
            if (this._structClass.isInstance(struct)) {
                Struct.this.getByteBuffer().putInt(this.position(), (int)struct.address());
            } else if (struct == null) {
                Struct.this.getByteBuffer().putInt(this.position(), 0);
            } else {
                throw new IllegalArgumentException("struct: Is an instance of " + struct.getClass() + ", instance of " + this._structClass + " expected");
            }
            this._struct = struct;
        }

        public Struct get() {
            return this._struct;
        }

        public int value() {
            return Struct.this.getByteBuffer().getInt(this.position());
        }

        public boolean isUpToDate() {
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getInt(this.position()) == (int)this._struct.address();
            }
            return Struct.this.getByteBuffer().getInt(this.position()) == 0;
        }
    }

    public class Float64
    extends Member {
        public Float64() {
            super(8, 8);
        }

        public void set(double d) {
            Struct.this.getByteBuffer().putDouble(this.position(), d);
        }

        public double get() {
            return Struct.this.getByteBuffer().getDouble(this.position());
        }
    }

    public class Float32
    extends Member {
        public Float32() {
            super(4, 4);
        }

        public void set(float f) {
            Struct.this.getByteBuffer().putFloat(this.position(), f);
        }

        public float get() {
            return Struct.this.getByteBuffer().getFloat(this.position());
        }
    }

    public class Signed64
    extends Member {
        private final long _mask;
        private final int _shift;
        private final int _signShift;

        public Signed64() {
            this(64);
        }

        public Signed64(int n) {
            this.updateIndexes(8, n, 64);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 64 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 64 ? -1L : (1L << n) - 1L << this._shift;
            this._signShift = 64 - this._shift - n;
        }

        public long get() {
            if (this._mask == -1L) {
                return Struct.this.getByteBuffer().getLong(this.position());
            }
            long l = Struct.this.getByteBuffer().getLong(this.position());
            l &= this._mask;
            l <<= this._signShift;
            return l >>= this._signShift + this._shift;
        }

        public void set(long l) {
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putLong(this.position(), l);
            } else {
                l <<= this._shift;
                long l2 = Struct.this.getByteBuffer().getLong(this.position()) & (this._mask ^ 0xFFFFFFFFFFFFFFFFL);
                Struct.this.getByteBuffer().putLong(this.position(), l2 | (l &= this._mask));
            }
        }
    }

    public class Unsigned32
    extends Member {
        private final int _shift;
        private final long _mask;

        public Unsigned32() {
            this(32);
        }

        public Unsigned32(int n) {
            this.updateIndexes(4, n, 32);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? 0xFFFFFFFFL : (1L << n) - 1L << this._shift;
        }

        public long get() {
            int n = Struct.this.getByteBuffer().getInt(this.position());
            return ((long)n & this._mask) >>> this._shift;
        }

        public void set(long l) {
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putInt(this.position(), (int)l);
            } else {
                l <<= this._shift;
                int n = Struct.this.getByteBuffer().getInt(this.position()) & ~((int)this._mask);
                Struct.this.getByteBuffer().putInt(this.position(), (int)((long)n | (l &= this._mask)));
            }
        }
    }

    public class Signed32
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed32() {
            this(32);
        }

        public Signed32(int n) {
            this.updateIndexes(4, n, 32);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? -1 : (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public int get() {
            if (this._mask == -1) {
                return Struct.this.getByteBuffer().getInt(this.position());
            }
            int n = Struct.this.getByteBuffer().getInt(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return n >>= this._signShift + this._shift;
        }

        public void set(int n) {
            if (this._mask == -1) {
                Struct.this.getByteBuffer().putInt(this.position(), n);
            } else {
                n <<= this._shift;
                int n2 = Struct.this.getByteBuffer().getInt(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putInt(this.position(), n2 | (n &= this._mask));
            }
        }
    }

    public class Unsigned16
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned16() {
            this(16);
        }

        public Unsigned16(int n) {
            this.updateIndexes(2, n, 16);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public int get() {
            short s = Struct.this.getByteBuffer().getShort(this.position());
            return (s & this._mask) >>> this._shift;
        }

        public void set(int n) {
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), (short)n);
            } else {
                n <<= this._shift;
                int n2 = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(n2 | (n &= this._mask)));
            }
        }
    }

    public class Signed16
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed16() {
            this(16);
        }

        public Signed16(int n) {
            this.updateIndexes(2, n, 16);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public short get() {
            if (this._mask == 65535) {
                return Struct.this.getByteBuffer().getShort(this.position());
            }
            int n = Struct.this.getByteBuffer().getShort(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (short)(n >>= this._signShift + this._shift);
        }

        public void set(short s) {
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(n | s));
            }
        }
    }

    public class Unsigned8
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned8() {
            this(8);
        }

        public Unsigned8(int n) {
            this.updateIndexes(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public short get() {
            byte by = Struct.this.getByteBuffer().get(this.position());
            return (short)((by & this._mask) >>> this._shift);
        }

        public void set(short s) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), (byte)s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(n | s));
            }
        }
    }

    public class Signed8
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed8() {
            this(8);
        }

        public Signed8(int n) {
            this.updateIndexes(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public byte get() {
            if (this._mask == 255) {
                return Struct.this.getByteBuffer().get(this.position());
            }
            int n = Struct.this.getByteBuffer().get(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (byte)(n >>= this._signShift + this._shift);
        }

        public void set(byte by) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), by);
            } else {
                by = (byte)(by << this._shift);
                by = (byte)(by & this._mask);
                int n = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(n | by));
            }
        }
    }

    public class Bool
    extends Member {
        private final int _mask;
        private final int _shift;

        public Bool() {
            this(8);
        }

        public Bool(int n) {
            this.updateIndexes(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public boolean get() {
            return (Struct.this.getByteBuffer().get(this.position()) & this._mask) != 0;
        }

        public void set(boolean bl) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), (byte)(bl ? 1 : 0));
            } else {
                int n = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                if (bl) {
                    Struct.this.getByteBuffer().put(this.position(), (byte)(n | 1 << this._shift));
                } else {
                    Struct.this.getByteBuffer().put(this.position(), (byte)n);
                }
            }
        }
    }

    public class Utf8String
    extends Member {
        private final Utf8ByteBufferWriter _writer = new Utf8ByteBufferWriter();
        private final Utf8ByteBufferReader _reader = new Utf8ByteBufferReader();
        private final char[] _chars;
        private final int _length;

        public Utf8String(int n) {
            super(1, n);
            this._length = n;
            this._chars = new char[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    ((Buffer)byteBuffer).position(this.position());
                    this._writer.setByteBuffer(byteBuffer);
                    if (string.length() < this._length) {
                        this._writer.write(string);
                        this._writer.write(0);
                    } else if (string.length() > this._length) {
                        this._writer.write(string.substring(0, this._length));
                    } else {
                        this._writer.write(string);
                    }
                }
                catch (IOException iOException) {
                    throw new JavolutionError(iOException);
                }
            }
        }

        public String get() {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    ((Buffer)byteBuffer).position(this.position());
                    this._reader.setByteBuffer(byteBuffer);
                    int n = 0;
                    while (n < this._length) {
                        char c = (char)this._reader.read();
                        if (c == '\u0000') {
                            return new String(this._chars, 0, n);
                        }
                        this._chars[n++] = c;
                    }
                    return new String(this._chars, 0, this._length);
                }
                catch (IOException iOException) {
                    throw new JavolutionError(iOException);
                }
            }
        }
    }

    public final class ArrayMember
    extends Member {
        private final Object _array;
        private final Class _componentType;

        public ArrayMember(Object[] objectArray) {
            String string = objectArray.getClass().getName();
            String string2 = string.substring(2, string.length() - 1);
            try {
                this._componentType = Reflection.getClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JavolutionError(classNotFoundException);
            }
            this._array = objectArray;
            if (Struct.this._resetIndex) {
                Struct.this._bitIndex = 0;
                Struct.this._resetIndex = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.newInstance(this._componentType);
                }
                Struct.this._resetIndex = true;
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.newInstance(this._componentType);
                }
            }
        }

        public ArrayMember(Object[][] objectArray) {
            String string = objectArray.getClass().getName();
            String string2 = string.substring(3, string.length() - 1);
            try {
                this._componentType = Reflection.getClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JavolutionError(classNotFoundException);
            }
            this._array = objectArray;
            if (Struct.this._resetIndex) {
                Struct.this._bitIndex = 0;
                Struct.this._resetIndex = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    for (int j = 0; j < objectArray[i].length; ++j) {
                        objectArray[i][j] = this.newInstance(this._componentType);
                    }
                }
                Struct.this._resetIndex = true;
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    for (int j = 0; j < objectArray[i].length; ++j) {
                        objectArray[i][j] = this.newInstance(this._componentType);
                    }
                }
            }
        }

        public ArrayMember(Object[][][] objectArray) {
            String string = objectArray.getClass().getName();
            String string2 = string.substring(4, string.length() - 1);
            try {
                this._componentType = Reflection.getClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JavolutionError(classNotFoundException);
            }
            this._array = objectArray;
            if (Struct.this._resetIndex) {
                Struct.this._bitIndex = 0;
                Struct.this._resetIndex = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    for (int j = 0; j < objectArray[i].length; ++j) {
                        for (int k = 0; k < objectArray[i][j].length; ++k) {
                            objectArray[i][j][k] = this.newInstance(this._componentType);
                        }
                    }
                }
                Struct.this._resetIndex = true;
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    for (int j = 0; j < objectArray[i].length; ++j) {
                        for (int k = 0; k < objectArray[i][j].length; ++k) {
                            objectArray[i][j][k] = this.newInstance(this._componentType);
                        }
                    }
                }
            }
        }

        public Object get() {
            return this._array;
        }

        public Class componentType() {
            return this._componentType;
        }
    }

    public final class StructMember
    extends Member {
        private final Struct _struct;

        public StructMember(Class clazz) {
            this._struct = (Struct)this.newInstance(clazz);
        }

        public Struct get() {
            return this._struct;
        }
    }

    protected class Member {
        private int _offset;

        Member() {
        }

        protected Member(int n, int n2) {
            int n3 = n2 << 3;
            this.updateIndexes(n, n3, n3);
        }

        public final int offset() {
            return this._offset;
        }

        public final int position() {
            return Struct.this._byteBufferPosition + this._offset;
        }

        void updateIndexes(int n, int n2, int n3) {
            if (n2 > n3) {
                throw new IllegalArgumentException("nbrOfBits: " + n2 + " exceeds capacity: " + n3);
            }
            if (Struct.this._resetIndex) {
                Struct.this._bitIndex = 0;
            }
            n = Struct.this.isPacked() ? 1 : n;
            this._offset = Struct.this._bitIndex / (n << 3) * n;
            int n4 = Struct.this._bitIndex - (this._offset << 3);
            if (n3 < n4 + n2 || n2 == 0 && n4 != 0) {
                this._offset += n;
                Struct.this._bitIndex = (this._offset << 3) + n2;
            } else {
                Struct.this._bitIndex += n2;
            }
            if (Struct.this._bitsUsed < Struct.this._bitIndex) {
                Struct.this._bitsUsed = Struct.this._bitIndex;
            }
            if (Struct.this._alignment < n) {
                Struct.this._alignment = n;
            }
        }

        Object newInstance(Class clazz) {
            Struct struct;
            if (MEMBER.isAssignableFrom(clazz)) {
                return Struct.this.newInstance(clazz);
            }
            LocalContext.enter();
            try {
                OUTER.setValue(Struct.this);
                struct = (Struct)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new JavolutionError(throwable);
            }
            finally {
                LocalContext.exit();
            }
            int n = struct.size() << 3;
            this.updateIndexes(struct._alignment, n, n);
            struct._outerOffset = Struct.this._bitIndex - n >> 3;
            Struct.this._inners.add(struct);
            return struct;
        }
    }
}

