/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.Javolution;
import javolution.realtime.ArrayPool;
import javolution.realtime.PoolContext;
import javolution.realtime.RealtimeObject;

final class Perf_Realtime
extends Javolution
implements Runnable {
    private volatile Object _object;
    private volatile Object[] _objects = new Object[1000];

    Perf_Realtime() {
    }

    public void run() {
        int n;
        int n2;
        Javolution.println("-- Heap versus Stack Allocation (Pool-Context) --");
        Javolution.print("Object heap creation: ");
        Javolution.startTime();
        for (n2 = 0; n2 < 10000; ++n2) {
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new DummyObject();
            }
        }
        Javolution.endTime(10000 * this._objects.length);
        Javolution.print("Object stack creation: ");
        Javolution.startTime();
        for (n2 = 0; n2 < 10000; ++n2) {
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = DummyObject.newInstance();
            }
            PoolContext.exit();
        }
        Javolution.endTime(10000 * this._objects.length);
        Javolution.print("char[128] heap creation: ");
        Javolution.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new char[128];
            }
        }
        Javolution.endTime(1000 * this._objects.length);
        Javolution.print("char[128] stack creation: ");
        Javolution.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = ArrayPool.charArray(128).next();
            }
            PoolContext.exit();
        }
        Javolution.endTime(1000 * this._objects.length);
        Javolution.print("char[256] heap creation: ");
        Javolution.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new char[256];
            }
        }
        Javolution.endTime(1000 * this._objects.length);
        Javolution.print("char[256] stack creation: ");
        Javolution.startTime();
        for (n2 = 0; n2 < 1000; ++n2) {
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = ArrayPool.charArray(256).next();
            }
            PoolContext.exit();
        }
        Javolution.endTime(1000 * this._objects.length);
        Javolution.println("");
    }

    private static final class DummyObject
    extends RealtimeObject {
        static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new DummyObject();
            }
        };

        public static DummyObject newInstance() {
            return (DummyObject)FACTORY.object();
        }
    }
}

