/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.Perf_Io;
import javolution.Perf_Lang;
import javolution.Perf_Realtime;
import javolution.Perf_Util;
import javolution.Perf_Xml;
import javolution.util.Reflection;

public class Javolution {
    public static final String VERSION = "2.2.4 (J2SE 1.4+) January 25 2005";
    private static long _time;
    private static final Reflection.Method NANO_TIME_METHOD;

    protected Javolution() {
    }

    public static void main(String[] stringArray) throws Exception {
        Javolution.println("Javolution - Java(TM) Solution for Real-Time and Embedded Systems");
        Javolution.println("Version 2.2.4 (J2SE 1.4+) January 25 2005 (http://javolution.org)");
        Javolution.println("");
        if (stringArray.length > 0) {
            if (stringArray[0].equals("version")) {
                return;
            }
            if (stringArray[0].equals("test")) {
                Javolution.testing();
                return;
            }
            if (stringArray[0].equals("perf")) {
                Javolution.benchmark();
                return;
            }
        }
        Javolution.println("Usage: java -jar javolution.jar [arg]");
        Javolution.println("where arg is one of:");
        Javolution.println("    version (to show version information only)");
        Javolution.println("    test    (to perform self-tests)");
        Javolution.println("    perf    (to run benchmark)");
    }

    private static void testing() throws Exception {
        Javolution.print("Testing...");
        Javolution.println("");
        Javolution.println("Success");
    }

    private static void benchmark() throws Exception {
        Javolution.println("Benchmark...");
        Javolution.println("");
        Javolution.println("////////////////////////////");
        Javolution.println("// Package: javolution.io //");
        Javolution.println("////////////////////////////");
        new Perf_Io().run();
        Javolution.println("//////////////////////////////");
        Javolution.println("// Package: javolution.lang //");
        Javolution.println("//////////////////////////////");
        new Perf_Lang().run();
        Javolution.println("//////////////////////////////////");
        Javolution.println("// Package: javolution.realtime //");
        Javolution.println("//////////////////////////////////");
        new Perf_Realtime().run();
        Javolution.println("//////////////////////////////");
        Javolution.println("// Package: javolution.util //");
        Javolution.println("//////////////////////////////");
        new Perf_Util().run();
        Javolution.println("/////////////////////////////");
        Javolution.println("// Package: javolution.xml //");
        Javolution.println("/////////////////////////////");
        new Perf_Xml().run();
        Javolution.println("More performance analysis in future versions...");
    }

    public static void println(Object object) {
        System.out.println(object);
    }

    public static void print(Object object) {
        System.out.print(object);
    }

    public static void startTime() {
        _time = Javolution.nanoTime();
    }

    public static void endTime(int n) {
        long l = Javolution.nanoTime() - _time;
        long l2 = l / (long)n;
        if (l2 > 10000000L) {
            System.out.println(l2 / 1000000L + "ms");
        } else if (l2 > 10000L) {
            System.out.println(l2 / 1000L + "\u00b5s");
        } else {
            System.out.println(l2 + "ns");
        }
    }

    private static long nanoTime() {
        if (NANO_TIME_METHOD != null) {
            Long l = (Long)NANO_TIME_METHOD.invoke(null);
            return l;
        }
        return System.currentTimeMillis() * 1000000L;
    }

    static {
        NANO_TIME_METHOD = Reflection.getMethod("java.lang.System.nanoTime()");
    }
}

