/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import net.sourceforge.jeuclid.DOMBuilder;
import net.sourceforge.jeuclid.Defense;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathComponentUI
extends ComponentUI
implements PropertyChangeListener {
    private static final Log LOGGER = LogFactory.getLog(MathComponentUI.class);
    private JMathComponent mathComponent;
    private MathBase base;

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = new Dimension(this.mathComponent.getWidth(), this.mathComponent.getHeight());
        Point start = this.getStartPointWithBordersAndAdjustDimension(dim);
        this.paintBackground(g, dim, start);
        if (this.base != null) {
            Point2D alignOffset = this.calucateAlignmentOffset(g2, dim);
            this.base.paint((Graphics2D)g, (float)alignOffset.getX() + (float)start.x, (float)alignOffset.getY() + (float)start.y);
        }
    }

    private Point2D calucateAlignmentOffset(Graphics2D g2, Dimension dim) {
        float xo = this.mathComponent.getHorizontalAlignment() == 10 || this.mathComponent.getHorizontalAlignment() == 2 ? 0.0f : (this.mathComponent.getHorizontalAlignment() == 11 || this.mathComponent.getHorizontalAlignment() == 4 ? (float)dim.width - this.base.getWidth(g2) : ((float)dim.width - this.base.getWidth(g2)) / 2.0f);
        float yo = this.mathComponent.getVerticalAlignment() == 1 ? 0.0f : (this.mathComponent.getVerticalAlignment() == 3 ? (float)dim.height - this.base.getHeight(g2) : ((float)dim.height - this.base.getHeight(g2)) / 2.0f);
        Point2D.Float alignOffset = new Point2D.Float(xo, yo);
        return alignOffset;
    }

    private void paintBackground(Graphics g, Dimension dim, Point start) {
        Color back = this.getRealBackgroundColor();
        if (back != null) {
            g.setColor(back);
            g.fillRect(start.x, start.y, dim.width, dim.height);
        }
    }

    private Point getStartPointWithBordersAndAdjustDimension(Dimension dim) {
        Insets insets;
        Point start = new Point(0, 0);
        Border border = this.mathComponent.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.mathComponent)) != null) {
            dim.width -= insets.left + insets.right;
            dim.height -= insets.top + insets.bottom;
            start = new Point(insets.left, insets.top);
        }
        return start;
    }

    private Color getRealBackgroundColor() {
        Color back = this.mathComponent.getBackground();
        if (this.mathComponent.isOpaque()) {
            if (back == null) {
                back = Color.WHITE;
            }
            back = new Color(back.getRGB());
        }
        return back;
    }

    @Override
    public void installUI(JComponent c) {
        this.mathComponent = (JMathComponent)c;
        c.addPropertyChangeListener(this);
        this.installDefaults(this.mathComponent);
    }

    protected void installDefaults(JMathComponent c) {
        LookAndFeel.installProperty(c, "opaque", Boolean.FALSE);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.mathComponent = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("document") || name.equals("property")) {
            JMathComponent jc = (JMathComponent)evt.getSource();
            this.redo((Document)evt.getNewValue(), jc.getParameters());
        } else {
            try {
                ParameterKey key = ParameterKey.valueOf(name);
                this.base.setParam(key, evt.getNewValue().toString());
            }
            catch (IllegalArgumentException ia) {
                LOGGER.debug((Object)ia);
            }
        }
    }

    private void redo(Document doc, Map<ParameterKey, String> parameters) {
        if (doc != null) {
            this.base = new MathBase(parameters);
            new DOMBuilder(doc, this.base);
        } else {
            this.base = null;
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Insets insets;
        Dimension dim;
        if (this.base == null || c.getGraphics() == null) {
            dim = this.getPreferredSize(c);
        } else {
            Graphics2D g2d = (Graphics2D)c.getGraphics();
            Defense.notNull(g2d, "g2d");
            dim = new Dimension((int)Math.ceil(this.base.getWidth(g2d)), (int)Math.ceil(this.base.getHeight(g2d)));
        }
        Border border = c.getBorder();
        if (border != null && (insets = border.getBorderInsets(c)) != null) {
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
        }
        return dim;
    }
}

