/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.parser;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.jeuclid.ResourceEntityResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Parser {
    private static final int DETECTION_BUFFER_SIZE = 128;
    private static final String BAD_STREAM_SOURCE = "Bad StreamSource: ";
    private static final String CONTENT_XML = "content.xml";
    private static final String CANNOT_HANDLE_SOURCE = "Cannot handle Source: ";
    private static Parser parser;
    private static final Log LOGGER;
    private final DocumentBuilder builder;

    private Parser() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException uoe) {
            LOGGER.debug((Object)("Unsupported Operation: " + uoe.getMessage()));
        }
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new ResourceEntityResolver());
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                LOGGER.warn((Object)exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                LOGGER.debug((Object)exception);
            }
        });
        this.builder = documentBuilder;
    }

    public static synchronized Parser getParser() throws ParserConfigurationException {
        if (parser == null) {
            parser = new Parser();
        }
        return parser;
    }

    public Document parseStreamSource(StreamSource streamSource) throws SAXException, IOException {
        Document retVal = null;
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream != null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            FilterInputStream filterInput = new FilterInputStream(inputStream){

                public void close() throws IOException {
                }
            };
            ((InputStream)filterInput).mark(128);
            try {
                retVal = this.parseStreamSourceAsXml(new StreamSource(filterInput));
                inputStream.close();
            }
            catch (SAXParseException se) {
                ((InputStream)filterInput).reset();
                try {
                    retVal = this.parseStreamSourceAsOdf(new StreamSource(filterInput));
                }
                catch (IOException io) {
                    throw se;
                }
                inputStream.close();
            }
        }
        if (retVal == null) {
            retVal = this.parseStreamSourceAsXml(streamSource);
        }
        return retVal;
    }

    public Document parseStreamSourceAsOdf(StreamSource streamSource) throws IOException, SAXException {
        InputStream is = streamSource.getInputStream();
        if (is == null) {
            throw new IllegalArgumentException(BAD_STREAM_SOURCE + streamSource);
        }
        ZipInputStream zipStream = new ZipInputStream(is);
        Document document = null;
        ZipEntry entry = zipStream.getNextEntry();
        while (entry != null) {
            if (CONTENT_XML.equals(entry.getName())) {
                document = this.builder.parse(zipStream);
                entry = null;
                continue;
            }
            entry = zipStream.getNextEntry();
        }
        return document;
    }

    public Document parseStreamSourceAsXml(StreamSource streamSource) throws SAXException, IOException {
        InputSource inp;
        InputStream is = streamSource.getInputStream();
        if (is != null) {
            inp = new InputSource(is);
        } else {
            Reader ir = streamSource.getReader();
            if (ir != null) {
                inp = new InputSource(ir);
            } else {
                throw new IllegalArgumentException(BAD_STREAM_SOURCE + streamSource);
            }
        }
        return this.builder.parse(inp);
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public Node parse(Source source) throws SAXException, IOException {
        Node retVal;
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            retVal = this.parseStreamSource(streamSource);
        } else if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            retVal = domSource.getNode();
        } else {
            try {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                DOMResult r = new DOMResult();
                t.transform(source, r);
                retVal = r.getNode();
            }
            catch (TransformerException e) {
                LOGGER.warn((Object)e.getMessage());
                throw new IllegalArgumentException(CANNOT_HANDLE_SOURCE + source);
            }
        }
        return retVal;
    }

    static {
        LOGGER = LogFactory.getLog(Parser.class);
    }
}

