/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.attributes;

import java.awt.Font;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.elements.support.attributes.FontFamily;
import net.sourceforge.jeuclid.font.FontFactory;

public final class MathVariant {
    public static final MathVariant BOLD = new MathVariant(1, FontFamily.SERIF);
    public static final MathVariant BOLD_FRAKTUR = new MathVariant(1, FontFamily.FRAKTUR);
    public static final MathVariant BOLD_ITALIC = new MathVariant(3, FontFamily.SERIF);
    public static final MathVariant BOLD_SANS_SERIF = new MathVariant(1, FontFamily.SANSSERIF);
    public static final MathVariant BOLD_SCRIPT = new MathVariant(1, FontFamily.SCRIPT);
    public static final MathVariant DOUBLE_STRUCK = new MathVariant(0, FontFamily.DOUBLE_STRUCK);
    public static final MathVariant FRAKTUR = new MathVariant(0, FontFamily.FRAKTUR);
    public static final MathVariant ITALIC = new MathVariant(2, FontFamily.SERIF);
    public static final MathVariant MONOSPACE = new MathVariant(0, FontFamily.MONOSPACED);
    public static final MathVariant NORMAL = new MathVariant(0, FontFamily.SERIF);
    public static final MathVariant SANS_SERIF = new MathVariant(0, FontFamily.SANSSERIF);
    public static final MathVariant SANS_SERIF_BOLD_ITALIC = new MathVariant(3, FontFamily.SANSSERIF);
    public static final MathVariant SANS_SERIF_ITALIC = new MathVariant(2, FontFamily.SANSSERIF);
    public static final MathVariant SCRIPT = new MathVariant(0, FontFamily.SCRIPT);
    private static final Map<String, MathVariant> ATTRIBUTEMAP = new HashMap<String, MathVariant>();
    private static final String AWT_SANSSERIF = "sansserif";
    private static final Map<FontFamily, ParameterKey> PARAMFORFONT = new HashMap<FontFamily, ParameterKey>();
    private final int awtStyle;
    private final FontFamily fontFamily;

    public MathVariant(int awtstyle, FontFamily family) {
        this.awtStyle = awtstyle;
        this.fontFamily = family;
    }

    public static MathVariant stringToMathVariant(String variant) {
        if (ATTRIBUTEMAP.isEmpty()) {
            ATTRIBUTEMAP.put("normal", NORMAL);
            ATTRIBUTEMAP.put("bold", BOLD);
            ATTRIBUTEMAP.put("italic", ITALIC);
            ATTRIBUTEMAP.put("bold-italic", BOLD_ITALIC);
            ATTRIBUTEMAP.put("double-struck", DOUBLE_STRUCK);
            ATTRIBUTEMAP.put("bold-fraktur", BOLD_FRAKTUR);
            ATTRIBUTEMAP.put("script", SCRIPT);
            ATTRIBUTEMAP.put("bold-script", BOLD_SCRIPT);
            ATTRIBUTEMAP.put("fraktur", FRAKTUR);
            ATTRIBUTEMAP.put("sans-serif", SANS_SERIF);
            ATTRIBUTEMAP.put("bold-sans-serif", BOLD_SANS_SERIF);
            ATTRIBUTEMAP.put("sans-serif-italic", SANS_SERIF_ITALIC);
            ATTRIBUTEMAP.put("sans-serif-bold-italic", SANS_SERIF_BOLD_ITALIC);
            ATTRIBUTEMAP.put("monospace", MONOSPACE);
        }
        return ATTRIBUTEMAP.get(variant.toLowerCase(Locale.ENGLISH));
    }

    public Font createFont(float size, char c, MathBase base) {
        ParameterKey theParam = PARAMFORFONT.get((Object)this.fontFamily);
        String paramValue = base.getParams().get((Object)theParam);
        String[] fontArray = paramValue.split(",");
        Font font = null;
        FontFactory fontFactory = FontFactory.getInstance();
        for (int i = 0; i < fontArray.length && font == null; ++i) {
            font = fontFactory.getFont(fontArray[i], this.awtStyle, (int)size);
            if (font.getFamily().equalsIgnoreCase(fontArray[i].trim())) {
                if (font.canDisplay(c)) continue;
                font = null;
                continue;
            }
            font = null;
        }
        if (font == null) {
            font = fontFactory.getFont(AWT_SANSSERIF, this.awtStyle, (int)size);
        }
        return font;
    }

    public int getAwtStyle() {
        return this.awtStyle;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    static {
        PARAMFORFONT.put(FontFamily.SERIF, ParameterKey.FontsSerif);
        PARAMFORFONT.put(FontFamily.SANSSERIF, ParameterKey.FontsSanserif);
        PARAMFORFONT.put(FontFamily.MONOSPACED, ParameterKey.FontsMonospaced);
        PARAMFORFONT.put(FontFamily.SCRIPT, ParameterKey.FontsScript);
        PARAMFORFONT.put(FontFamily.FRAKTUR, ParameterKey.FontsFraktur);
        PARAMFORFONT.put(FontFamily.DOUBLE_STRUCK, ParameterKey.FontsDoublestruck);
    }
}

