/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import org.w3c.dom.mathml.MathMLPresentationToken;

public abstract class AbstractTokenWithTextLayout
extends AbstractJEuclidElement
implements MathMLPresentationToken {
    private TextLayout layout;
    private float xOffset;

    public AbstractTokenWithTextLayout(MathBase base) {
        super(base);
    }

    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        if (!this.isEmpty()) {
            this.produceTextLayout(g);
            this.layout.draw(g, posX + this.xOffset, posY);
        }
    }

    protected abstract AttributedString textContentAsAttributedString();

    protected abstract boolean isEmpty();

    private void produceTextLayout(Graphics2D g2d) {
        if (this.layout == null) {
            this.layout = StringUtil.createTextLayoutFromAttributedString(g2d, this.textContentAsAttributedString(), this.getMathBase());
            Rectangle2D r2d = this.layout.getBounds();
            float xo = (float)r2d.getX();
            this.xOffset = xo < 0.0f ? -xo : 0.0f;
        }
    }

    public TextLayout getLayout() {
        return this.layout;
    }

    public float calculateWidth(Graphics2D g) {
        if (this.isEmpty()) {
            return 0.0f;
        }
        this.produceTextLayout(g);
        return StringUtil.getWidthForTextLayout(this.layout) + this.xOffset;
    }

    public float calculateAscentHeight(Graphics2D g) {
        if (this.isEmpty()) {
            return g.getFontMetrics().getAscent();
        }
        this.produceTextLayout(g);
        Rectangle2D textBounds = this.layout.getBounds();
        return (float)(-textBounds.getY());
    }

    public float calculateDescentHeight(Graphics2D g) {
        if (this.isEmpty()) {
            return g.getFontMetrics().getDescent();
        }
        this.produceTextLayout(g);
        Rectangle2D textBounds = this.layout.getBounds();
        return (float)(textBounds.getY() + textBounds.getHeight());
    }

    protected void changeHook() {
        super.changeHook();
        this.layout = null;
    }
}

