/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.table;

import java.awt.Graphics2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import org.w3c.dom.mathml.MathMLNodeList;
import org.w3c.dom.mathml.MathMLTableCellElement;
import org.w3c.dom.mathml.MathMLTableRowElement;

public class Mtr
extends AbstractJEuclidElement
implements MathMLTableRowElement {
    public static final String ELEMENT = "mtr";

    public Mtr(MathBase base) {
        super(base);
        this.setDefaultMathAttribute("groupalign", "");
    }

    public String getRowalign() {
        return this.getMathAttribute("rowalign");
    }

    public void setRowalign(String rowalign) {
        this.setAttribute("rowalign", rowalign);
    }

    public String getColumnalign() {
        return this.getMathAttribute("columnalign");
    }

    public void setColumnalign(String columnalign) {
        this.setAttribute("columnalign", columnalign);
    }

    public String getGroupalign() {
        return this.getMathAttribute("groupalign");
    }

    public void setGroupalign(String groupalign) {
        this.setAttribute("groupalign", groupalign);
    }

    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        float columnwidth = this.getMaxColumnWidth(g);
        float pos = posX;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            this.getMathElement(i).paint(g, pos, posY);
            pos += columnwidth;
        }
    }

    protected float getMaxColumnWidth(Graphics2D g) {
        float width = 0.0f;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            width = Math.max(width, this.getMathElement(i).getWidth(g));
        }
        return width;
    }

    public float calculateWidth(Graphics2D g) {
        return this.getMaxColumnWidth(g) * (float)this.getMathElementCount();
    }

    public float calculateAscentHeight(Graphics2D g) {
        float height = 0.0f;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            height = Math.max(height, this.getMathElement(i).getAscentHeight(g));
        }
        return height;
    }

    public float calculateDescentHeight(Graphics2D g) {
        float height = 0.0f;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            height = Math.max(height, this.getMathElement(i).getDescentHeight(g));
        }
        return height;
    }

    public String getTagName() {
        return ELEMENT;
    }

    public void deleteCell(int index) {
        throw new UnsupportedOperationException();
    }

    public MathMLNodeList getCells() {
        throw new UnsupportedOperationException();
    }

    public MathMLTableCellElement insertCell(MathMLTableCellElement newCell, int index) {
        throw new UnsupportedOperationException();
    }

    public MathMLTableCellElement insertEmptyCell(int index) {
        throw new UnsupportedOperationException();
    }

    public MathMLTableCellElement setCell(MathMLTableCellElement newCell, int index) {
        throw new UnsupportedOperationException();
    }
}

