/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import java.awt.Graphics2D;
import net.sourceforge.jeuclid.elements.JEuclidElement;

public final class ScriptSupport {
    private ScriptSupport() {
    }

    private static float getOptimalSubBaselineShift(Graphics2D g, JEuclidElement base, JEuclidElement sub, JEuclidElement sup) {
        float subDescent;
        float subAscent;
        float baseDescent = base != null ? base.getDescentHeight(g) : 0.0f;
        if (sub != null) {
            subAscent = sub.getAscentHeight(g);
            subDescent = sub.getDescentHeight(g);
        } else {
            subAscent = 0.0f;
            subDescent = 0.0f;
        }
        return baseDescent + (subAscent - subDescent) / 2.0f;
    }

    private static float getOptimalSuperBaselineShift(Graphics2D g, JEuclidElement base, JEuclidElement sub, JEuclidElement sup) {
        float subDescent;
        float subAscent;
        float baseAscent = base != null ? base.getAscentHeight(g) : 0.0f;
        if (sub != null) {
            subAscent = sub.getAscentHeight(g);
            subDescent = sub.getDescentHeight(g);
        } else {
            subAscent = 0.0f;
            subDescent = 0.0f;
        }
        return baseAscent - (subAscent - subDescent) / 2.0f;
    }

    private static float getOverlap(Graphics2D g, JEuclidElement sub, JEuclidElement sup, float optimalSubBaselineShift, float optimalSuperBaselineShift) {
        float topSub = -optimalSubBaselineShift + sub.getAscentHeight(g) + 1.0f;
        float bottomSuper = optimalSuperBaselineShift - sup.getDescentHeight(g) - 1.0f;
        float overlap = topSub - bottomSuper;
        return Math.max(0.0f, overlap);
    }

    static float getSubBaselineShift(Graphics2D g, JEuclidElement base, JEuclidElement sub, JEuclidElement sup) {
        float optimalSubBaselineShift = ScriptSupport.getOptimalSubBaselineShift(g, base, sub, sup);
        float overlap = sup != null ? ScriptSupport.getOverlap(g, sub, sup, optimalSubBaselineShift, ScriptSupport.getOptimalSuperBaselineShift(g, base, sub, sup)) : 0.0f;
        return optimalSubBaselineShift + overlap / 2.0f;
    }

    static float getSuperBaselineShift(Graphics2D g, JEuclidElement base, JEuclidElement sub, JEuclidElement sup) {
        float optimalSuperBaselineShift = ScriptSupport.getOptimalSuperBaselineShift(g, base, sub, sup);
        float overlap = sub != null ? ScriptSupport.getOverlap(g, sub, sup, ScriptSupport.getOptimalSubBaselineShift(g, base, sub, sup), optimalSuperBaselineShift) : 0.0f;
        return optimalSuperBaselineShift + overlap / 2.0f;
    }
}

