/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathBase {
    public static final int INLINE = 0;
    public static final int DISPLAY = 1;
    public static final float DEFAULT_FONTSIZE = 12.0f;
    public static final String TRUE = Boolean.TRUE.toString();
    public static final String FALSE = Boolean.FALSE.toString();
    public static final String VALUE_ZERO = "0";
    private DocumentElement rootElement;
    private final Map<ParameterKey, String> renderParams = MathBase.getDefaultParameters();

    public MathBase(Map<ParameterKey, String> params) {
        if (params != null) {
            this.renderParams.putAll(params);
        }
        this.rootElement = new DocumentElement(this);
    }

    public float getAscender(Graphics2D g) {
        return this.rootElement.getAscentHeight(g);
    }

    public float getDescender(Graphics2D g) {
        return this.rootElement.getDescentHeight(g);
    }

    public void setRootElement(DocumentElement element) {
        if (element == null) {
            return;
        }
        this.rootElement = element;
        this.rootElement.setMathBase(this);
    }

    public DocumentElement getRootElement() {
        return this.rootElement;
    }

    public void setDebug(boolean debug) {
        this.renderParams.put(ParameterKey.DebugMode, Boolean.toString(debug));
    }

    public boolean isDebug() {
        return Boolean.parseBoolean(this.renderParams.get((Object)ParameterKey.DebugMode));
    }

    public void paint(Graphics2D g, float x, float y) {
        if (this.rootElement != null) {
            RenderingHints hints = g.getRenderingHints();
            if (Boolean.parseBoolean(this.renderParams.get((Object)ParameterKey.AntiAlias))) {
                hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            }
            hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE));
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            g.setRenderingHints(hints);
            this.rootElement.paint(g, x, y + this.rootElement.getAscentHeight(g));
        }
    }

    public void paint(Graphics2D g) {
        this.paint(g, 0.0f, 0.0f);
    }

    public float getWidth(Graphics2D g) {
        float realWidth = this.rootElement != null ? this.rootElement.getWidth(g) : 0.0f;
        return Math.max(1.0f, realWidth);
    }

    public float getHeight(Graphics2D g) {
        float realHeight = this.rootElement != null ? this.rootElement.getAscentHeight(g) + this.rootElement.getDescentHeight(g) : 0.0f;
        return Math.max(1.0f, realHeight);
    }

    public float getFontSize() {
        return Float.parseFloat(this.getParams().get((Object)ParameterKey.FontSize));
    }

    public Map<ParameterKey, String> getParams() {
        return this.renderParams;
    }

    public void setParam(ParameterKey key, String value) {
        this.renderParams.put(key, value);
        this.rootElement.fireChangeForSubTree();
    }

    public static Map<ParameterKey, String> getDefaultParameters() {
        HashMap<ParameterKey, String> params = new HashMap<ParameterKey, String>();
        params.put(ParameterKey.FontSize, Float.toString(12.0f));
        params.put(ParameterKey.DebugMode, FALSE);
        params.put(ParameterKey.OutFileType, "image/png");
        params.put(ParameterKey.AntiAlias, TRUE);
        params.put(ParameterKey.ForegroundColor, "black");
        params.put(ParameterKey.BackgroundColor, "transparent");
        String symbolCatchFonts = "OpenSymbol,Standard Symbols L,Symbol,Webdings,Wingdings,Wingdings 2,Wingdings 3,Arial Unicode MS,DejaVu Sans";
        params.put(ParameterKey.FontsSanserif, "Verdana,Helvetica,Arial,Arial Unicode MS,Lucida Sans Unicode,Lucida Sans,Lucida Grande,DejaVu Sans,Bitstream Vera Sans,Luxi Sans,FreeSans,sansserif,OpenSymbol,Standard Symbols L,Symbol,Webdings,Wingdings,Wingdings 2,Wingdings 3,Arial Unicode MS,DejaVu Sans");
        params.put(ParameterKey.FontsSerif, "Constantina,Times,Times New Roman,Lucida Bright,DejaVu Serif,Bitstream Vera Serif,Luxi Serif,FreeSerif,serif,OpenSymbol,Standard Symbols L,Symbol,Webdings,Wingdings,Wingdings 2,Wingdings 3,Arial Unicode MS,DejaVu Sans");
        params.put(ParameterKey.FontsMonospaced, "Andale Mono,Courier,Courier Mono,Courier New,Lucida Sans Typewriter,DejaVu Sans Mono,Bitstream Vera Sans Mono,Luxi Mono,FreeMono,monospaced,OpenSymbol,Standard Symbols L,Symbol,Webdings,Wingdings,Wingdings 2,Wingdings 3,Arial Unicode MS,DejaVu Sans");
        params.put(ParameterKey.FontsScript, "Savoye LET,Brush Script MT,Zapfino,Apple Chancery,Edwardian Script ITC,Lucida Handwriting,Monotype Corsiva,Santa Fe LET,OpenSymbol,Standard Symbols L,Symbol,Webdings,Wingdings,Wingdings 2,Wingdings 3,Arial Unicode MS,DejaVu Sans");
        params.put(ParameterKey.FontsFraktur, "FetteFraktur,Fette Fraktur,Euclid Fraktur,Lucida Blackletter,Blackmoor LET,OpenSymbol,Standard Symbols L,Symbol,Webdings,Wingdings,Wingdings 2,Wingdings 3,Arial Unicode MS,DejaVu Sans");
        params.put(ParameterKey.FontsDoublestruck, "Caslon Open Face,Caslon Openface,Cloister Open Face,Academy Engraved LET,Colonna MT,Imprint MT Shadow,OpenSymbol,Standard Symbols L,Symbol,Webdings,Wingdings,Wingdings 2,Wingdings 3,Arial Unicode MS,DejaVu Sans");
        return params;
    }
}

