/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.time;

import thunderheadeng.util.time.AClock;

public class WallClock
extends AClock {
    private long d_timeOffset;
    private long d_timeOnResume;

    public WallClock() {
        this(0.0, 1.0);
    }

    public WallClock(double d, double d2) {
        this.setScale(d2);
        this.setTime(d);
    }

    @Override
    public void setScale(double d) {
        if (this.isPaused()) {
            this.d_timeOnResume = (long)((double)this.d_timeOnResume * this.getScale() / d);
        } else {
            long l = System.nanoTime();
            long l2 = l - this.d_timeOffset;
            this.d_timeOffset = l - (long)(this.getScale() / d * (double)l2);
        }
        super.setScale(d);
    }

    @Override
    public void setTime(double d) {
        double[] dArray = this.getRange();
        if (d > dArray[1]) {
            d = dArray[1];
        } else if (d < dArray[0]) {
            d = dArray[0];
        }
        long l = System.nanoTime();
        long l2 = this.toTickUnit(d);
        if (this.isPaused()) {
            this.d_timeOnResume = l2;
        } else {
            this.d_timeOffset = l - l2;
        }
    }

    @Override
    public double getTime() {
        double d = this.isPaused() ? this.toTimeUnit(this.d_timeOnResume) : this.toTimeUnit(System.nanoTime() - this.d_timeOffset);
        return this.clampTime(d);
    }

    @Override
    public double pause() {
        if (this.isPaused()) {
            return this.getTime();
        }
        this.d_timeOnResume = System.nanoTime() - this.d_timeOffset;
        super.pause();
        return (double)this.d_timeOnResume * 1.0E-9 * this.getScale();
    }

    @Override
    public double resume() {
        if (!this.isPaused()) {
            return this.getTime();
        }
        super.resume();
        this.d_timeOffset = System.nanoTime() - this.d_timeOnResume;
        return (double)this.d_timeOnResume * 1.0E-9 * this.getScale();
    }

    private double toTimeUnit(long l) {
        return (double)l * 1.0E-9 * this.getScale();
    }

    private long toTickUnit(double d) {
        return (long)(d / (1.0E-9 * this.getScale()));
    }
}

