/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.awt.geom.CubicCurve2D;
import java.util.Arrays;

public class theMath {
    private static double[] s_mults = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16};

    public static double[] solveCubic(double d, double d2, double d3, double d4) {
        if (d == 0.0) {
            return theMath.solveQuadratic(d2, d3, d4);
        }
        double[] dArray = new double[]{d4, d3, d2, d};
        int n = CubicCurve2D.solveCubic(dArray);
        if (n < 0) {
            return new double[0];
        }
        return Arrays.copyOf(dArray, n);
    }

    public static double[] solveQuadratic(double d, double d2, double d3) {
        if (d == 0.0) {
            double[] dArray;
            double d4 = theMath.solveLinear(d2, d3);
            if (Double.isNaN(d4)) {
                dArray = new double[]{};
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = d4;
            }
            return dArray;
        }
        double d5 = d2 * d2;
        double d6 = 4.0 * d * d3;
        if (d5 < d6) {
            return new double[0];
        }
        double d7 = 1.0 / (2.0 * d);
        double d8 = -d2 * d7;
        double d9 = Math.sqrt(d5 - d6) * d7;
        double d10 = d8 + d9;
        double d11 = d8 - d9;
        return new double[]{d10, d11};
    }

    public static double solveLinear(double d, double d2) {
        if (d == 0.0) {
            return Double.NaN;
        }
        return -d2 / d;
    }

    public static double round(double d, int n) {
        double d2 = s_mults[n];
        double d3 = Math.rint(d * d2) / d2;
        if (d3 == -0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    public static double round(double d, double d2) {
        double d3 = Math.rint(d / d2) * d2;
        if (d3 == -0.0) {
            d3 = 0.0;
        }
        return d3;
    }
}

