/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.util.Map;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class UrnUtil {
    public static <T> IUrn<T> newUrn(Map<T, Double> map) {
        double d = Double.NaN;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            if (Double.isNaN(d)) {
                d = entry.getValue();
                continue;
            }
            if (theUtil.eq(d, entry.getValue(), 1.0E-6)) continue;
            return new InfiniteUrn<T>(map);
        }
        return new Urn<T>(map.keySet());
    }

    public static <T> Urn<T> makeFinite(IUrn<T> iUrn, int n) {
        Object object;
        if (iUrn instanceof Urn) {
            object = (Urn)iUrn;
            if (((Urn)object).getValues().size() == n) {
                return object;
            }
        } else if (iUrn instanceof InfiniteUrn) {
            return ((InfiniteUrn)iUrn).distribute(n);
        }
        object = iUrn.getWeights();
        return new InfiniteUrn(object).distribute(n);
    }

    public static <T> InfiniteUrn<T> makeInfinite(IUrn<T> iUrn) {
        if (iUrn instanceof InfiniteUrn) {
            return (InfiniteUrn)iUrn;
        }
        return new InfiniteUrn<T>(iUrn.getWeights());
    }

    public static <T> T getDominant(IUrn<T> iUrn) {
        double d = 0.0;
        T t = null;
        for (Map.Entry<T, Double> entry : iUrn.getWeights().entrySet()) {
            if (!(entry.getValue() > d)) continue;
            d = entry.getValue();
            t = entry.getKey();
        }
        return t;
    }
}

